/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.math;

import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Sign
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("sign" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("sign" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object obj = this.param.getLeafExpression().calculate(ctx);
        if (obj instanceof Integer) {
            int cmp = Integer.compare((Integer)obj, 0);
            return ObjectCache.getInteger(cmp);
        }
        if (obj instanceof Long) {
            int cmp = Long.compare((Long)obj, 0L);
            return ObjectCache.getInteger(cmp);
        }
        if (obj instanceof Double) {
            int cmp = Double.compare((Double)obj, 0.0);
            return ObjectCache.getInteger(cmp);
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)obj;
            int cmp = bd.compareTo(BigDecimal.ZERO);
            return ObjectCache.getInteger(cmp);
        }
        if (obj instanceof BigInteger) {
            BigInteger bi = (BigInteger)obj;
            int cmp = bi.compareTo(BigInteger.ZERO);
            return ObjectCache.getInteger(cmp);
        }
        if (obj instanceof Number) {
            int cmp = Integer.compare(((Number)obj).intValue(), 0);
            return ObjectCache.getInteger(cmp);
        }
        if (obj == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("sign" + mm.getMessage("function.paramTypeError"));
    }
}

