/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.string;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.DatatypeConverter;

public class Base64
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("base64" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object val = this.param.getLeafExpression().calculate(ctx);
            if (val instanceof String) {
                return DatatypeConverter.parseBase64Binary((String)((String)val));
            }
            if (val instanceof byte[]) {
                return DatatypeConverter.printBase64Binary((byte[])((byte[])val));
            }
            if (val == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("base64" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("base64" + mm.getMessage("function.invalidParam"));
        }
        IParam sub0 = this.param.getSub(0);
        IParam sub1 = this.param.getSub(1);
        if (sub0 == null || sub1 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("base64" + mm.getMessage("function.invalidParam"));
        }
        Object obj = sub0.getLeafExpression().calculate(ctx);
        if (!(obj instanceof String)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("base64" + mm.getMessage("function.paramTypeError"));
        }
        String value = (String)obj;
        obj = sub1.getLeafExpression().calculate(ctx);
        if (!(obj instanceof String)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("base64" + mm.getMessage("function.paramTypeError"));
        }
        String cs = (String)obj;
        try {
            if (this.param.getType() == ':') {
                byte[] bytes = value.getBytes(cs);
                return DatatypeConverter.printBase64Binary((byte[])bytes);
            }
            byte[] bytes = DatatypeConverter.parseBase64Binary((String)value);
            return new String(bytes, cs);
        }
        catch (UnsupportedEncodingException e) {
            throw new RQException(e);
        }
    }
}

