/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.string;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.io.UnsupportedEncodingException;

public class Len
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("len" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                return ObjectCache.getInteger(((String)obj).length());
            }
            if (obj == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("len" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("len" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub0.getLeafExpression().calculate(ctx);
            if (obj instanceof String) {
                String str = (String)obj;
                String cs = "GB2312";
                IParam sub1 = this.param.getSub(1);
                if (sub1 != null) {
                    obj = sub1.getLeafExpression().calculate(ctx);
                    if (obj instanceof String) {
                        cs = (String)obj;
                    } else if (obj != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                    }
                }
                try {
                    return ObjectCache.getInteger(str.getBytes(cs).length);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RQException(e.getMessage(), e);
                }
            }
            if (obj == null) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("len" + mm.getMessage("function.paramTypeError"));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("len" + mm.getMessage("function.invalidParam"));
    }

    public IArray calculateAll(Context ctx) {
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx);
            int size = array.size();
            if (array instanceof ConstArray) {
                Object obj = array.get(1);
                if (obj instanceof String) {
                    obj = ObjectCache.getInteger(((String)obj).length());
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                }
                return new ConstArray(obj, size);
            }
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (array instanceof StringArray) {
                StringArray stringArray = (StringArray)array;
                for (int i = 1; i <= size; ++i) {
                    String str = stringArray.getString(i);
                    if (str != null) {
                        result.pushInt(str.length());
                        continue;
                    }
                    result.pushNull();
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    Object obj = array.get(i);
                    if (obj instanceof String) {
                        result.pushInt(((String)obj).length());
                        continue;
                    }
                    if (obj == null) {
                        result.pushNull();
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                }
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("len" + mm.getMessage("function.invalidParam"));
            }
            IArray array1 = sub0.getLeafExpression().calculateAll(ctx);
            IArray array2 = sub1.getLeafExpression().calculateAll(ctx);
            int size = array1.size();
            try {
                if (array1 instanceof ConstArray && array2 instanceof ConstArray) {
                    Object obj1 = array1.get(1);
                    Object obj2 = array2.get(1);
                    Integer value = null;
                    if (obj1 instanceof String) {
                        String cs;
                        if (obj2 instanceof String) {
                            cs = (String)obj2;
                        } else if (obj2 == null) {
                            cs = "GB2312";
                        } else {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                        }
                        value = ObjectCache.getInteger(((String)obj1).getBytes(cs).length);
                    } else if (obj1 != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                    }
                    return new ConstArray(value, size);
                }
                IntArray result = new IntArray(size);
                result.setTemporary(true);
                if (array1 instanceof StringArray && array2 instanceof ConstArray) {
                    String cs;
                    Object obj2 = array2.get(1);
                    if (obj2 instanceof String) {
                        cs = (String)obj2;
                    } else if (obj2 == null) {
                        cs = "GB2312";
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                    }
                    StringArray stringArray = (StringArray)array1;
                    for (int i = 1; i <= size; ++i) {
                        String str = stringArray.getString(i);
                        if (str != null) {
                            result.pushInt(str.getBytes(cs).length);
                            continue;
                        }
                        result.pushNull();
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        Object obj1 = array1.get(i);
                        Object obj2 = array2.get(i);
                        if (obj1 instanceof String) {
                            String cs;
                            if (obj2 instanceof String) {
                                cs = (String)obj2;
                            } else if (obj2 == null) {
                                cs = "GB2312";
                            } else {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                            }
                            result.pushInt(((String)obj1).getBytes(cs).length);
                            continue;
                        }
                        if (obj1 != null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                        }
                        result.pushNull();
                    }
                }
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("len" + mm.getMessage("function.invalidParam"));
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        if (this.param.isLeaf()) {
            IArray array = this.param.getLeafExpression().calculateAll(ctx);
            int size = array.size();
            if (array instanceof ConstArray) {
                Object obj = array.get(1);
                if (obj instanceof String) {
                    obj = ObjectCache.getInteger(((String)obj).length());
                } else if (obj != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                }
                return new ConstArray(obj, size);
            }
            IntArray result = new IntArray(size);
            result.setTemporary(true);
            if (array instanceof StringArray) {
                StringArray stringArray = (StringArray)array;
                for (int i = 1; i <= size; ++i) {
                    if (!signDatas[i]) {
                        result.pushNull();
                        continue;
                    }
                    String str = stringArray.getString(i);
                    if (str != null) {
                        result.pushInt(str.length());
                        continue;
                    }
                    result.pushNull();
                }
            } else {
                for (int i = 1; i <= size; ++i) {
                    if (!signDatas[i]) {
                        result.pushNull();
                        continue;
                    }
                    Object obj = array.get(i);
                    if (obj instanceof String) {
                        result.pushInt(((String)obj).length());
                        continue;
                    }
                    if (obj == null) {
                        result.pushNull();
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                }
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("len" + mm.getMessage("function.invalidParam"));
            }
            IArray array1 = sub0.getLeafExpression().calculateAll(ctx);
            IArray array2 = sub1.getLeafExpression().calculateAll(ctx);
            int size = array1.size();
            try {
                if (array1 instanceof ConstArray && array2 instanceof ConstArray) {
                    Object obj1 = array1.get(1);
                    Object obj2 = array2.get(1);
                    Integer value = null;
                    if (obj1 instanceof String) {
                        String cs;
                        if (obj2 instanceof String) {
                            cs = (String)obj2;
                        } else if (obj2 == null) {
                            cs = "GB2312";
                        } else {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                        }
                        value = ObjectCache.getInteger(((String)obj1).getBytes(cs).length);
                    } else if (obj1 != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                    }
                    return new ConstArray(value, size);
                }
                IntArray result = new IntArray(size);
                result.setTemporary(true);
                if (array1 instanceof StringArray && array2 instanceof ConstArray) {
                    String cs;
                    Object obj2 = array2.get(1);
                    if (obj2 instanceof String) {
                        cs = (String)obj2;
                    } else if (obj2 == null) {
                        cs = "GB2312";
                    } else {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                    }
                    StringArray stringArray = (StringArray)array1;
                    for (int i = 1; i <= size; ++i) {
                        if (!signDatas[i]) {
                            result.pushNull();
                            continue;
                        }
                        String str = stringArray.getString(i);
                        if (str != null) {
                            result.pushInt(str.getBytes(cs).length);
                            continue;
                        }
                        result.pushNull();
                    }
                } else {
                    for (int i = 1; i <= size; ++i) {
                        if (!signDatas[i]) {
                            result.pushNull();
                            continue;
                        }
                        Object obj1 = array1.get(i);
                        Object obj2 = array2.get(i);
                        if (obj1 instanceof String) {
                            String cs;
                            if (obj2 instanceof String) {
                                cs = (String)obj2;
                            } else if (obj2 == null) {
                                cs = "GB2312";
                            } else {
                                MessageManager mm = EngineMessage.get();
                                throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                            }
                            result.pushInt(((String)obj1).getBytes(cs).length);
                            continue;
                        }
                        if (obj1 != null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("len" + mm.getMessage("function.paramTypeError"));
                        }
                        result.pushNull();
                    }
                }
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("len" + mm.getMessage("function.invalidParam"));
    }
}

