/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.string;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.expression.fn.CharFunction;
import com.scudata.expression.fn.string.DESEncrypt;
import com.scudata.resources.EngineMessage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAEncrypt
extends CharFunction {
    private static final String _$1 = "RSA";

    public static KeyPair generateKeyPair(int n) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(_$1);
        keyGen.initialize(n, new SecureRandom());
        return keyGen.genKeyPair();
    }

    protected Object doQuery(Object[] objs) {
        try {
            boolean dec = false;
            boolean createKey = false;
            boolean modulus = false;
            boolean blob = false;
            boolean decStr = false;
            if (this.option != null) {
                if (this.option.indexOf(107) > -1) {
                    createKey = true;
                }
                if (this.option.indexOf(100) > -1) {
                    dec = true;
                }
                if (this.option.indexOf(109) > -1) {
                    modulus = true;
                }
                if (this.option.indexOf(98) > -1) {
                    blob = true;
                }
                if (this.option.indexOf(115) > -1) {
                    decStr = true;
                }
            }
            if (createKey) {
                int n = 2048;
                if (objs != null && objs.length > 0) {
                    Object setn = objs[0];
                    if (setn instanceof Number) {
                        n = ((Number)setn).intValue();
                    } else if (setn != null) {
                        n = Integer.valueOf(setn.toString());
                    }
                }
                if (n < 512) {
                    MessageManager mm = EngineMessage.get();
                    Logger.info("rsa@k(n): " + mm.getMessage("encrypt.keylen", 512));
                    n = 512;
                }
                KeyPair kp = RSAEncrypt.generateKeyPair(n);
                RSAPublicKey pubKey = (RSAPublicKey)kp.getPublic();
                RSAPrivateKey priKey = (RSAPrivateKey)kp.getPrivate();
                Sequence result = null;
                if (modulus) {
                    result = new Sequence(3);
                    if (blob) {
                        result.add(pubKey.getModulus().toByteArray());
                        result.add(pubKey.getPublicExponent().toByteArray());
                        result.add(priKey.getPrivateExponent().toByteArray());
                    } else {
                        result.add(pubKey.getModulus().toString());
                        result.add(pubKey.getPublicExponent().toString());
                        result.add(priKey.getPrivateExponent().toString());
                    }
                } else {
                    result = new Sequence(2);
                    result.add(pubKey.getEncoded());
                    result.add(priKey.getEncoded());
                }
                return result;
            }
            if (objs == null || objs.length < 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("rsa" + mm.getMessage("function.invalidParam"));
            }
            Object[] params = objs;
            String charset = "utf-8";
            if (this.param.getType() == ';') {
                Object obj = objs[0];
                params = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
                if (objs[1] instanceof String) {
                    charset = (String)objs[1];
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("rsa(...;charset), charset is invalid." + mm.getMessage("function.invalidParam"));
                }
            }
            if (params == null || params.length < 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("rsa" + mm.getMessage("function.invalidParam"));
            }
            byte[] inputb = DESEncrypt.encode(params[0], charset);
            Object objM = null;
            Object objE = null;
            BigInteger bigM = null;
            BigInteger bigE = null;
            Object sub = params[1];
            byte[] mb = null;
            if (sub instanceof Object[]) {
                Object[] subs = (Object[])sub;
                if (subs == null || subs.length < 1) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("rsa" + mm.getMessage("function.invalidParam"));
                }
                objM = subs[0];
                if (subs.length > 1) {
                    objE = subs[1];
                }
            } else {
                objM = sub;
            }
            if (objE != null) {
                bigM = RSAEncrypt.getBigInteger(objM);
                bigE = RSAEncrypt.getBigInteger(objE);
            } else {
                mb = DESEncrypt.encode(objM, charset);
            }
            Cipher ci = Cipher.getInstance(_$1);
            KeyFactory kf = KeyFactory.getInstance(_$1);
            KeySpec keySpec = null;
            keySpec = bigE == null ? new X509EncodedKeySpec(mb) : new RSAPublicKeySpec(bigM, bigE);
            byte[] result = null;
            if (dec) {
                keySpec = bigE != null ? new RSAPrivateKeySpec(bigM, bigE) : new PKCS8EncodedKeySpec(mb);
                PrivateKey key = kf.generatePrivate(keySpec);
                ci.init(2, key);
                result = ci.doFinal(inputb);
                if (decStr) {
                    return DESEncrypt.encode(result, charset);
                }
            } else {
                PublicKey key = kf.generatePublic(keySpec);
                ci.init(1, key);
                result = ci.doFinal(inputb);
            }
            return result;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return null;
        }
    }

    public static BigInteger getBigInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        if (obj instanceof byte[]) {
            return new BigInteger(1, (byte[])obj);
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).toBigInteger();
        }
        if (obj instanceof String) {
            return new BigInteger((String)obj);
        }
        if (obj instanceof Number) {
            return new BigInteger(Long.toString(((Number)obj).longValue()));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("rsa" + mm.getMessage("function.paramTypeError"));
    }
}

