/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.fn.string;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Function;
import com.scudata.resources.EngineMessage;

public class Trim
extends Function {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("trim" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("trim" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object obj = this.param.getLeafExpression().calculate(ctx);
        if (obj instanceof String) {
            return Trim._$1((String)obj, this.option);
        }
        if (obj == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("trim" + mm.getMessage("function.paramTypeError"));
    }

    public IArray calculateAll(Context ctx) {
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            StringArray result = new StringArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                String str = stringArray.getString(i);
                if (str != null) {
                    str = Trim._$1(str, this.option);
                }
                result.push(str);
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj instanceof String) {
                obj = Trim._$1((String)obj, this.option);
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("trim" + mm.getMessage("function.paramTypeError"));
            }
            return new ConstArray(obj, size);
        }
        StringArray result = new StringArray(size);
        result.setTemporary(true);
        for (int i = 1; i <= size; ++i) {
            Object obj = array.get(i);
            String str = null;
            if (obj instanceof String) {
                str = Trim._$1((String)obj, this.option);
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("trim" + mm.getMessage("function.paramTypeError"));
            }
            result.push(str);
        }
        return result;
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        boolean[] signDatas = sign ? signArray.isTrue().getDatas() : signArray.isFalse().getDatas();
        IArray array = this.param.getLeafExpression().calculateAll(ctx);
        int size = array.size();
        if (array instanceof StringArray) {
            StringArray stringArray = (StringArray)array;
            StringArray result = new StringArray(size);
            result.setTemporary(true);
            for (int i = 1; i <= size; ++i) {
                if (!signDatas[i]) {
                    result.pushNull();
                    continue;
                }
                String str = stringArray.getString(i);
                if (str != null) {
                    str = Trim._$1(str, this.option);
                }
                result.push(str);
            }
            return result;
        }
        if (array instanceof ConstArray) {
            Object obj = array.get(1);
            if (obj instanceof String) {
                obj = Trim._$1((String)obj, this.option);
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("trim" + mm.getMessage("function.paramTypeError"));
            }
            return new ConstArray(obj, size);
        }
        StringArray result = new StringArray(size);
        result.setTemporary(true);
        for (int i = 1; i <= size; ++i) {
            if (!signDatas[i]) {
                result.pushNull();
                continue;
            }
            Object obj = array.get(i);
            String str = null;
            if (obj instanceof String) {
                str = Trim._$1((String)obj, this.option);
            } else if (obj != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("trim" + mm.getMessage("function.paramTypeError"));
            }
            result.push(str);
        }
        return result;
    }

    private static String _$1(String str, String option) {
        if (option == null) {
            return str.trim();
        }
        if (option.indexOf(108) != -1) {
            int i = 0;
            int ilength = str.length();
            for (i = 0; i < ilength && Character.isWhitespace(str.charAt(i)); ++i) {
            }
            if (i >= str.length()) {
                return "";
            }
            return str.substring(i);
        }
        if (option.indexOf(114) != -1) {
            int i = 0;
            for (i = str.length() - 1; i >= 0 && Character.isWhitespace(str.charAt(i)); --i) {
            }
            if (i < 0) {
                return "";
            }
            return str.substring(0, i + 1);
        }
        if (option.indexOf(97) != -1) {
            char[] chars = str.toCharArray();
            int len = chars.length;
            StringBuffer sb = new StringBuffer(len);
            boolean isPrevWhiteSpace = true;
            for (int i = 0; i < len; ++i) {
                char c = chars[i];
                if (Character.isWhitespace(c)) {
                    if (isPrevWhiteSpace) continue;
                    isPrevWhiteSpace = true;
                    sb.append(c);
                    continue;
                }
                if (c == '\"' || c == '\'') {
                    int match = Trim._$1(chars, i);
                    if (match > 0) {
                        sb.append(chars, i, match - i + 1);
                        i = match;
                    } else {
                        sb.append(c);
                    }
                    isPrevWhiteSpace = false;
                    continue;
                }
                if (Trim._$1(c)) {
                    int last = sb.length() - 1;
                    if (last >= 0 && Character.isWhitespace(sb.charAt(last))) {
                        sb.deleteCharAt(last);
                    }
                    sb.append(c);
                    isPrevWhiteSpace = true;
                    continue;
                }
                sb.append(c);
                isPrevWhiteSpace = false;
            }
            int last = sb.length() - 1;
            if (last >= 0 && Character.isWhitespace(sb.charAt(last))) {
                sb.deleteCharAt(last);
            }
            return sb.toString();
        }
        return str.trim();
    }

    private static int _$1(char[] chars, int start) {
        char q = chars[start++];
        int len = chars.length;
        while (start < len) {
            if (chars[start] == q && (++start == len || chars[start] != q)) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static boolean _$1(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == ',' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == ':' || c == '{' || c == '}' || c == '^' || c == '.';
    }
}

