/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dw.MemoryTable;
import com.scudata.dw.PhyTable;
import com.scudata.expression.CursorFunction;
import com.scudata.expression.IParam;
import com.scudata.parallel.ClusterCursor;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;

public class Memory
extends CursorFunction {
    public Object calculate(Context ctx) {
        Table table;
        if (this.cursor instanceof ClusterCursor) {
            return Memory._$1((ClusterCursor)this.cursor, this.param, ctx);
        }
        String[] keys = null;
        String distribute = null;
        Integer partition = null;
        PhyTable tmd = CursorUtil.getTableMetaData(this.cursor);
        if (tmd != null) {
            distribute = tmd.getDistribute();
            partition = tmd.getGroupTable().getPartition();
        }
        if (this.param != null) {
            if (this.param.isLeaf()) {
                keys = new String[]{this.param.getLeafExpression().getIdentifierName()};
            } else {
                int size = this.param.getSubSize();
                keys = new String[size];
                for (int i = 0; i < size; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("memory" + mm.getMessage("function.invalidParam"));
                    }
                    keys[i] = sub.getLeafExpression().getIdentifierName();
                }
            }
        }
        if (this.option != null && this.option.indexOf(122) != -1) {
            MemoryTable table2 = new MemoryTable(this.cursor);
            if (keys != null) {
                table2.setPrimary(keys);
            }
            if (partition != null) {
                table2.setDistribute(distribute);
                table2.setPart(partition);
            }
            return table2;
        }
        Sequence seq = this.cursor.fetch();
        if (seq instanceof Table) {
            table = (Table)seq;
        } else {
            if (seq == null) {
                return null;
            }
            table = seq.derive("o");
        }
        MemoryTable result = new MemoryTable(table);
        if (keys != null) {
            result.setPrimary(keys);
        }
        if (partition != null) {
            result.setDistribute(distribute);
            result.setPart(partition);
        }
        return result;
    }

    private static ClusterMemoryTable _$1(ClusterCursor cursor, IParam param, Context ctx) {
        String[] fields = null;
        if (param != null) {
            if (param.isLeaf()) {
                fields = new String[]{param.getLeafExpression().getIdentifierName()};
            } else {
                int size = param.getSubSize();
                fields = new String[size];
                for (int i = 0; i < size; ++i) {
                    IParam sub = param.getSub(i);
                    if (sub == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("memory" + mm.getMessage("function.invalidParam"));
                    }
                    fields[i] = sub.getLeafExpression().getIdentifierName();
                }
            }
        }
        return cursor.memory(fields, ctx);
    }

    public boolean isLeftTypeMatch(Object obj) {
        if (obj instanceof ICursor) {
            return this.option == null || this.option.indexOf(118) == -1;
        }
        return false;
    }
}

