/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.cursor;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.CursorFunction;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class Skip
extends CursorFunction {
    public Object calculate(Context ctx) {
        Expression[] exps;
        if (this.param == null) {
            long n = this.cursor.skip();
            if (n < Integer.MAX_VALUE) {
                return new Integer((int)n);
            }
            return new Long(n);
        }
        if (this.param.isLeaf()) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("skip" + mm.getMessage("function.paramTypeError"));
            }
            long n = ((Number)obj).longValue();
            if ((n = this.cursor.skip(n)) < Integer.MAX_VALUE) {
                return new Integer((int)n);
            }
            return new Long(n);
        }
        if (this.param.getType() != ';' || this.param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("skip" + mm.getMessage("function.invalidParam"));
        }
        IParam sub = this.param.getSub(1);
        if (sub == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("skip" + mm.getMessage("function.invalidParam"));
        }
        if (sub.isLeaf()) {
            exps = new Expression[]{sub.getLeafExpression()};
        } else {
            int count = sub.getSubSize();
            exps = new Expression[count];
            for (int i = 0; i < count; ++i) {
                IParam p = sub.getSub(i);
                if (p == null || !p.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("skip" + mm.getMessage("function.invalidParam"));
                }
                exps[i] = p.getLeafExpression();
            }
        }
        int n = this.cursor.skipGroup(exps, ctx);
        return new Integer(n);
    }
}

