/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.dw;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.MergeCursor2;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.cursor.UpdateMergeCursor;
import com.scudata.dw.Cursor;
import com.scudata.dw.IDWCursor;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.RvsCursor;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.PhyTableFunction;
import com.scudata.expression.operator.And;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCursor
extends PhyTableFunction {
    @Override
    public Object calculate(Context ctx) {
        ICursor cs = CreateCursor.createCursor(this.table, this.param, this.option, ctx);
        if (this.option != null && this.option.indexOf(120) != -1) {
            CreateCursor.setOptionX(cs, this.option);
        }
        if (this.option != null && this.option.indexOf(122) != -1) {
            return CreateCursor._$1(cs);
        }
        return cs;
    }

    private static void _$1(IParam param, ArrayList<Expression> expList, ArrayList<String> fieldList, ArrayList<Sequence> codeList, ArrayList<String> optList, Context ctx) {
        if (param != null) {
            if (param.isLeaf()) {
                expList.add(param.getLeafExpression());
            } else if (param.getType() == ':') {
                int subSize = param.getSubSize();
                if (subSize > 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                IParam sub0 = param.getSub(0);
                IParam sub1 = param.getSub(1);
                if (sub0 == null || sub1 == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                String fkName = sub0.getLeafExpression().getIdentifierName();
                fieldList.add(fkName);
                Object val = sub1.getLeafExpression().calculate(ctx);
                if (val instanceof Sequence) {
                    codeList.add((Sequence)val);
                } else if (val == null) {
                    codeList.add(new Sequence());
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                }
                if (subSize > 2) {
                    IParam sub2 = param.getSub(2);
                    if (sub2 != null) {
                        String opt = sub2.getLeafExpression().toString();
                        optList.add(opt);
                    } else {
                        optList.add(null);
                    }
                } else {
                    optList.add(null);
                }
            }
        }
    }

    private static ICursor _$1(ICursor src) {
        Cursor cs;
        if (src instanceof Cursor && !(cs = (Cursor)src).hasModify() && cs.getGathers() == null) {
            return new RvsCursor(cs);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
    }

    public static void setOptionX(ICursor cs, String opt) {
        if (cs instanceof IDWCursor) {
            ((IDWCursor)cs).setOption(opt);
        } else if (cs instanceof MultipathCursors) {
            ICursor[] cursors;
            MultipathCursors mcs = (MultipathCursors)cs;
            for (ICursor cursor : cursors = mcs.getCursors()) {
                CreateCursor.setOptionX(cursor, opt);
            }
        } else if (cs instanceof MergeCursor2) {
            MergeCursor2 mcs = (MergeCursor2)cs;
            CreateCursor.setOptionX(mcs.getCursor1(), opt);
            CreateCursor.setOptionX(mcs.getCursor2(), opt);
        } else if (cs instanceof MergeCursor) {
            ICursor[] cursors;
            MergeCursor mcs = (MergeCursor)cs;
            for (ICursor cursor : cursors = mcs.getCursors()) {
                CreateCursor.setOptionX(cursor, opt);
            }
        } else if (cs instanceof ConjxCursor) {
            ICursor[] cursors;
            ConjxCursor mcs = (ConjxCursor)cs;
            for (ICursor cursor : cursors = mcs.getCursors()) {
                CreateCursor.setOptionX(cursor, opt);
            }
        } else if (cs instanceof UpdateMergeCursor) {
            ((UpdateMergeCursor)cs).setOption(opt);
        }
    }

    public static ICursor createCursor(IPhyTable table, IParam param, String opt, Context ctx) {
        boolean isMultiThread;
        boolean bl = isMultiThread = opt != null && opt.indexOf(109) != -1;
        if (param == null && !isMultiThread) {
            return table.cursor(null, null, null, null, null, null, opt, ctx);
        }
        IParam fieldParam = null;
        Expression filter = null;
        String[] fkNames = null;
        Sequence[] codes = null;
        String[] opts = null;
        MultipathCursors mcs = null;
        int segSeq = 0;
        int segCount = 0;
        if (isMultiThread) {
            segCount = Env.getCursorParallelNum();
        }
        if (param != null && param.getType() == ';') {
            IParam segParam;
            int size = param.getSubSize();
            if (size > 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            fieldParam = param.getSub(0);
            IParam expParam = param.getSub(1);
            if (expParam != null) {
                if (expParam.isLeaf()) {
                    filter = expParam.getLeafExpression();
                } else {
                    int expCount;
                    ArrayList<Expression> expList = new ArrayList<Expression>();
                    ArrayList<String> fieldList = new ArrayList<String>();
                    ArrayList<Sequence> codeList = new ArrayList<Sequence>();
                    ArrayList<String> optList = new ArrayList<String>();
                    if (expParam.getType() == ':') {
                        CreateCursor._$1(expParam, expList, fieldList, codeList, optList, ctx);
                    } else {
                        int psize = expParam.getSubSize();
                        for (int p = 0; p < psize; ++p) {
                            IParam sub = expParam.getSub(p);
                            CreateCursor._$1(sub, expList, fieldList, codeList, optList, ctx);
                        }
                    }
                    int fieldCount = fieldList.size();
                    if (fieldCount > 0) {
                        fkNames = new String[fieldCount];
                        codes = new Sequence[fieldCount];
                        opts = new String[fieldCount];
                        fieldList.toArray(fkNames);
                        codeList.toArray(codes);
                        optList.toArray(opts);
                    }
                    if ((expCount = expList.size()) == 1) {
                        filter = expList.get(0);
                    } else if (expCount > 1) {
                        Expression exp = expList.get(0);
                        Node home = exp.getHome();
                        for (int i = 1; i < expCount; ++i) {
                            exp = expList.get(i);
                            And and = new And();
                            and.setLeft(home);
                            and.setRight(exp.getHome());
                            home = and;
                        }
                        filter = new Expression(home);
                    }
                }
            }
            if (size > 2 && (segParam = param.getSub(2)) != null) {
                if (segParam.isLeaf()) {
                    Object obj = segParam.getLeafExpression().calculate(ctx);
                    if (obj instanceof MultipathCursors) {
                        mcs = (MultipathCursors)obj;
                    } else if (obj instanceof ICursor) {
                        isMultiThread = false;
                    } else {
                        MessageManager mm;
                        if (!isMultiThread) {
                            mm = EngineMessage.get();
                            throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                        }
                        if (!(obj instanceof Number)) {
                            mm = EngineMessage.get();
                            throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                        }
                        segCount = ((Number)obj).intValue();
                    }
                } else {
                    if (segParam.getSubSize() != 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    IParam sub0 = segParam.getSub(0);
                    IParam sub1 = segParam.getSub(1);
                    if (sub0 == null || sub1 == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    Object obj = sub0.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    segSeq = ((Number)obj).intValue();
                    obj = sub1.getLeafExpression().calculate(ctx);
                    if (!(obj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
                    }
                    segCount = ((Number)obj).intValue();
                    if (segSeq < 1 || segSeq > segCount) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                    }
                    isMultiThread = false;
                }
            }
        } else {
            fieldParam = param;
        }
        Expression[] exps = null;
        String[] names = null;
        if (fieldParam != null) {
            ParamInfo2 pi = ParamInfo2.parse(fieldParam, "cursor", false, false);
            exps = pi.getExpressions1();
            names = pi.getExpressionStrs2();
            int len = exps.length;
            for (int i = 0; i < len; ++i) {
                if (names[i] != null || exps[i] == null) continue;
                names[i] = exps[i].getIdentifierName();
            }
        }
        if (mcs != null) {
            return table.cursor(exps, names, filter, fkNames, codes, opts, mcs, opt, ctx);
        }
        if (isMultiThread && segCount > 1) {
            return table.cursor(exps, names, filter, fkNames, codes, opts, segCount, opt, ctx);
        }
        if (segSeq < 1) {
            return table.cursor(exps, names, filter, fkNames, codes, opts, opt, ctx);
        }
        return table.cursor(exps, names, filter, fkNames, codes, opts, segSeq, segCount, opt, ctx);
    }

    @Override
    public boolean isLeftTypeMatch(Object obj) {
        if (obj instanceof IPhyTable) {
            if (this.option != null && this.option.indexOf(122) != -1) {
                return true;
            }
            return this.option == null || this.option.indexOf(118) == -1;
        }
        return false;
    }
}

