/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dw.ColComTable;
import com.scudata.dw.ComTable;
import com.scudata.dw.RowComTable;
import com.scudata.expression.Expression;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.parallel.ClusterFile;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;

public class Create
extends FileFunction {
    public Object calculate(Context ctx) {
        ComTable table;
        String[] cols;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("create" + mm.getMessage("function.missingParam"));
        }
        IParam colParam = this.param;
        Expression distributeExp = null;
        String distribute = null;
        Integer blockSize = null;
        if (this.param.getType() == ';') {
            IParam blockSizeParam;
            int size = this.param.getSubSize();
            if (size != 2 && size != 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("create" + mm.getMessage("function.invalidParam"));
            }
            colParam = this.param.getSub(0);
            if (colParam == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("create" + mm.getMessage("function.invalidParam"));
            }
            IParam expParam = this.param.getSub(1);
            if (expParam != null) {
                distributeExp = expParam.getLeafExpression();
                distribute = distributeExp.toString();
            }
            if (size == 3 && (blockSizeParam = this.param.getSub(2)) != null) {
                String b = blockSizeParam.getLeafExpression().calculate(ctx).toString();
                try {
                    blockSize = Integer.parseInt(b);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (colParam.isLeaf()) {
            cols = new String[]{colParam.getLeafExpression().getIdentifierName()};
        } else {
            int size = colParam.getSubSize();
            cols = new String[size];
            for (int i = 0; i < size; ++i) {
                IParam sub = colParam.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("create" + mm.getMessage("function.invalidParam"));
                }
                cols[i] = sub.getLeafExpression().getIdentifierName();
            }
        }
        if (this.file.isRemoteFile()) {
            String host = this.file.getIP();
            int port = this.file.getPort();
            String fileName = this.file.getFileName();
            Integer partition = this.file.getPartition();
            int p = partition == null ? -1 : partition;
            ClusterFile cf = new ClusterFile(host, port, fileName, p, ctx);
            return cf.createGroupTable(cols, distributeExp, this.option, ctx);
        }
        FileObject fo = this.file;
        String opt = this.option;
        File file = fo.getLocalFile().file();
        Integer partition = fo.getPartition();
        if ((opt == null || opt.indexOf(121) == -1) && file.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", fo.getFileName()));
        }
        if (opt != null && opt.indexOf(121) != -1 && file.exists()) {
            table = null;
            try {
                table = ComTable.open(file, ctx);
                table.delete();
            }
            catch (Exception e) {
                try {
                    if (table != null) {
                        table.close();
                    }
                    file.delete();
                }
                catch (Exception e1) {
                    throw new RQException(e1.getMessage(), e1);
                }
            }
        }
        try {
            table = opt != null && opt.indexOf(114) != -1 ? new RowComTable(file, cols, distribute, opt, blockSize, ctx) : new ColComTable(file, cols, distribute, opt, blockSize, ctx);
            table.setFileObject(fo);
            table.setPartition(partition);
            return table.getBaseTable();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public boolean isLeftTypeMatch(Object obj) {
        if (obj instanceof FileObject) {
            return !((FileObject)obj).getFile().isCloudFile();
        }
        return false;
    }
}

