/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.cellset.ICellSet;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.FileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.query.SimpleSQL;
import com.scudata.expression.Expression;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo3;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

public class CreateCursor
extends FileFunction {
    public Object calculate(Context ctx) {
        return CreateCursor.createCursor("cursor", this.file, this.cs, this.param, this.option, ctx);
    }

    private static ICursor _$1(FileObject fo, ICellSet cs, IParam param, String option, Context ctx) {
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("cursor" + mm.getMessage("function.missingParam"));
        }
        if (param.getType() == '\u0000') {
            Object obj = param.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
            }
            SimpleSQL lq = new SimpleSQL(cs, (String)obj, null, ctx);
            Object val = lq.execute();
            if (val instanceof ICursor) {
                return (ICursor)val;
            }
            if (val instanceof Sequence) {
                return new MemoryCursor((Sequence)val);
            }
            if (val == null) {
                return null;
            }
            Sequence seq = new Sequence(1);
            seq.add(val);
            return new MemoryCursor(seq);
        }
        if (param.getType() == ',') {
            IParam sub0 = param.getSub(0);
            if (sub0 == null || !sub0.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
            }
            Object obj = sub0.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("cursor" + mm.getMessage("function.paramTypeError"));
            }
            String strSql = (String)obj;
            int paramSize = param.getSubSize() - 1;
            ArrayList<Object> list = new ArrayList<Object>(paramSize);
            for (int i = 0; i < paramSize; ++i) {
                IParam sub = param.getSub(i + 1);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
                }
                Object p = sub.getLeafExpression().calculate(ctx);
                list.add(p);
            }
            SimpleSQL lq = new SimpleSQL(cs, strSql, list, ctx);
            Object val = lq.execute();
            if (val instanceof ICursor) {
                return (ICursor)val;
            }
            if (val instanceof Sequence) {
                return new MemoryCursor((Sequence)val);
            }
            if (val == null) {
                return null;
            }
            Sequence seq = new Sequence(1);
            seq.add(val);
            return new MemoryCursor(seq);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("cursor" + mm.getMessage("function.invalidParam"));
    }

    public static ICursor createCursor(String fnName, FileObject fo, ICellSet cs, IParam param, String option, Context ctx) {
        MessageManager mm;
        Object obj;
        MessageManager mm2;
        if (fo.getIsSimpleSQL()) {
            return CreateCursor._$1(fo, cs, param, option, ctx);
        }
        boolean isBinary = false;
        boolean isMultiThread = false;
        if (option != null) {
            if (option.indexOf(109) != -1) {
                isMultiThread = true;
            }
            if (option.indexOf(98) != -1 || option.indexOf(122) != -1) {
                isBinary = true;
            }
        }
        IParam fieldParam = param;
        IParam segParam = null;
        IParam sParam = null;
        if (param != null && param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm3 = EngineMessage.get();
                throw new RQException(fnName + mm3.getMessage("function.invalidParam"));
            }
            fieldParam = param.getSub(0);
            IParam p = param.getSub(1);
            if (p != null) {
                if (p.getType() == ',') {
                    if (p.getSubSize() != 2) {
                        MessageManager mm4 = EngineMessage.get();
                        throw new RQException(fnName + mm4.getMessage("function.invalidParam"));
                    }
                    segParam = p.getSub(0);
                    IParam sub1 = p.getSub(1);
                    if (sub1 != null) {
                        if (!sub1.isLeaf()) {
                            MessageManager mm5 = EngineMessage.get();
                            throw new RQException(fnName + mm5.getMessage("function.paramChanged"));
                        }
                        sParam = sub1;
                    }
                } else {
                    segParam = p;
                }
            }
        }
        String[] fields = null;
        byte[] types = null;
        String[] fmts = null;
        int[] fieldLens = null;
        int segSeq = 1;
        int segCount = 1;
        String s = null;
        if (fieldParam != null) {
            boolean isFixedLength;
            ParamInfo3 pi = ParamInfo3.parse(fieldParam, "cursor", false, false, false);
            fields = pi.getExpressionStrs1();
            String[] typeNames = pi.getExpressionStrs2();
            int fcount = fields.length;
            Expression[] exps = pi.getExpressions3();
            boolean bl = isFixedLength = option != null && option.indexOf(121) != -1;
            if (isFixedLength) {
                types = new byte[fcount];
                fmts = new String[fcount];
                fieldLens = new int[fcount];
            }
            for (int i = 0; i < fcount; ++i) {
                String type;
                if (!(isFixedLength || fields[i] != null && fields[i].length() != 0)) {
                    MessageManager mm6 = EngineMessage.get();
                    throw new RQException(fnName + mm6.getMessage("function.invalidParam"));
                }
                if (types == null) {
                    types = new byte[fcount];
                }
                if ((type = typeNames[i]) != null) {
                    if (type.equals("string")) {
                        types[i] = 11;
                    } else if (type.equals("int")) {
                        types[i] = 1;
                    } else if (type.equals("float")) {
                        types[i] = 6;
                    } else if (type.equals("long")) {
                        types[i] = 2;
                    } else if (type.equals("decimal")) {
                        types[i] = 7;
                    } else if (type.equals("date")) {
                        types[i] = 8;
                    } else if (type.equals("datetime")) {
                        types[i] = 10;
                    } else if (type.equals("time")) {
                        types[i] = 9;
                    } else if (type.equals("bool")) {
                        types[i] = 12;
                    } else {
                        try {
                            int len = Integer.parseInt(type);
                            if (len < 1) {
                                MessageManager mm7 = EngineMessage.get();
                                throw new RQException(type + mm7.getMessage("engine.unknownType"));
                            }
                            types[i] = 103;
                            if (fmts == null) {
                                fmts = new String[fcount];
                            }
                            fmts[i] = type;
                        }
                        catch (NumberFormatException e) {
                            MessageManager mm8 = EngineMessage.get();
                            throw new RQException(type + mm8.getMessage("engine.unknownType"));
                        }
                    }
                }
                if (exps[i] == null) continue;
                Object obj2 = exps[i].calculate(ctx);
                if (fmts == null) {
                    fmts = new String[fcount];
                }
                if (obj2 instanceof String) {
                    fmts[i] = (String)obj2;
                    if (!isFixedLength) continue;
                    fieldLens[i] = fmts[i].length();
                    continue;
                }
                if (obj2 instanceof Number && isFixedLength) {
                    fieldLens[i] = ((Number)obj2).intValue();
                    continue;
                }
                MessageManager mm9 = EngineMessage.get();
                throw new RQException(fnName + mm9.getMessage("function.paramTypeError"));
            }
        }
        if (segParam == null) {
            if (isMultiThread) {
                segCount = Env.getCursorParallelNum();
            }
        } else if (segParam.isLeaf()) {
            if (!isMultiThread) {
                mm2 = EngineMessage.get();
                throw new RQException(fnName + mm2.getMessage("function.invalidParam"));
            }
            obj = segParam.getLeafExpression().calculate(ctx);
            if (!(obj instanceof Number)) {
                mm = EngineMessage.get();
                throw new RQException(fnName + mm.getMessage("function.paramTypeError"));
            }
            segCount = ((Number)obj).intValue();
        } else {
            if (segParam.getSubSize() != 2) {
                mm2 = EngineMessage.get();
                throw new RQException(fnName + mm2.getMessage("function.invalidParam"));
            }
            IParam sub0 = segParam.getSub(0);
            IParam sub1 = segParam.getSub(1);
            if (sub0 != null && sub1 != null) {
                MessageManager mm10;
                Object obj3 = sub0.getLeafExpression().calculate(ctx);
                if (!(obj3 instanceof Number)) {
                    mm10 = EngineMessage.get();
                    throw new RQException(fnName + mm10.getMessage("function.paramTypeError"));
                }
                segSeq = ((Number)obj3).intValue();
                obj3 = sub1.getLeafExpression().calculate(ctx);
                if (!(obj3 instanceof Number)) {
                    mm10 = EngineMessage.get();
                    throw new RQException(fnName + mm10.getMessage("function.paramTypeError"));
                }
                segCount = ((Number)obj3).intValue();
                isMultiThread = false;
            } else if (sub0 != null || sub1 != null) {
                MessageManager mm11 = EngineMessage.get();
                throw new RQException(fnName + mm11.getMessage("function.invalidParam"));
            }
        }
        if (sParam != null) {
            obj = sParam.getLeafExpression().calculate(ctx);
            if (obj != null && !(obj instanceof String)) {
                mm = EngineMessage.get();
                throw new RQException(fnName + mm.getMessage("function.paramTypeError"));
            }
            s = (String)obj;
        }
        if (isMultiThread && segCount > 1) {
            ICursor[] cursors = new ICursor[segCount];
            if (isBinary) {
                for (int i = 0; i < segCount; ++i) {
                    cursors[i] = new BFileCursor(fo, fields, i + 1, segCount, option, ctx);
                }
            } else {
                for (int i = 0; i < segCount; ++i) {
                    FileCursor cursor = new FileCursor(fo, i + 1, segCount, fields, types, s, option, ctx);
                    cursor.setFieldLens(fieldLens);
                    cursor.setFormats(fmts);
                    cursors[i] = cursor;
                }
            }
            return new MultipathCursors(cursors, ctx);
        }
        if (isBinary) {
            return new BFileCursor(fo, fields, segSeq, segCount, option, ctx);
        }
        FileCursor cursor = new FileCursor(fo, segSeq, segCount, fields, types, s, option, ctx);
        cursor.setFieldLens(fieldLens);
        cursor.setFormats(fmts);
        return cursor;
    }
}

