/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.IFile;
import com.scudata.dm.LineImporter;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.FileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.expression.Expression;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo3;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ISelect
extends FileFunction {
    public Object calculate(Context ctx) {
        Expression exp;
        IParam endParam;
        MessageManager mm;
        IParam valParam;
        if (this.param == null) {
            MessageManager mm2 = EngineMessage.get();
            throw new RQException("iselect" + mm2.getMessage("function.missingParam"));
        }
        String[] fields = null;
        byte[] types = null;
        String[] fmts = null;
        String s = null;
        if (this.param.getType() == ';') {
            IParam sParam;
            valParam = this.param.getSub(0);
            IParam fieldParam = this.param.getSub(1);
            if (fieldParam != null) {
                ParamInfo3 pi = ParamInfo3.parse(fieldParam, "iselect", true, false, false);
                fields = pi.getExpressionStrs1();
                String[] typeNames = pi.getExpressionStrs2();
                int fcount = fields.length;
                Expression[] exps = pi.getExpressions3();
                for (int i = 0; i < fcount; ++i) {
                    String type = typeNames[i];
                    if (type == null) continue;
                    if (types == null) {
                        types = new byte[fcount];
                    }
                    if (type.equals("string")) {
                        types[i] = 11;
                    } else if (type.equals("int")) {
                        types[i] = 1;
                    } else if (type.equals("float")) {
                        types[i] = 6;
                    } else if (type.equals("long")) {
                        types[i] = 2;
                    } else if (type.equals("decimal")) {
                        types[i] = 7;
                    } else if (type.equals("date")) {
                        types[i] = 8;
                    } else if (type.equals("datetime")) {
                        types[i] = 10;
                    } else if (type.equals("time")) {
                        types[i] = 9;
                    } else if (type.equals("bool")) {
                        types[i] = 12;
                    } else {
                        try {
                            int len = Integer.parseInt(type);
                            if (len < 1) {
                                MessageManager mm3 = EngineMessage.get();
                                throw new RQException(type + mm3.getMessage("engine.unknownType"));
                            }
                            types[i] = 103;
                            if (fmts == null) {
                                fmts = new String[fcount];
                            }
                            fmts[i] = type;
                        }
                        catch (NumberFormatException e) {
                            MessageManager mm4 = EngineMessage.get();
                            throw new RQException(type + mm4.getMessage("engine.unknownType"));
                        }
                    }
                    if (exps[i] == null) continue;
                    Object obj = exps[i].calculate(ctx);
                    if (!(obj instanceof String)) {
                        MessageManager mm5 = EngineMessage.get();
                        throw new RQException("iselect" + mm5.getMessage("function.paramTypeError"));
                    }
                    if (fmts == null) {
                        fmts = new String[fcount];
                    }
                    fmts[i] = (String)obj;
                }
            }
            if (this.param.getSubSize() > 2 && (sParam = this.param.getSub(2)) != null) {
                Object obj = sParam.getLeafExpression().calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm6 = EngineMessage.get();
                    throw new RQException("iselect" + mm6.getMessage("function.paramTypeError"));
                }
                s = (String)obj;
            }
        } else {
            valParam = this.param;
        }
        if (valParam.getSubSize() != 2) {
            MessageManager mm7 = EngineMessage.get();
            throw new RQException("iselect" + mm7.getMessage("function.invalidParam"));
        }
        IParam sub0 = valParam.getSub(0);
        IParam sub1 = valParam.getSub(1);
        if (sub0 == null || sub1 == null) {
            mm = EngineMessage.get();
            throw new RQException("iselect" + mm.getMessage("function.invalidParam"));
        }
        if (sub0.isLeaf()) {
            Sequence values;
            Object key = sub0.getLeafExpression().calculate(ctx);
            if (key == null) {
                MessageManager mm8 = EngineMessage.get();
                throw new RQException("iselect" + mm8.getMessage("function.invalidParam"));
            }
            if (key instanceof Sequence) {
                values = (Sequence)key;
            } else {
                values = new Sequence(1);
                values.add(key);
            }
            Expression exp2 = sub1.getLeafExpression();
            if (null == exp2) {
                MessageManager mm9 = EngineMessage.get();
                throw new RQException("iselect" + mm9.getMessage("function.paramTypeError"));
            }
            return ISelect._$1(this.file, exp2, values, fields, types, fmts, s, this.option, ctx);
        }
        if (sub0.getSubSize() != 2) {
            mm = EngineMessage.get();
            throw new RQException("iselect" + mm.getMessage("function.invalidParam"));
        }
        Object startVal = null;
        Object endVal = null;
        IParam startParam = sub0.getSub(0);
        if (startParam != null) {
            startVal = startParam.getLeafExpression().calculate(ctx);
        }
        if ((endParam = sub0.getSub(1)) != null) {
            endVal = endParam.getLeafExpression().calculate(ctx);
        }
        if (null == (exp = sub1.getLeafExpression())) {
            MessageManager mm10 = EngineMessage.get();
            throw new RQException("iselect" + mm10.getMessage("function.paramTypeError"));
        }
        return ISelect._$1(this.file, exp, startVal, endVal, fields, types, fmts, s, this.option, ctx);
    }

    private static ICursor _$1(FileObject fo, Expression exp, Sequence values, String[] selFields, byte[] types, String[] fmts, String s, String opt, Context ctx) {
        byte[] separator;
        boolean isCsv = false;
        boolean isMultiId = false;
        if (opt != null) {
            if (opt.indexOf(98) != -1) {
                BFileReader reader = new BFileReader(fo);
                return reader.iselect(exp, values, selFields, opt, ctx);
            }
            if (opt.indexOf(99) != -1) {
                isCsv = true;
            }
            if (opt.indexOf(114) != -1) {
                isMultiId = true;
            }
        }
        String charset = fo.getCharset();
        if (s != null && s.length() > 0) {
            try {
                separator = s.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RQException(e.getMessage(), e);
            }
        } else {
            separator = isCsv ? new byte[]{44} : FileObject.COL_SEPARATOR;
        }
        Table table = ISelect._$1(fo, exp, values, selFields, types, fmts, separator, opt, isMultiId, ctx);
        if (selFields != null) {
            table = table.fieldsValues(selFields, opt);
        }
        if (table != null && table.length() > 0) {
            return new MemoryCursor(table);
        }
        return null;
    }

    private static ICursor _$1(FileObject fo, Expression exp, Object startVal, Object endVal, String[] selFields, byte[] types, String[] fmts, String s, String opt, Context ctx) {
        long end;
        byte[] separator;
        boolean isCsv = false;
        if (opt != null) {
            if (opt.indexOf(98) != -1) {
                BFileReader reader = new BFileReader(fo);
                return reader.iselect(exp, startVal, endVal, selFields, opt, ctx);
            }
            if (opt.indexOf(99) != -1) {
                isCsv = true;
            }
        }
        String charset = fo.getCharset();
        if (s != null && s.length() > 0) {
            try {
                separator = s.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RQException(e.getMessage(), e);
            }
        } else {
            separator = isCsv ? new byte[]{44} : FileObject.COL_SEPARATOR;
        }
        LineImporter importer = null;
        Object[] line = null;
        try {
            importer = new LineImporter(fo.getInputStream(), charset, separator, opt, 1024);
            line = importer.readLine();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (IOException ie) {}
        }
        if (line == null || line.length == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(exp.getIdentifierName() + mm.getMessage("ds.fieldNotExist"));
        }
        long start = 0L;
        if (startVal != null && (start = ISelect._$1(fo, exp, startVal, selFields, types, fmts, separator, opt, true, ctx)) < 0L) {
            start = -start;
        }
        if (endVal != null) {
            end = ISelect._$1(fo, exp, endVal, selFields, types, fmts, separator, opt, false, ctx);
            if (end < 0L) {
                end = -end;
            }
        } else {
            end = fo.size();
        }
        FileCursor cursor = new FileCursor(fo, 0, 0, selFields, types, s, opt, ctx);
        cursor.setFormats(fmts);
        cursor.setStart(start);
        cursor.setEnd(end);
        return cursor;
    }

    private static Table _$1(FileObject fo, Expression exp, Sequence values, String[] selFields, byte[] types, String[] fmts, byte[] separator, String opt, boolean isMultiId, Context ctx) {
        DataStruct ds;
        String[] items;
        boolean isTitle = false;
        if (opt != null && opt.indexOf(116) != -1) {
            isTitle = true;
        }
        IFile file = fo.getFile();
        String charset = fo.getCharset();
        LineImporter importer = null;
        Object[] line = null;
        long start = 0L;
        Record rec = null;
        try {
            importer = new LineImporter(file.getInputStream(), charset, separator, opt, 1024);
            line = importer.readLine();
        }
        catch (IOException e) {
            try {
                if (importer != null) {
                    importer.close();
                    importer = null;
                }
            }
            catch (IOException ie) {
                // empty catch block
            }
            throw new RQException(e.getMessage(), e);
        }
        if (line == null || line.length == 0) {
            try {
                if (importer != null) {
                    importer.close();
                    importer = null;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(exp.getIdentifierName() + mm.getMessage("ds.fieldNotExist"));
        }
        int fcount = line.length;
        byte[] colTypes = new byte[fcount];
        String[] colFormats = null;
        if (fmts != null) {
            colFormats = new String[fcount];
        }
        if (isTitle) {
            int f;
            start = importer.getCurrentPosition() - 2L;
            items = new String[fcount];
            for (f = 0; f < fcount; ++f) {
                items[f] = Variant.toString(line[f]);
            }
            ds = new DataStruct(items);
            if (types != null) {
                for (f = 0; f < selFields.length; ++f) {
                    int findex = ds.getFieldIndex(selFields[f]);
                    if (findex == -1) continue;
                    colTypes[findex] = types[f];
                    if (fmts == null) continue;
                    colFormats[findex] = fmts[f];
                }
            }
        } else {
            items = new String[fcount];
            ds = new DataStruct(items);
        }
        importer.setColTypes(colTypes, colFormats);
        rec = new Record(ds);
        int valCount = values.length();
        Table table = new Table(ds, valCount);
        long size = file.size();
        try {
            for (int i = 1; i <= valCount; ++i) {
                long low = start;
                long high = size;
                Object key = values.get(i);
                boolean isExist = false;
                while (low <= high) {
                    long mid = low + high >> 1;
                    long pos = importer.getCurrentPosition();
                    if (pos > mid) {
                        importer.close();
                        LineImporter tmp = new LineImporter(file.getInputStream(), charset, separator, opt, 1024);
                        tmp.copyProperty(importer);
                        importer = tmp;
                    }
                    if (isMultiId && low == high) break;
                    importer.seek(mid);
                    Object[] objs = importer.readLine();
                    if (objs == null) {
                        high = mid - 1L;
                        continue;
                    }
                    rec.setStart(0, objs);
                    int cmp = 0;
                    try {
                        cmp = Variant.compare(rec.calc(exp, ctx), key);
                    }
                    catch (RQException e) {
                        start = low = mid + 1L;
                        continue;
                    }
                    if (isMultiId) {
                        if (cmp < 0) {
                            start = low = mid + 1L;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid;
                            continue;
                        }
                        high = mid;
                        isExist = true;
                        continue;
                    }
                    if (cmp < 0) {
                        start = low = mid + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1L;
                        continue;
                    }
                    if (objs.length <= fcount) {
                        table.newLast(objs);
                    } else {
                        BaseRecord r = table.newLast();
                        for (int f = 0; f < fcount; ++f) {
                            r.setNormalFieldValue(f, objs[f]);
                        }
                    }
                    pos = importer.getCurrentPosition();
                    if (pos < size) {
                        start = pos - 2L;
                        break;
                    }
                    start = size;
                    break;
                }
                if (isMultiId && isExist) {
                    start = ISelect._$1(importer, table, low, exp, rec, key, fcount, size, ctx);
                }
                if (start < size) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (importer != null) {
                    importer.close();
                }
            }
            catch (Exception e) {}
        }
        return table;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long _$1(LineImporter importer, Table table, long pos, Expression exp, BaseRecord rec, Object key, int fcount, long size, Context ctx) throws IOException {
        importer.seek(pos);
        block2: while (true) {
            lastpos = importer.getCurrentPosition();
            objs = importer.readLine();
            if (objs == null) {
                return importer.getCurrentPosition();
            }
            rec.setStart(0, objs);
            if (Variant.compare(rec.calc(exp, ctx), key) != 0) return lastpos - 2L;
            lastpos = importer.getCurrentPosition();
            if (objs.length <= fcount) {
                table.newLast(objs);
                continue;
            }
            r = table.newLast();
            f = 0;
            while (true) {
                if (f < fcount) ** break;
                continue block2;
                r.setNormalFieldValue(f, objs[f]);
                ++f;
            }
            break;
        }
        catch (RQException e) {
            return importer.getCurrentPosition();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long _$1(FileObject fo, Expression exp, Object value, String[] selFields, byte[] types, String[] fmts, byte[] separator, String opt, boolean isStart, Context ctx) {
        long result;
        int cmp;
        Object[] objs;
        long pos;
        long mid;
        Record rec;
        long high;
        long low;
        LineImporter importer;
        String charset;
        IFile file;
        block51: {
            block50: {
                boolean isTitle = false;
                boolean isKey = true;
                if (opt != null) {
                    if (opt.indexOf(116) != -1) {
                        isTitle = true;
                    }
                    if (opt.indexOf(114) != -1) {
                        isKey = false;
                    }
                }
                file = fo.getFile();
                charset = fo.getCharset();
                importer = new LineImporter(file.getInputStream(), charset, separator, opt, 1024);
                low = 0L;
                high = file.size();
                try {
                    block49: {
                        Object[] line = importer.readLine();
                        if (line == null) {
                            long l = -1L;
                            return l;
                        }
                        int fcount = line.length;
                        byte[] colTypes = new byte[fcount];
                        String[] colFormats = null;
                        if (fmts != null) {
                            colFormats = new String[fcount];
                        }
                        String[] fields = new String[line.length];
                        if (isTitle) {
                            low = importer.getCurrentPosition() - 2L;
                            for (int i = 0; i < line.length; ++i) {
                                fields[i] = Variant.toString(line[i]);
                            }
                        }
                        DataStruct ds = new DataStruct(fields);
                        if (types != null) {
                            for (int f = 0; f < selFields.length; ++f) {
                                int findex = ds.getFieldIndex(selFields[f]);
                                if (findex == -1) continue;
                                colTypes[findex] = types[f];
                                if (fmts == null) continue;
                                colFormats[findex] = fmts[f];
                            }
                        }
                        importer.setColTypes(colTypes, colFormats);
                        rec = new Record(ds);
                        while (low <= high) {
                            mid = low + high >> 1;
                            pos = importer.getCurrentPosition();
                            if (pos > mid) {
                                importer.close();
                                LineImporter tmp = new LineImporter(file.getInputStream(), charset, separator, opt, 1024);
                                tmp.copyProperty(importer);
                                importer = tmp;
                            }
                            importer.seek(mid);
                            objs = importer.readLine();
                            if (objs == null) {
                                high = mid - 1L;
                                continue;
                            }
                            rec.setStart(0, objs);
                            cmp = Variant.compare(rec.calc(exp, ctx), value);
                            if (cmp < 0) {
                                low = mid + 1L;
                                continue;
                            }
                            if (cmp > 0) {
                                high = mid - 1L;
                                continue;
                            }
                            break block49;
                        }
                        return -low;
                    }
                    if (isKey) {
                        if (isStart) {
                            long l = mid;
                            return l;
                        }
                        long l = importer.getCurrentPosition() - 2L;
                        return l;
                    }
                    if (isStart) {
                        high = mid;
                        break block50;
                    }
                    result = importer.getCurrentPosition() - 2L;
                    low = mid;
                    break block51;
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
                finally {
                    try {
                        if (importer != null) {
                            importer.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            while (true) {
                if (low >= high) {
                    return low;
                }
                mid = low + high >> 1;
                pos = importer.getCurrentPosition();
                if (pos > mid) {
                    importer.close();
                    LineImporter tmp = new LineImporter(file.getInputStream(), charset, separator, opt, 1024);
                    tmp.copyProperty(importer);
                    importer = tmp;
                }
                importer.seek(mid);
                objs = importer.readLine();
                rec.setStart(0, objs);
                cmp = Variant.compare(rec.calc(exp, ctx), value);
                if (cmp < 0) {
                    low = mid + 1L;
                    continue;
                }
                high = mid;
            }
        }
        while (low < high) {
            mid = low + high >> 1;
            pos = importer.getCurrentPosition();
            if (pos > mid) {
                importer.close();
                LineImporter tmp = new LineImporter(file.getInputStream(), charset, separator, opt, 1024);
                tmp.copyProperty(importer);
                importer = tmp;
            }
            importer.seek(mid);
            objs = importer.readLine();
            if (objs == null) break;
            rec.setStart(0, objs);
            cmp = Variant.compare(rec.calc(exp, ctx), value);
            if (cmp > 0) {
                high = mid;
                continue;
            }
            low = mid + 1L;
            result = importer.getCurrentPosition() - 2L;
        }
        return result;
    }
}

