/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileGroup;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dw.ComTable;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;

public class Reset
extends FileFunction {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object calculate(Context ctx) {
        Object obj = null;
        ICursor cs = null;
        IParam param = this.param;
        if (param != null && param.getType() == ';' && param.getSubSize() == 2) {
            IParam csParam = param.getSub(1);
            if (csParam != null && (obj = csParam.getLeafExpression().calculate(ctx)) != null) {
                if (obj instanceof ICursor) {
                    cs = (ICursor)obj;
                } else {
                    if (!(obj instanceof Sequence)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("reset" + mm.getMessage("function.paramTypeError"));
                    }
                    cs = new MemoryCursor((Sequence)obj);
                }
            }
            param = param.getSub(0);
        }
        File f = null;
        FileGroup fg = null;
        String distribute = null;
        Integer blockSize = null;
        if (param == null) {
            ComTable gt;
            FileObject fo = this.file;
            try {
                gt = ComTable.open(fo, ctx);
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
            boolean result = gt.reset(null, this.option, ctx, null, null, cs);
            gt.close();
            return result;
        }
        if (param.isLeaf()) {
            obj = param.getLeafExpression().calculate(ctx);
            f = null;
            if (!(obj instanceof FileObject)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("reset" + mm.getMessage("function.paramTypeError"));
            }
            f = ((FileObject)obj).getLocalFile().file();
            FileObject fo = this.file;
            if (f != null) {
                String opt = this.option;
                if ((opt == null || opt.indexOf(121) == -1) && f.exists()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("file.fileAlreadyExist", f.getName()));
                }
                if (opt != null && opt.indexOf(121) != -1 && f.exists()) {
                    try {
                        ComTable table = ComTable.open(f, ctx);
                        table.delete();
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                }
            }
            try {
                ComTable gt = ComTable.open(fo, ctx);
                boolean result = gt.reset(f, this.option, ctx, null, null, cs);
                gt.close();
                return result;
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        if (param.getType() == ':') {
            IParam blockSizeParam;
            IParam sub0 = param.getSub(0);
            if (sub0 != null) {
                obj = sub0.getLeafExpression().calculate(ctx);
                if (obj instanceof FileObject) {
                    f = ((FileObject)obj).getLocalFile().file();
                } else {
                    if (!(obj instanceof FileGroup)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("reset" + mm.getMessage("function.paramTypeError"));
                    }
                    fg = (FileGroup)obj;
                }
            }
            if ((blockSizeParam = param.getSub(1)) != null) {
                String b = blockSizeParam.getLeafExpression().calculate(ctx).toString();
                try {
                    blockSize = Integer.parseInt(b);
                }
                catch (NumberFormatException e) {}
            }
        } else if (param.getType() == ',') {
            IParam expParam = param.getSub(1);
            if (expParam != null) {
                distribute = expParam.getLeafExpression().toString();
            }
            if ((param = param.getSub(0)).isLeaf()) {
                obj = param.getLeafExpression().calculate(ctx);
                if (obj instanceof FileObject) {
                    f = ((FileObject)obj).getLocalFile().file();
                } else {
                    if (!(obj instanceof FileGroup)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("reset" + mm.getMessage("function.paramTypeError"));
                    }
                    fg = (FileGroup)obj;
                }
            } else if (param.getType() == ':') {
                IParam blockSizeParam;
                IParam sub0 = param.getSub(0);
                if (sub0 != null) {
                    obj = sub0.getLeafExpression().calculate(ctx);
                    if (obj instanceof FileObject) {
                        f = ((FileObject)obj).getLocalFile().file();
                    } else {
                        if (!(obj instanceof FileGroup)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException("reset" + mm.getMessage("function.paramTypeError"));
                        }
                        fg = (FileGroup)obj;
                    }
                }
                if ((blockSizeParam = param.getSub(1)) != null) {
                    String b = blockSizeParam.getLeafExpression().calculate(ctx).toString();
                    try {
                        blockSize = Integer.parseInt(b);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
        }
        FileObject fo = this.file;
        try {
            ComTable gt = ComTable.open(fo, ctx);
            if (f != null) {
                String opt = this.option;
                if ((opt == null || opt.indexOf(121) == -1) && f.exists()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("file.fileAlreadyExist", f.getName()));
                }
                if (opt != null && opt.indexOf(121) != -1 && f.exists()) {
                    try {
                        ComTable table = ComTable.open(f, ctx);
                        table.delete();
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                }
                boolean result = gt.reset(f, this.option, ctx, distribute, blockSize, cs);
                gt.close();
                return result;
            }
            if (distribute == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("reset" + mm.getMessage("function.invalidParam"));
            }
            boolean result = gt.resetFileGroup(fg, this.option, ctx, distribute, blockSize, cs);
            gt.close();
            return result;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }
}

