/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.MD5;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dw.BufferReader;
import com.scudata.dw.ComTable;
import com.scudata.dw.PhyTable;
import com.scudata.expression.FileFunction;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Rollback
extends FileFunction {
    public Object calculate(Context ctx) {
        String psw = null;
        if (this.param != null) {
            Object obj = this.param.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("rollback" + mm.getMessage("function.paramTypeError"));
            }
            psw = (String)obj;
        }
        File f = this.file.getLocalFile().file();
        return Rollback.groupTableRollBack(f, psw, ctx);
    }

    public static boolean groupTableRollBack(File file, String psw, Context ctx) {
        RandomAccessFile raf;
        File sf = ComTable.getSupplementFile(file);
        if (sf.exists()) {
            Rollback.groupTableRollBack(sf, psw, ctx);
        }
        String dir = file.getAbsolutePath() + "_TransactionLog";
        FileObject logFile = new FileObject(dir);
        boolean result = false;
        if (logFile.isExists()) {
            result = true;
            raf = null;
            try {
                raf = new RandomAccessFile(logFile.getLocalFile().file(), "rw");
                int len = (int)raf.length();
                if (len <= 48) {
                    raf.close();
                    logFile.delete();
                    return Boolean.TRUE;
                }
                byte[] bytes = new byte[len - 16];
                byte[] mac1 = new byte[16];
                raf.seek(0L);
                raf.readFully(bytes);
                raf.readFully(mac1);
                raf.close();
                byte[] mac2 = MD5.get(bytes);
                for (int i = 0; i < 16; ++i) {
                    if (mac1[i] == mac2[i]) continue;
                    logFile.delete();
                    return Boolean.TRUE;
                }
                if (bytes[0] != 114 || bytes[1] != 113 || bytes[2] != 100 || bytes[3] != 119 || bytes[4] != 103 || bytes[5] != 116) {
                    logFile.delete();
                    return Boolean.TRUE;
                }
                BufferReader reader = new BufferReader(null, bytes);
                reader.read();
                reader.read();
                reader.read();
                reader.read();
                reader.read();
                reader.read();
                reader.read();
                reader.readInt32();
                reader.readLong40();
                reader.readLong40();
                reader.readInt32();
                reader.readInt32();
                byte[] reserve = new byte[32];
                reader.read(reserve);
                long freePos = reader.readLong40();
                long fileSize = reader.readLong40();
                if (reserve[0] > 0) {
                    String writePswHash = reader.readString();
                    reader.readString();
                    if (writePswHash != null) {
                        if (psw == null) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("cellset.pswError"));
                        }
                        MD5 md5 = new MD5();
                        boolean canWrite = md5.getMD5ofStr(psw).equals(writePswHash);
                        if (!canWrite) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("cellset.pswError"));
                        }
                    }
                }
                raf = new RandomAccessFile(file, "rw");
                raf.seek(0L);
                raf.write(bytes);
                raf.getChannel().force(false);
                raf.setLength(freePos);
                raf.setLength(fileSize);
                raf.close();
                logFile.delete();
            }
            catch (IOException e) {
                try {
                    raf.close();
                }
                catch (IOException e1) {
                    throw new RQException(e1.getMessage(), e1);
                }
                throw new RQException(e.getMessage(), e);
            }
        }
        if ((logFile = new FileObject(dir = file.getAbsolutePath() + "_I_TransactionLog")).isExists()) {
            raf = null;
            ComTable gtable = null;
            try {
                PhyTable btable;
                raf = new RandomAccessFile(logFile.getLocalFile().file(), "rw");
                String tableName = raf.readUTF();
                gtable = ComTable.createGroupTable(file);
                gtable.checkPassword(psw);
                PhyTable table = btable = gtable.getBaseTable();
                if (!tableName.equals(btable.getTableName())) {
                    table = btable.getAnnexTable(tableName);
                }
                if (table != null) {
                    table.resetIndex(ctx);
                }
                raf.close();
                logFile.delete();
            }
            catch (IOException e) {
                try {
                    raf.close();
                    gtable.close();
                }
                catch (IOException e1) {
                    throw new RQException(e1.getMessage(), e1);
                }
                throw new RQException(e.getMessage(), e);
            }
        }
        return result;
    }
}

