/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.file;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.SubCursor;
import com.scudata.excel.ExcelTool;
import com.scudata.excel.ExcelUtils;
import com.scudata.expression.Expression;
import com.scudata.expression.FileFunction;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.resources.AppMessage;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;

public class XlsExport
extends FileFunction {
    public Object calculate(Context ctx) {
        boolean isW;
        Object src;
        IParam param0;
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xlsexport" + mm.getMessage("function.missingParam"));
        }
        IParam param1 = null;
        String pwd = null;
        if (this.param.getType() == ';') {
            if (this.param.getSubSize() != 2 && this.param.getSubSize() != 3) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
            }
            param0 = this.param.getSub(0);
            param1 = this.param.getSub(1);
            if (this.param.getSubSize() == 3) {
                IParam pwdParam = this.param.getSub(2);
                Object tmp = pwdParam.getLeafExpression().calculate(ctx);
                if (tmp != null) {
                    pwd = tmp.toString();
                }
                if ("".equals(pwd)) {
                    pwd = null;
                }
            }
            if (param0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
            }
        } else {
            param0 = this.param;
        }
        Expression[] exps = null;
        String[] names = null;
        Object s = null;
        if (param0.isLeaf()) {
            src = param0.getLeafExpression().calculate(ctx);
        } else {
            IParam sub = param0.getSub(0);
            if (sub == null || !sub.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
            }
            src = sub.getLeafExpression().calculate(ctx);
            int size = param0.getSubSize();
            exps = new Expression[size - 1];
            names = new String[size - 1];
            for (int i = 1; i < size; ++i) {
                MessageManager mm;
                sub = param0.getSub(i);
                if (sub == null) {
                    mm = EngineMessage.get();
                    throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
                }
                if (sub.isLeaf()) {
                    exps[i - 1] = sub.getLeafExpression();
                    continue;
                }
                if (sub.getSubSize() != 2) {
                    mm = EngineMessage.get();
                    throw new RQException("xlsexport" + mm.getMessage("function.invalidParam"));
                }
                IParam p1 = sub.getSub(0);
                if (p1 == null) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException("xlsexport" + mm2.getMessage("function.invalidParam"));
                }
                exps[i - 1] = p1.getLeafExpression();
                IParam p2 = sub.getSub(1);
                if (p2 == null) continue;
                names[i - 1] = p2.getLeafExpression().getIdentifierName();
            }
        }
        if (param1 != null) {
            s = param1.getLeafExpression().calculate(ctx);
        }
        String opt = this.option;
        boolean isXlsx = false;
        boolean isTitle = false;
        boolean isSsxxf = false;
        boolean isAppend = false;
        boolean isM = false;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                isTitle = true;
            }
            if (opt.indexOf(99) != -1) {
                isSsxxf = true;
            }
            if (opt.indexOf(97) != -1) {
                isAppend = true;
            }
            if (opt.indexOf(109) != -1) {
                isM = true;
            }
        }
        boolean isP = opt != null && opt.indexOf("p") > -1;
        boolean isK = opt != null && opt.indexOf("k") > -1;
        boolean bl = isW = opt != null && opt.indexOf("w") > -1;
        if (isW) {
            if (isTitle || isSsxxf) {
                throw new RQException(AppMessage.get().getMessage("xlsexport.nowtc"));
            }
            if (exps != null) {
                throw new RQException(AppMessage.get().getMessage("xlsexport.nowfields"));
            }
        }
        if (!isW && isP) {
            throw new RQException(AppMessage.get().getMessage("xlsimport.pnnotw", "p"));
        }
        if (this.file != null) {
            isXlsx = ExcelUtils.isXlsxFile(this.file);
        }
        ExcelUtils.checkSheetName(s);
        ExcelTool et = new ExcelTool(this.file, isTitle, isXlsx, isSsxxf, isAppend, s, pwd, isW, isK);
        int maxCount = et.getMaxLineCount();
        if (isTitle) {
            --maxCount;
        }
        Sequence seq = null;
        ICursor cursor = null;
        boolean isStr = false;
        if (isW && src != null && src instanceof String) {
            src = XlsExport.parseSequence((String)src);
            isStr = true;
        }
        if (src == null) {
            return null;
        }
        if (src instanceof Sequence) {
            seq = (Sequence)src;
            if (!isStr && isP) {
                seq = ExcelUtils.transpose(seq);
                src = seq;
            }
        }
        if (isM) {
            try {
                this._$1(src, maxCount, et, s, exps, names, opt, ctx);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
            finally {
                try {
                    et.close();
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
            }
            return null;
        }
        if (src instanceof Sequence) {
            if (seq.length() > maxCount) {
                cursor = new MemoryCursor(seq, 1, maxCount + 1);
                seq = null;
            }
        } else if (src instanceof ICursor) {
            cursor = (ICursor)src;
            cursor = new SubCursor(cursor, maxCount);
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xlsexport" + mm.getMessage("function.paramTypeError"));
        }
        try {
            if (seq != null) {
                et.fileXlsExport(seq, exps, names, opt, ctx);
            } else {
                et.fileXlsExport(cursor, exps, names, opt, ctx);
            }
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                et.close();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Node optimize(Context ctx) {
        if (this.param != null) {
            this.param.optimize(ctx);
        }
        return this;
    }

    private void _$1(Object src, int maxCount, ExcelTool et, Object s, Expression[] exps, String[] names, String opt, Context ctx) throws Exception {
        Sequence seq = null;
        ICursor cursor = null;
        if (src instanceof Sequence) {
            seq = (Sequence)src;
            int totalCount = seq.length();
            if (totalCount > maxCount) {
                String sheetName = s == null ? "Sheet" : (String)s;
                int start = 1;
                int index = 1;
                while (totalCount > 0) {
                    cursor = new MemoryCursor(seq, start, start + maxCount);
                    if (index > 1) {
                        et.setSheet(sheetName + index);
                    }
                    et.fileXlsExport(cursor, exps, names, opt, ctx);
                    start += maxCount;
                    ++index;
                    totalCount -= maxCount;
                }
            } else {
                et.fileXlsExport(seq, exps, names, opt, ctx);
            }
        } else if (src instanceof ICursor) {
            cursor = (ICursor)src;
            String sheetName = s == null ? "Sheet" : (String)s;
            int index = 1;
            while (cursor.peek(1) != null) {
                SubCursor subCursor = new SubCursor(cursor, maxCount);
                if (index > 1) {
                    et.setSheet(sheetName + index);
                }
                et.fileXlsExport(subCursor, exps, names, opt, ctx);
                ++index;
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("xlsexport" + mm.getMessage("function.paramTypeError"));
        }
    }

    public static Sequence parseSequence(String str) {
        try {
            str = str.replaceAll("\r\n", "\n");
            str = str.replaceAll("\r", "\n");
        }
        catch (Exception x) {
            // empty catch block
        }
        Sequence seq = new Sequence();
        ArgumentTokenizer rows = new ArgumentTokenizer(str, '\n');
        while (rows.hasMoreTokens()) {
            String rowStr = rows.nextToken();
            Sequence subSeq = new Sequence();
            ArgumentTokenizer items = new ArgumentTokenizer(rowStr, '\t');
            while (items.hasMoreTokens()) {
                String item = items.nextToken();
                Object val = item;
                if (StringUtils.isValidString(item)) {
                    val = item.startsWith("'") && !item.endsWith("'") ? item.substring(1) : Variant.parseCellValue(item);
                }
                subSeq.add(val);
            }
            seq.add(subSeq);
        }
        return seq;
    }
}

