/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Export
extends SequenceFunction {
    public Object calculate(Context ctx) {
        Expression[] exps = null;
        String[] names = null;
        String s = null;
        IParam param = this.param;
        if (param != null && param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.invalidParam"));
            }
            IParam param1 = param.getSub(1);
            if (param1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.invalidParam"));
            }
            Object obj = param1.getLeafExpression().calculate(ctx);
            if (!(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("export" + mm.getMessage("function.paramTypeError"));
            }
            s = (String)obj;
            param = param.getSub(0);
        }
        if (param != null) {
            ParamInfo2 pi2 = ParamInfo2.parse(param, "export", true, false);
            exps = pi2.getExpressions1();
            names = pi2.getExpressionStrs2();
        }
        return Export.export(this.srcSequence, exps, names, s, this.option, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String export(Sequence sequence, Expression[] exps, String[] names, String s, String option, Context ctx) {
        boolean isTitle = false;
        boolean isCsv = false;
        boolean isQuote = false;
        String LINE_SEPARATOR = new String(FileObject.LINE_SEPARATOR);
        char escapeChar = '\\';
        if (option != null) {
            if (option.indexOf(116) != -1) {
                isTitle = true;
            }
            if (option.indexOf(99) != -1) {
                isCsv = true;
            }
            if (option.indexOf(119) != -1) {
                LINE_SEPARATOR = new String(FileObject.DM_LINE_SEPARATOR);
            }
            if (option.indexOf(113) != -1) {
                isQuote = true;
            }
            if (option.indexOf(111) != -1) {
                escapeChar = '\"';
            }
        }
        StringBuffer sb = new StringBuffer(0x100000);
        if (s == null || s.length() == 0) {
            s = isCsv ? "," : "\t";
        }
        if (exps == null) {
            int fcount = 1;
            DataStruct ds = sequence.dataStruct();
            if (ds == null) {
                fcount = FileObject.getMaxMemberCount(sequence);
                if (isTitle && fcount < 1) {
                    if (isQuote) {
                        Export._$1(sb, new String[]{"_1"}, s, LINE_SEPARATOR, escapeChar);
                    } else {
                        Export._$1(sb, new String[]{"_1"}, s, LINE_SEPARATOR);
                    }
                }
            } else {
                fcount = ds.getFieldCount();
                if (isTitle) {
                    if (isQuote) {
                        Export._$1(sb, ds.getFieldNames(), s, LINE_SEPARATOR, escapeChar);
                    } else {
                        Export._$1(sb, ds.getFieldNames(), s, LINE_SEPARATOR);
                    }
                }
            }
            if (ds == null) {
                if (fcount < 1) {
                    Object[] lineObjs = new Object[1];
                    int len = sequence.length();
                    for (int i = 1; i <= len; ++i) {
                        lineObjs[0] = sequence.getMem(i);
                        if (isQuote) {
                            Export._$1(sb, lineObjs, s, LINE_SEPARATOR, escapeChar);
                            continue;
                        }
                        Export._$1(sb, lineObjs, s, LINE_SEPARATOR);
                    }
                } else {
                    Object[] lineObjs = new Object[fcount];
                    int len = sequence.length();
                    for (int i = 1; i <= len; ++i) {
                        int f;
                        Sequence seq = (Sequence)sequence.getMem(i);
                        if (seq == null) {
                            for (f = 0; f < fcount; ++f) {
                                lineObjs[f] = null;
                            }
                        } else {
                            seq.toArray(lineObjs);
                            for (f = seq.length(); f < fcount; ++f) {
                                lineObjs[f] = null;
                            }
                        }
                        if (isQuote) {
                            Export._$1(sb, lineObjs, s, LINE_SEPARATOR, escapeChar);
                            continue;
                        }
                        Export._$1(sb, lineObjs, s, LINE_SEPARATOR);
                    }
                }
            } else {
                int len = sequence.length();
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r = (BaseRecord)sequence.getMem(i);
                    Object[] vals = r.getFieldValues();
                    if (isQuote) {
                        Export._$1(sb, vals, s, LINE_SEPARATOR, escapeChar);
                        continue;
                    }
                    Export._$1(sb, vals, s, LINE_SEPARATOR);
                }
            }
        } else {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(sequence);
            stack.push(current);
            try {
                int fcount = exps.length;
                if (isTitle) {
                    if (names == null) {
                        names = new String[fcount];
                    }
                    sequence.getNewFieldNames(exps, names, "export");
                    if (isQuote) {
                        Export._$1(sb, names, s, LINE_SEPARATOR, escapeChar);
                    } else {
                        Export._$1(sb, names, s, LINE_SEPARATOR);
                    }
                }
                Object[] lineObjs = new Object[fcount];
                int len = sequence.length();
                for (int i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        lineObjs[f] = exps[f].calculate(ctx);
                    }
                    if (isQuote) {
                        Export._$1(sb, lineObjs, s, LINE_SEPARATOR, escapeChar);
                        continue;
                    }
                    Export._$1(sb, lineObjs, s, LINE_SEPARATOR);
                }
            }
            finally {
                stack.pop();
            }
        }
        return sb.toString();
    }

    private static void _$1(StringBuffer sb, Object[] items, String s, String ls) {
        String str = Variant.toExportString(items[0]);
        if (str != null) {
            sb.append(str);
        }
        int len = items.length;
        for (int i = 1; i < len; ++i) {
            sb.append(s);
            str = Variant.toExportString(items[i]);
            if (str == null) continue;
            sb.append(str);
        }
        sb.append(ls);
    }

    private static void _$1(StringBuffer sb, Object[] items, String s, String ls, char escapeChar) {
        String str = Variant.toExportString(items[0], escapeChar);
        if (str != null) {
            sb.append(str);
        }
        int len = items.length;
        for (int i = 1; i < len; ++i) {
            sb.append(s);
            str = Variant.toExportString(items[i], escapeChar);
            if (str == null) continue;
            sb.append(str);
        }
        sb.append(ls);
    }
}

