/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;

public class Group
extends SequenceFunction {
    public Object calculate(Context ctx) {
        if (this.param == null) {
            return this.srcSequence.group(this.option);
        }
        if (this.param.isLeaf()) {
            Expression exp = this.param.getLeafExpression();
            return this.srcSequence.group(exp, this.option, ctx);
        }
        if (this.param.getType() == ',') {
            int size = this.param.getSubSize();
            Expression[] exps = new Expression[size];
            for (int i = 0; i < size; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null || !sub.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("group" + mm.getMessage("function.invalidParam"));
                }
                exps[i] = sub.getLeafExpression();
            }
            return this.srcSequence.group(exps, this.option, ctx);
        }
        if (this.param.getType() == ';') {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("group" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            IParam sub1 = this.param.getSub(1);
            Expression[] exps = null;
            String[] names = null;
            if (sub0 != null) {
                ParamInfo2 pi0 = ParamInfo2.parse(sub0, "group", true, false);
                exps = pi0.getExpressions1();
                names = pi0.getExpressionStrs2();
            }
            Expression[] newExps = null;
            String[] newNames = null;
            if (sub1 != null) {
                ParamInfo2 pi1 = ParamInfo2.parse(sub1, "group", true, false);
                newExps = pi1.getExpressions1();
                newNames = pi1.getExpressionStrs2();
            }
            if (this.option != null && this.option.indexOf(115) != -1) {
                int elen = exps == null ? 0 : exps.length;
                int clen = newExps == null ? 0 : newExps.length;
                ArrayList<Object> gathers = new ArrayList<Object>();
                ArrayList<Integer> poss = new ArrayList<Integer>();
                for (int i = 0; i < clen; ++i) {
                    int size = gathers.size();
                    gathers.addAll(Expression.getSpecFunc(newExps[i], Gather.class));
                    if (size == gathers.size()) {
                        gathers.add(newExps[i]);
                    }
                    poss.add(gathers.size());
                }
                Expression[] tempExps = new Expression[gathers.size()];
                for (int i = 0; i < tempExps.length; ++i) {
                    Object obj = gathers.get(i);
                    if (obj instanceof Gather) {
                        Gather gather = (Gather)gathers.get(i);
                        tempExps[i] = new Expression(this.cs, ctx, gather.getFunctionString());
                        continue;
                    }
                    tempExps[i] = (Expression)gathers.get(i);
                }
                Expression[] senExps = new Expression[elen + clen];
                String strExp = null;
                int index = 0;
                boolean exCal = false;
                if (newExps != null) {
                    strExp = newExps[index].toString();
                }
                for (int i = 0; i < tempExps.length; ++i) {
                    if (i >= (Integer)poss.get(index)) {
                        senExps[index + elen] = new Expression(this.cs, ctx, strExp);
                        strExp = newExps[++index].toString();
                    }
                    String funStr = "#" + (i + elen + 1);
                    if ((strExp = Expression.replaceFunc(strExp, tempExps[i].toString(), funStr)).equals(funStr)) continue;
                    exCal = true;
                }
                String[] senNames = null;
                String[] tempNames = newNames;
                if (exCal) {
                    int i;
                    tempNames = null;
                    for (i = 1; i <= elen; ++i) {
                        String funStr = "#" + i;
                        senExps[i - 1] = new Expression(this.cs, ctx, funStr);
                    }
                    if (senExps.length > 0) {
                        senExps[index + elen] = new Expression(this.cs, ctx, strExp);
                    }
                    senNames = new String[elen + newNames.length];
                    for (i = 0; i < elen; ++i) {
                        senNames[i] = names[i];
                    }
                    for (i = 0; i < clen; ++i) {
                        senNames[i + elen] = null == newNames[i] ? newExps[i].toString() : newNames[i];
                    }
                }
                if (senNames == null) {
                    return this.srcSequence.group(exps, names, newExps, newNames, this.option, ctx);
                }
                Table result = this.srcSequence.groups(exps, names, tempExps, tempNames, this.option, ctx);
                result = result.newTable(senNames, senExps, ctx);
                if (elen > 0 && result instanceof Table) {
                    String[] pk = new String[elen];
                    for (int i = 1; i <= elen; ++i) {
                        pk[i - 1] = "#" + i;
                    }
                    result.setPrimary(pk);
                }
                return result;
            }
            return this.srcSequence.group(exps, names, newExps, newNames, this.option, ctx);
        }
        ParamInfo2 pi0 = ParamInfo2.parse(this.param, "group", true, false);
        Expression[] exps0 = pi0.getExpressions1();
        String[] names0 = pi0.getExpressionStrs2();
        return this.srcSequence.group(exps0, names0, null, null, this.option, ctx);
    }
}

