/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.op.IDResult;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class Id
extends SequenceFunction {
    public Object calculate(Context ctx) {
        Expression[] exps;
        IParam expParam;
        if (this.param == null) {
            return this.srcSequence.id(this.option);
        }
        if (this.param.isLeaf()) {
            Expression exp = this.param.getLeafExpression();
            Sequence series = this.srcSequence.calc(exp, "o", ctx);
            series = series.id(this.option);
            if (this.option != null && this.option.indexOf(48) != -1) {
                series.deleteNull(false);
            }
            return series;
        }
        int n = Integer.MAX_VALUE;
        if (this.param.getType() == ';') {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("id" + mm.getMessage("function.invalidParam"));
            }
            expParam = this.param.getSub(0);
            if (expParam == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("id" + mm.getMessage("function.missingParam"));
            }
            IParam countParam = this.param.getSub(1);
            if (countParam == null || !countParam.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("id" + mm.getMessage("function.invalidParam"));
            }
            Object count = countParam.getLeafExpression().calculate(ctx);
            if (!(count instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("id" + mm.getMessage("function.paramTypeError"));
            }
            n = ((Number)count).intValue();
            if (n < 1) {
                return null;
            }
        } else {
            expParam = this.param;
        }
        if (expParam.isLeaf()) {
            exps = new Expression[]{expParam.getLeafExpression()};
        } else {
            int size = expParam.getSubSize();
            exps = new Expression[size];
            for (int i = 0; i < size; ++i) {
                IParam sub = expParam.getSub(i);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("id" + mm.getMessage("function.missingParam"));
                }
                exps[i] = sub.getLeafExpression();
            }
        }
        IDResult id = new IDResult(exps, n, this.option, ctx);
        id.push(this.srcSequence, ctx);
        return id.getResultSequence();
    }
}

