/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.parallel.ClusterMemoryTable;
import com.scudata.resources.EngineMessage;

public class JoinFK
extends SequenceFunction {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.missingParam"));
        }
    }

    public Object calculate(Context ctx) {
        int count;
        String[][] newNames;
        Expression[][] newExps;
        Expression[][] dataExps;
        Object[] codes;
        Expression[][] exps;
        boolean isOrg = this.option != null && this.option.indexOf(111) != -1;
        String fname = null;
        if (this.param.getType() == ',') {
            if (isOrg) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("join" + mm.getMessage("function.invalidParam"));
            }
            exps = new Expression[1][];
            codes = new Object[1];
            dataExps = new Expression[1][];
            newExps = new Expression[1][];
            newNames = new String[1][];
            JoinFK.parseJoinParam(this.param, 0, exps, codes, dataExps, newExps, newNames, ctx);
        } else if (this.param.getType() == ';') {
            count = this.param.getSubSize();
            if (isOrg) {
                IParam sub = this.param.getSub(0);
                if (sub != null) {
                    if (!sub.isLeaf()) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("join" + mm.getMessage("function.invalidParam"));
                    }
                    fname = sub.getLeafExpression().getIdentifierName();
                }
                int len = count - 1;
                exps = new Expression[len][];
                codes = new Object[len];
                dataExps = new Expression[len][];
                newExps = new Expression[len][];
                newNames = new String[len][];
                for (int i = 0; i < len; ++i) {
                    sub = this.param.getSub(i + 1);
                    if (sub == null || sub.getType() != ',') {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("join" + mm.getMessage("function.invalidParam"));
                    }
                    JoinFK.parseJoinParam(sub, i, exps, codes, dataExps, newExps, newNames, ctx);
                }
            } else {
                exps = new Expression[count][];
                codes = new Object[count];
                dataExps = new Expression[count][];
                newExps = new Expression[count][];
                newNames = new String[count][];
                for (int i = 0; i < count; ++i) {
                    IParam sub = this.param.getSub(i);
                    if (sub == null || sub.getType() != ',') {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("join" + mm.getMessage("function.invalidParam"));
                    }
                    JoinFK.parseJoinParam(sub, i, exps, codes, dataExps, newExps, newNames, ctx);
                }
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.invalidParam"));
        }
        count = codes.length;
        Sequence[] seqs = new Sequence[count];
        boolean hasClusterTable = false;
        boolean hasNewExps = false;
        for (int i = 0; i < count; ++i) {
            if (newExps[i] != null && newExps[i].length > 0) {
                hasNewExps = true;
            }
            if (codes[i] instanceof Sequence || codes[i] == null) {
                seqs[i] = (Sequence)codes[i];
                continue;
            }
            if (codes[i] instanceof ClusterMemoryTable) {
                hasClusterTable = true;
                continue;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("join" + mm.getMessage("function.paramTypeError"));
        }
        boolean isIsect = false;
        boolean isDiff = false;
        if (!hasNewExps && this.option != null) {
            if (this.option.indexOf(105) != -1) {
                isIsect = true;
            } else if (this.option.indexOf(100) != -1) {
                isDiff = true;
            }
        }
        ICursor cs = this.srcSequence.cursor();
        if (isIsect) {
            cs.filterJoin(this, exps, seqs, dataExps, this.option, ctx);
        } else if (isDiff) {
            cs.diffJoin(this, exps, seqs, dataExps, this.option, ctx);
        } else if (hasClusterTable) {
            cs.joinRemote(this, fname, exps, codes, dataExps, newExps, newNames, this.option, ctx);
        } else {
            cs.join(this, fname, exps, seqs, dataExps, newExps, newNames, this.option, ctx);
        }
        return cs.fetch();
    }
}

