/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class MGet
extends SequenceFunction {
    public static int convert(int srcLen, int pos, boolean isRepeat, boolean isBackward) {
        if (pos > srcLen) {
            if (isRepeat) {
                return (pos %= srcLen) == 0 ? srcLen : pos;
            }
            return 0;
        }
        if (pos > 0) {
            return pos;
        }
        if (pos == 0) {
            return 0;
        }
        if (isBackward) {
            if (isRepeat) {
                return (pos %= srcLen) < 0 ? pos + srcLen + 1 : 1;
            }
            return (pos += srcLen + 1) > 0 ? pos : 0;
        }
        return 0;
    }

    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("m" + mm.getMessage("function.missingParam"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object calculate(Context ctx) {
        IArray mems = this.srcSequence.getMems();
        int srcLen = mems.size();
        boolean isRepeat = false;
        boolean reserveZero = true;
        boolean isBackward = true;
        if (this.option != null) {
            if (this.option.indexOf(114) != -1) {
                isRepeat = true;
            }
            if (this.option.indexOf(48) != -1) {
                reserveZero = false;
            }
            if (this.option.indexOf(112) != -1) {
                isBackward = false;
            }
        }
        if (this.param.isLeaf()) {
            Object pval = this.param.getLeafExpression().calculate(ctx);
            if (pval == null) {
                return null;
            }
            if (pval instanceof Number) {
                int pos = MGet.convert(srcLen, ((Number)pval).intValue(), isRepeat, isBackward);
                if (pos <= 0) return null;
                return mems.get(pos);
            }
            if (pval instanceof Sequence) {
                Sequence posSequence = (Sequence)pval;
                int posCount = posSequence.length();
                Sequence result = new Sequence(posCount);
                for (int i = 1; i <= posCount; ++i) {
                    Object posObj = posSequence.get(i);
                    if (posObj instanceof Number) {
                        int pos = MGet.convert(srcLen, ((Number)posObj).intValue(), isRepeat, isBackward);
                        if (pos > 0) {
                            result.add(mems.get(pos));
                            continue;
                        }
                        if (!reserveZero) continue;
                        result.add(null);
                        continue;
                    }
                    if (posObj == null) {
                        if (!reserveZero) continue;
                        result.add(null);
                        continue;
                    }
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("m" + mm.getMessage("function.paramTypeError"));
                }
                return result;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("m" + mm.getMessage("function.paramTypeError"));
        }
        if (this.param.getType() == ':') {
            int i;
            Sequence result;
            int pos1;
            int pos0;
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("m" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            if (sub0 != null) {
                Object obj0 = sub0.getLeafExpression().calculate(ctx);
                if (!(obj0 instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("m" + mm.getMessage("function.paramTypeError"));
                }
                int n = ((Number)obj0).intValue();
                pos0 = MGet.convert(srcLen, n, isRepeat, isBackward);
                if (pos0 == 0) {
                    if (n >= 0) return new Sequence();
                    pos0 = 1;
                }
            } else {
                if (srcLen <= 0) return new Sequence();
                pos0 = 1;
            }
            IParam sub1 = this.param.getSub(1);
            if (sub1 != null) {
                Object obj1 = sub1.getLeafExpression().calculate(ctx);
                if (!(obj1 instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("m" + mm.getMessage("function.paramTypeError"));
                }
                int n = ((Number)obj1).intValue();
                pos1 = MGet.convert(srcLen, n, isRepeat, isBackward);
                if (pos1 == 0) {
                    if (n <= srcLen) return new Sequence();
                    pos1 = srcLen;
                }
            } else {
                if (srcLen <= 0) return new Sequence();
                pos1 = srcLen;
            }
            if (pos0 <= pos1) {
                result = new Sequence(pos1 - pos0 + 1);
                for (i = pos0; i <= pos1; ++i) {
                    result.add(mems.get(i));
                }
                return result;
            }
            result = new Sequence(pos0 - pos1 + 1);
            for (i = pos0; i >= pos1; --i) {
                result.add(mems.get(i));
            }
            return result;
        }
        if (this.param.getType() == ',') {
            Sequence result = new Sequence();
            int size = this.param.getSubSize();
            for (int p = 0; p < size; ++p) {
                int pos1;
                int pos0;
                MessageManager mm;
                IParam sub = this.param.getSub(p);
                if (sub == null) {
                    mm = EngineMessage.get();
                    throw new RQException("m" + mm.getMessage("function.invalidParam"));
                }
                if (sub.isLeaf()) {
                    Object pval = sub.getLeafExpression().calculate(ctx);
                    if (pval == null) {
                        if (!reserveZero) continue;
                        result.add(null);
                        continue;
                    }
                    if (pval instanceof Number) {
                        int pos = MGet.convert(srcLen, ((Number)pval).intValue(), isRepeat, isBackward);
                        if (pos > 0) {
                            result.add(mems.get(pos));
                            continue;
                        }
                        if (!reserveZero) continue;
                        result.add(null);
                        continue;
                    }
                    if (pval instanceof Sequence) {
                        Sequence posSequence = (Sequence)pval;
                        int posCount = posSequence.length();
                        for (int i = 1; i <= posCount; ++i) {
                            Object posObj = posSequence.get(i);
                            if (posObj instanceof Number) {
                                int pos = MGet.convert(srcLen, ((Number)posObj).intValue(), isRepeat, isBackward);
                                if (pos > 0) {
                                    result.add(mems.get(pos));
                                    continue;
                                }
                                if (!reserveZero) continue;
                                result.add(null);
                                continue;
                            }
                            if (posObj == null) {
                                if (!reserveZero) continue;
                                result.add(null);
                                continue;
                            }
                            MessageManager mm2 = EngineMessage.get();
                            throw new RQException("m" + mm2.getMessage("function.paramTypeError"));
                        }
                        continue;
                    }
                    MessageManager mm3 = EngineMessage.get();
                    throw new RQException("m" + mm3.getMessage("function.paramTypeError"));
                }
                if (sub.getSubSize() != 2) {
                    mm = EngineMessage.get();
                    throw new RQException("m" + mm.getMessage("function.invalidParam"));
                }
                IParam sub0 = sub.getSub(0);
                if (sub0 != null) {
                    Object obj0 = sub0.getLeafExpression().calculate(ctx);
                    if (!(obj0 instanceof Number)) {
                        MessageManager mm4 = EngineMessage.get();
                        throw new RQException("m" + mm4.getMessage("function.paramTypeError"));
                    }
                    int n = ((Number)obj0).intValue();
                    pos0 = MGet.convert(srcLen, n, isRepeat, isBackward);
                    if (pos0 == 0) {
                        if (n >= 0) continue;
                        pos0 = 1;
                    }
                } else {
                    pos0 = 1;
                }
                IParam sub1 = sub.getSub(1);
                if (sub1 != null) {
                    Object obj1 = sub1.getLeafExpression().calculate(ctx);
                    if (!(obj1 instanceof Number)) {
                        MessageManager mm5 = EngineMessage.get();
                        throw new RQException("m" + mm5.getMessage("function.paramTypeError"));
                    }
                    int n = ((Number)obj1).intValue();
                    pos1 = MGet.convert(srcLen, n, isRepeat, isBackward);
                    if (pos1 == 0) {
                        if (n <= srcLen) continue;
                        pos1 = srcLen;
                    }
                } else {
                    pos1 = srcLen;
                }
                if (pos0 <= pos1) {
                    for (int i = pos0; i <= pos1; ++i) {
                        result.add(mems.get(i));
                    }
                    continue;
                }
                for (int i = pos0; i >= pos1; --i) {
                    result.add(mems.get(i));
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("m" + mm.getMessage("function.invalidParam"));
    }
}

