/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class PSelect
extends SequenceFunction {
    public Object calculate(Context ctx) {
        if (this.param == null) {
            return this.srcSequence.pselect(null, this.option, ctx);
        }
        if (this.param.isLeaf()) {
            return this.srcSequence.pselect(this.param.getLeafExpression(), this.option, ctx);
        }
        char type = this.param.getType();
        if (type == ':') {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
            }
            IParam flt = this.param.getSub(0);
            IParam val = this.param.getSub(1);
            if (flt == null || val == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
            }
            Expression[] exps = new Expression[]{flt.getLeafExpression()};
            Object[] vals = new Object[]{val.getLeafExpression().calculate(ctx)};
            return this.srcSequence.pselect(exps, vals, this.option, ctx);
        }
        if (type == ',') {
            int size = this.param.getSubSize();
            IParam first = this.param.getSub(0);
            IParam last = this.param.getSub(size - 1);
            if (first == null || last == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
            }
            if (first.isLeaf()) {
                if (size != 2 || !last.isLeaf()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
                }
                Object val = last.getLeafExpression().calculate(ctx);
                if (!(val instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pselect" + mm.getMessage("function.paramTypeError"));
                }
                int pos = ((Number)val).intValue();
                return this.srcSequence.pselect(first.getLeafExpression(), pos, this.option, ctx);
            }
            int fltCount = last.isLeaf() ? size - 1 : size;
            Expression[] flts = new Expression[fltCount];
            Object[] values = new Object[fltCount];
            for (int i = 0; i < fltCount; ++i) {
                IParam sub = this.param.getSub(i);
                if (sub == null || sub.getSubSize() != 2) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
                }
                IParam flt = sub.getSub(0);
                IParam val = sub.getSub(1);
                if (flt == null || val == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
                }
                flts[i] = flt.getLeafExpression();
                values[i] = val.getLeafExpression().calculate(ctx);
            }
            if (last.isLeaf()) {
                Object val = last.getLeafExpression().calculate(ctx);
                if (!(val instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("pselect" + mm.getMessage("function.paramTypeError"));
                }
                int pos = ((Number)val).intValue();
                return this.srcSequence.pselect(flts, values, pos, this.option, ctx);
            }
            return this.srcSequence.pselect(flts, values, this.option, ctx);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("pselect" + mm.getMessage("function.invalidParam"));
    }
}

