/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class PosConvert
extends SequenceFunction {
    public void checkValidity() {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("p" + mm.getMessage("function.missingParam"));
        }
        if (!this.param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("p" + mm.getMessage("function.invalidParam"));
        }
    }

    public Object calculate(Context ctx) {
        Object pval = this.param.getLeafExpression().calculate(ctx);
        if (pval == null) {
            return null;
        }
        boolean isRepeat = false;
        boolean reserveZero = true;
        if (this.option != null) {
            if (this.option.indexOf(114) != -1) {
                isRepeat = true;
            }
            if (this.option.indexOf(48) != -1) {
                reserveZero = false;
            }
        }
        int srcLen = this.srcSequence.length();
        if (pval instanceof Number) {
            int pos = ((Number)pval).intValue();
            if (isRepeat) {
                if (pos > srcLen) {
                    return (pos %= srcLen) == 0 ? new Integer(srcLen) : new Integer(pos);
                }
                if (pos >= 0) {
                    return pval;
                }
                if ((pos %= srcLen) < 0) {
                    return new Integer(pos + srcLen + 1);
                }
                return new Integer(1);
            }
            if (pos < 0) {
                if ((pos += srcLen + 1) > 0) {
                    return new Integer(pos);
                }
                return new Integer(0);
            }
            if (pos <= srcLen) {
                return pval;
            }
            return new Integer(0);
        }
        if (pval instanceof Sequence) {
            Sequence posSequence = (Sequence)pval;
            int posCount = posSequence.length();
            int addNum = srcLen + 1;
            Sequence result = new Sequence(posCount);
            Integer zero = new Integer(0);
            if (isRepeat) {
                for (int i = 1; i <= posCount; ++i) {
                    Object posObj = posSequence.get(i);
                    if (!(posObj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("p" + mm.getMessage("function.paramTypeError"));
                    }
                    int pos = ((Number)posObj).intValue();
                    if (pos > srcLen) {
                        if ((pos %= srcLen) != 0) {
                            result.add(new Integer(pos));
                            continue;
                        }
                        result.add(new Integer(srcLen));
                        continue;
                    }
                    if (pos > 0) {
                        result.add(posObj);
                        continue;
                    }
                    if (pos == 0) {
                        if (!reserveZero) continue;
                        result.add(zero);
                        continue;
                    }
                    if ((pos %= srcLen) < 0) {
                        result.add(new Integer(pos + addNum));
                        continue;
                    }
                    result.add(new Integer(1));
                }
            } else {
                for (int i = 1; i <= posCount; ++i) {
                    Object posObj = posSequence.get(i);
                    if (!(posObj instanceof Number)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("p" + mm.getMessage("function.paramTypeError"));
                    }
                    int pos = ((Number)posObj).intValue();
                    if (pos > srcLen) {
                        if (!reserveZero) continue;
                        result.add(zero);
                        continue;
                    }
                    if (pos > 0) {
                        result.add(posObj);
                        continue;
                    }
                    if (pos == 0) {
                        if (!reserveZero) continue;
                        result.add(zero);
                        continue;
                    }
                    if ((pos += addNum) > 0) {
                        result.add(new Integer(pos));
                        continue;
                    }
                    if (!reserveZero) continue;
                    result.add(zero);
                }
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("p" + mm.getMessage("function.paramTypeError"));
    }
}

