/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.IParam;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class Range
extends SequenceFunction {
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("range" + mm.getMessage("function.missingParam"));
        }
        if (this.param.isLeaf()) {
            Object val = this.param.getLeafExpression().calculate(ctx);
            if (!(val instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.paramTypeError"));
            }
            int count = ((Number)val).intValue();
            if (count < 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
            Sequence result = new Sequence(count);
            for (int i = 1; i <= count; ++i) {
                Sequence seq = this._$1(this.srcSequence, i, count);
                result.add(seq);
            }
            return result;
        }
        if (this.param.getSubSize() == 2) {
            IParam sub1 = this.param.getSub(1);
            if (sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
            Object val = sub1.getLeafExpression().calculate(ctx);
            if (!(val instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.paramTypeError"));
            }
            int count = ((Number)val).intValue();
            if (count < 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = this.param.getSub(0);
            if (sub0 == null) {
                Sequence result = new Sequence(count);
                for (int i = 1; i <= count; ++i) {
                    Sequence seq = this._$1(this.srcSequence, i, count);
                    result.add(seq);
                }
                return result;
            }
            val = sub0.getLeafExpression().calculate(ctx);
            if (!(val instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.paramTypeError"));
            }
            int i = ((Number)val).intValue();
            if (i < 1 || i > count) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("range" + mm.getMessage("function.invalidParam"));
            }
            return this._$1(this.srcSequence, i, count);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("range" + mm.getMessage("function.invalidParam"));
    }

    private Sequence _$1(Sequence sequence, int segSeq, int segCount) {
        int len = sequence.length();
        int avg = len / segCount;
        if (avg < 1) {
            if (segSeq > len) {
                return new Sequence(0);
            }
            Sequence result = new Sequence(1);
            result.add(sequence.getMem(segSeq));
        }
        int mod = len % segCount;
        int end = segSeq * avg;
        int start = end - avg;
        if (segSeq <= mod) {
            end += segSeq;
            start += segSeq;
        } else {
            start += mod + 1;
            end += mod;
        }
        Sequence result = new Sequence(end - start + 1);
        while (start <= end) {
            result.add(sequence.getMem(start));
            ++start;
        }
        return result;
    }
}

