/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class Run
extends SequenceFunction {
    public Object calculate(Context ctx) {
        if (this.param == null) {
            return this.srcSequence;
        }
        if (this.param.getType() == ';') {
            Sequence[] syncSequences;
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("run" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = this.param.getSub(1);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("run" + mm.getMessage("function.invalidParam"));
            }
            if (sub.isLeaf()) {
                syncSequences = new Sequence[1];
                Object val = sub.getLeafExpression().calculate(ctx);
                if (!(val instanceof Sequence)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("run" + mm.getMessage("function.paramTypeError"));
                }
                syncSequences[0] = (Sequence)val;
            } else {
                int size = sub.getSubSize();
                syncSequences = new Sequence[size];
                for (int i = 0; i < size; ++i) {
                    IParam p = sub.getSub(i);
                    if (p == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("run" + mm.getMessage("function.invalidParam"));
                    }
                    Object val = p.getLeafExpression().calculate(ctx);
                    if (!(val instanceof Sequence)) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("run" + mm.getMessage("function.paramTypeError"));
                    }
                    syncSequences[i] = (Sequence)val;
                }
            }
            sub = this.param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("run" + mm.getMessage("function.invalidParam"));
            }
            if (sub.isLeaf()) {
                Expression exp = sub.getLeafExpression();
                this.srcSequence.run(exp, this.option, ctx, syncSequences);
            } else {
                ParamInfo2 pi = ParamInfo2.parse(sub, "run", true, false);
                Expression[] exps = pi.getExpressions1();
                Expression[] assignExps = pi.getExpressions2();
                this.srcSequence.run(assignExps, exps, this.option, ctx, syncSequences);
            }
        } else if (this.param.isLeaf()) {
            Expression exp = this.param.getLeafExpression();
            this.srcSequence.run(exp, this.option, ctx);
        } else {
            ParamInfo2 pi = ParamInfo2.parse(this.param, "run", true, false);
            Expression[] exps = pi.getExpressions1();
            Expression[] assignExps = pi.getExpressions2();
            this.srcSequence.run(assignExps, exps, this.option, ctx);
        }
        return this.srcSequence;
    }
}

