/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.sequence;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.SequenceFunction;
import com.scudata.resources.EngineMessage;

public class Sort
extends SequenceFunction {
    public Object calculate(Context ctx) {
        String loc = null;
        IParam param = this.param;
        if (param != null && param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sort" + mm.getMessage("function.invalidParam"));
            }
            IParam locParam = param.getSub(1);
            if (locParam != null) {
                Object obj = locParam.getLeafExpression().calculate(ctx);
                if (obj != null && !(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("sort" + mm.getMessage("function.paramTypeError"));
                }
                loc = (String)obj;
            }
            param = param.getSub(0);
        }
        if (param == null) {
            return this.srcSequence.sort(loc, this.option);
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            return this.srcSequence.sort(exp, loc, this.option, ctx);
        }
        ParamInfo2 pi = ParamInfo2.parse(param, "sort", true, false);
        Expression[] sortExps = pi.getExpressions1();
        Expression[] orderExps = pi.getExpressions2();
        int count = sortExps.length;
        int[] orders = new int[count];
        boolean sign = false;
        for (int i = 0; i < count; ++i) {
            if (orderExps[i] != null) {
                Object obj = orderExps[i].calculate(ctx);
                if (!(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("sort" + mm.getMessage("function.paramTypeError"));
                }
                orders[i] = ((Number)obj).intValue();
                sign = true;
                continue;
            }
            orders[i] = 1;
        }
        if (sign) {
            return this.srcSequence.sort(sortExps, orders, loc, this.option, ctx);
        }
        int[] findex = this._$1(sortExps);
        if (findex != null) {
            return this.srcSequence.sort(sortExps, loc, this.option, findex, ctx);
        }
        return this.srcSequence.sort(sortExps, loc, this.option, ctx);
    }

    private int[] _$1(Expression[] exps) {
        Sequence seq = this.srcSequence;
        if (seq.length() == 0) {
            return null;
        }
        IArray mems = seq.getMems();
        int fcount = exps.length;
        Object obj = mems.get(1);
        if (!(obj instanceof BaseRecord)) {
            return null;
        }
        BaseRecord record = (BaseRecord)obj;
        int[] findex = new int[fcount];
        for (int i = 0; i < fcount; ++i) {
            findex[i] = record.getFieldIndex(exps[i].getIdentifierName());
            if (findex[i] != -1) continue;
            return null;
        }
        return findex;
    }
}

