/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.string;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.MemoryFile;
import com.scudata.dm.cursor.FileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.ParamInfo3;
import com.scudata.expression.StringFunction;
import com.scudata.resources.EngineMessage;
import java.nio.charset.Charset;

public class Import
extends StringFunction {
    public Object calculate(Context ctx) {
        String charset = Charset.defaultCharset().name();
        byte[] bytes = this.srcStr.getBytes();
        MemoryFile mf = new MemoryFile(new byte[][]{bytes});
        FileObject fo = new FileObject(mf, "", charset, null);
        ICursor cursor = Import._$1(fo, this.param, this.option, ctx);
        return cursor.fetch();
    }

    private static ICursor _$1(FileObject fo, IParam param, String option, Context ctx) {
        IParam fieldParam = param;
        IParam sParam = null;
        if (param != null && param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("import" + mm.getMessage("function.invalidParam"));
            }
            fieldParam = param.getSub(0);
            sParam = param.getSub(1);
        }
        String[] fields = null;
        byte[] types = null;
        String[] fmts = null;
        int segSeq = 1;
        int segCount = 1;
        String s = null;
        if (fieldParam != null) {
            ParamInfo3 pi = ParamInfo3.parse(fieldParam, "cursor", true, false, false);
            fields = pi.getExpressionStrs1();
            String[] typeNames = pi.getExpressionStrs2();
            int fcount = fields.length;
            Expression[] exps = pi.getExpressions3();
            for (int i = 0; i < fcount; ++i) {
                String type = typeNames[i];
                if (type == null) continue;
                if (types == null) {
                    types = new byte[fcount];
                }
                if (type.equals("string")) {
                    types[i] = 11;
                } else if (type.equals("int")) {
                    types[i] = 1;
                } else if (type.equals("float")) {
                    types[i] = 6;
                } else if (type.equals("long")) {
                    types[i] = 2;
                } else if (type.equals("decimal")) {
                    types[i] = 7;
                } else if (type.equals("date")) {
                    types[i] = 8;
                } else if (type.equals("datetime")) {
                    types[i] = 10;
                } else if (type.equals("time")) {
                    types[i] = 9;
                } else if (type.equals("bool")) {
                    types[i] = 12;
                } else {
                    try {
                        int len = Integer.parseInt(type);
                        if (len < 1) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(type + mm.getMessage("engine.unknownType"));
                        }
                        types[i] = 103;
                        if (fmts == null) {
                            fmts = new String[fcount];
                        }
                        fmts[i] = type;
                    }
                    catch (NumberFormatException e) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(type + mm.getMessage("engine.unknownType"));
                    }
                }
                if (exps[i] == null) continue;
                Object obj = exps[i].calculate(ctx);
                if (!(obj instanceof String)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("import" + mm.getMessage("function.paramTypeError"));
                }
                if (fmts == null) {
                    fmts = new String[fcount];
                }
                fmts[i] = (String)obj;
            }
        }
        if (sParam != null) {
            Object obj = sParam.getLeafExpression().calculate(ctx);
            if (obj != null && !(obj instanceof String)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("import" + mm.getMessage("function.paramTypeError"));
            }
            s = (String)obj;
        }
        FileCursor cursor = new FileCursor(fo, segSeq, segCount, fields, types, s, option, ctx);
        cursor.setFormats(fmts);
        return cursor;
    }
}

