/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.mfn.table;

import com.scudata.array.ArrayUtil;
import com.scudata.array.BoolArray;
import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.ObjectArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.HashArrayIndexTable;
import com.scudata.dm.HashIndexTable;
import com.scudata.dw.MemoryTable;
import com.scudata.dw.MemoryTableIndex;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.TableFunction;
import com.scudata.expression.ValueList;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ifind
extends TableFunction {
    private MemoryTable _$2;
    private MemoryTableIndex _$1;

    @Override
    public Object calculate(Context ctx) {
        if (this.param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ifind" + mm.getMessage("function.missingParam"));
        }
        if (this.param.getType() == ';') {
            Object[] key;
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ifind" + mm.getMessage("function.invalidParam"));
            }
            IParam sub = this.param.getSub(0);
            if (sub == null) {
                return null;
            }
            ArrayList<Expression> list = new ArrayList<Expression>();
            sub.getAllLeafExpression(list);
            int size = list.size();
            if (size == 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("ifind" + mm.getMessage("function.invalidParam"));
            }
            if (size == 1) {
                key = list.get(0).calculate(ctx);
            } else {
                Object[] keys = new Object[size];
                for (int i = 0; i < size; ++i) {
                    keys[i] = list.get(i).calculate(ctx);
                }
                key = keys;
            }
            String iname = this.param.getSub(1).getLeafExpression().getIdentifierName();
            return ((MemoryTable)this.srcTable).ifind(key, iname, this.option, ctx);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("ifind" + mm.getMessage("function.missingParam"));
    }

    @Override
    public boolean isLeftTypeMatch(Object obj) {
        return obj instanceof MemoryTable;
    }

    @Override
    public void getUsedFields(Context ctx, List<String> resultList) {
        if (this.param.getType() == ';' && this.param.getSubSize() == 2) {
            IParam sub = this.param.getSub(0);
            sub.getUsedFields(ctx, resultList);
        }
    }

    private boolean _$1(MemoryTable srcSequence) {
        IParam param = this.param;
        if (this.option == null || this.option.indexOf("1") == -1) {
            return false;
        }
        if (param == null || param.getType() != ';') {
            return false;
        }
        if (param.getSubSize() != 2) {
            return false;
        }
        if (!param.getSub(0).isLeaf()) {
            return false;
        }
        if (this._$2 != srcSequence) {
            this._$2 = srcSequence;
            String iname = param.getSub(1).getLeafExpression().getIdentifierName();
            this._$1 = srcSequence.getIndex(iname);
        }
        return this._$1.getType() == 1;
    }

    @Override
    public IArray calculateAll(Context ctx) {
        MemoryTable srcSequence;
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof MemoryTable && this._$1(srcSequence = (MemoryTable)leftValue)) {
            int[] index;
            boolean hasP = this.option != null && this.option.indexOf("p") != -1;
            Expression exp = this.param.getSub(0).getLeafExpression();
            if (exp.getHome() instanceof ValueList) {
                Expression[] list = ((Function)exp.getHome()).getParamExpressions(null, true);
                int size = list.length;
                IArray[] arrays = new IArray[size];
                for (int i = 0; i < size; ++i) {
                    arrays[i] = list[i].calculateAll(ctx);
                }
                HashArrayIndexTable hashIndexTable = (HashArrayIndexTable)this._$1.getIndexTable();
                index = hashIndexTable.findAllFirstPos(arrays);
            } else {
                HashIndexTable hashIndexTable = (HashIndexTable)this._$1.getIndexTable();
                IArray array = exp.calculateAll(ctx);
                index = hashIndexTable.findAllFirstPos(array);
            }
            int len = index.length;
            if (hasP) {
                boolean[] signArr = new boolean[len];
                for (int i = 1; i < len; ++i) {
                    if (index[i] > 0) continue;
                    signArr[i] = true;
                }
                return new IntArray(index, signArr, index.length - 1);
            }
            Object[] rs = new Object[len];
            for (int i = 1; i < len; ++i) {
                if (index[i] <= 0) continue;
                rs[i] = srcSequence.getMem(index[i]);
            }
            ObjectArray result = new ObjectArray(rs, len - 1);
            result.setTemporary(true);
            return result;
        }
        return this.calculateAll(leftArray, ctx);
    }

    @Override
    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        MemoryTable srcSequence;
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof MemoryTable && this._$1(srcSequence = (MemoryTable)leftValue)) {
            int[] index;
            boolean hasP = this.option != null && this.option.indexOf("p") != -1;
            BoolArray boolArray = ArrayUtil.booleanValue(signArray, sign);
            Expression exp = this.param.getSub(0).getLeafExpression();
            if (exp.getHome() instanceof ValueList) {
                Expression[] list = ((Function)exp.getHome()).getParamExpressions(null, true);
                int size = list.length;
                IArray[] arrays = new IArray[size];
                for (int i = 0; i < size; ++i) {
                    arrays[i] = list[i].calculateAll(ctx, boolArray, true);
                }
                HashArrayIndexTable hashIndexTable = (HashArrayIndexTable)this._$1.getIndexTable();
                index = hashIndexTable.findAllFirstPos(arrays);
            } else {
                IArray array = exp.calculateAll(ctx, boolArray, true);
                HashIndexTable hashIndexTable = (HashIndexTable)this._$1.getIndexTable();
                index = hashIndexTable.findAllFirstPos(array);
            }
            int len = index.length;
            if (hasP) {
                boolean[] signArr = new boolean[len];
                for (int i = 1; i < len; ++i) {
                    if (index[i] > 0) continue;
                    signArr[i] = true;
                }
                return new IntArray(index, signArr, index.length - 1);
            }
            Object[] rs = new Object[len];
            for (int i = 1; i < len; ++i) {
                if (index[i] <= 0) continue;
                rs[i] = srcSequence.getMem(index[i]);
            }
            ObjectArray result = new ObjectArray(rs, len - 1);
            result.setTemporary(true);
            return result;
        }
        return this.calculateAll(leftArray, ctx, signArray, sign);
    }

    @Override
    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        MemoryTable srcSequence;
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof MemoryTable && this._$1(srcSequence = (MemoryTable)leftValue)) {
            int[] index;
            BoolArray result = leftResult.isTrue();
            Expression exp = this.param.getSub(0).getLeafExpression();
            if (exp.getHome() instanceof ValueList) {
                Expression[] list = ((Function)exp.getHome()).getParamExpressions(null, true);
                int size = list.length;
                IArray[] arrays = new IArray[size];
                for (int i = 0; i < size; ++i) {
                    arrays[i] = list[i].calculateAll(ctx, result, true);
                }
                HashArrayIndexTable hashIndexTable = (HashArrayIndexTable)this._$1.getIndexTable();
                index = hashIndexTable.findAllFirstPos(arrays);
            } else {
                IArray array = exp.calculateAll(ctx, result, true);
                HashIndexTable hashIndexTable = (HashIndexTable)this._$1.getIndexTable();
                index = hashIndexTable.findAllFirstPos(array);
            }
            int len = index.length;
            for (int i = 1; i < len; ++i) {
                if (index[i] >= 1) continue;
                result.set(i, false);
            }
            return result;
        }
        return this.calculateAnd(leftArray, ctx, leftResult);
    }

    @Override
    public int isValueRangeMatch(Context ctx) {
        Object leftValue;
        IArray leftArray = this.left.calculateAll(ctx);
        if (leftArray instanceof ConstArray && (leftValue = ((ConstArray)leftArray).getData()) instanceof MemoryTable) {
            IArray array = this.param.getSub(0).getLeafExpression().calculateRange(ctx);
            if (array == null) {
                return 0;
            }
            MemoryTable srcSequence = (MemoryTable)leftValue;
            if (this._$1(srcSequence)) {
                Object maxValue;
                Object minValue = array.get(1);
                if (Variant.isEquals(minValue, maxValue = array.get(2))) {
                    Object value = this._$1.ifind(minValue, this.option, ctx);
                    if (Variant.isTrue(value)) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        }
        return 0;
    }
}

