/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;

public class Assign
extends Operator {
    public Assign() {
        this.priority = 2;
    }

    public Node optimize(Context ctx) {
        this.right = this.right.optimize(ctx);
        return this;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"=\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"=\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        return this.left.assign(this.right.calculate(ctx), ctx);
    }

    public Object assign(Object value, Context ctx) {
        return this.left.assign(this.right.assign(value, ctx), ctx);
    }

    public byte calcExpValueType(Context ctx) {
        return this.right.calcExpValueType(ctx);
    }

    public boolean canCalculateAll() {
        return false;
    }
}

