/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class IntDivideAssign
extends Operator {
    public IntDivideAssign() {
        this.priority = 2;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"\\=\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"\\=\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Object o1 = this.left.calculate(ctx);
        Object o2 = this.right.calculate(ctx);
        Object result = null;
        if (o1 == null) {
            if (o2 != null && !(o2 instanceof Sequence) && !(o2 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\"\\\"" + mm.getMessage("function.paramTypeError"));
            }
        } else if (o1 instanceof Sequence) {
            if (o2 == null) {
                result = o1;
            } else if (o2 instanceof Sequence) {
                result = ((Sequence)o1).diff((Sequence)o2, false);
            } else {
                Sequence s2 = new Sequence(1);
                s2.add(o2);
                result = ((Sequence)o1).diff(s2, false);
            }
        } else {
            result = Variant.intDivide(o1, o2);
        }
        return this.left.assign(result, ctx);
    }

    public boolean canCalculateAll() {
        return false;
    }
}

