/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class MultiplyAssign
extends Operator {
    public MultiplyAssign() {
        this.priority = 2;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"*=\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"*=\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Object o1 = this.left.calculate(ctx);
        Object o2 = this.right.calculate(ctx);
        return this.left.assign(Variant.multiply(o1, o2), ctx);
    }

    public boolean canCalculateAll() {
        return false;
    }
}

