/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Operator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Not
extends Operator {
    public Not() {
        this.priority = 16;
    }

    public void checkValidity() {
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"!\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        return Variant.isFalse(this.right.calculate(ctx));
    }

    public boolean canCalculateAll() {
        return this.right.canCalculateAll();
    }

    public IArray calculateAll(Context ctx) {
        IArray rightArray = this.right.calculateAll(ctx);
        return rightArray.not();
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray rightArray = this.right.calculateAll(ctx, signArray, sign);
        return rightArray.not();
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        BoolArray result = leftResult.isTrue();
        IArray rightArray = this.right.calculateAll(ctx, result, true);
        int size = result.size();
        for (int i = 1; i <= size; ++i) {
            if (!result.isTrue(i) || !rightArray.isTrue(i)) continue;
            result.set(i, false);
        }
        return result;
    }
}

