/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.expression.operator;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.expression.Relation;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class Or
extends Relation {
    public Or() {
        this.priority = 5;
    }

    public void checkValidity() {
        if (this.left == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"||\"" + mm.getMessage("operator.missingLeftOperation"));
        }
        if (this.right == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"||\"" + mm.getMessage("operator.missingRightOperation"));
        }
        this.left.checkValidity();
        this.right.checkValidity();
    }

    public Object calculate(Context ctx) {
        Object value = this.left.calculate(ctx);
        if (Variant.isTrue(value)) {
            return Boolean.TRUE;
        }
        value = this.right.calculate(ctx);
        if (value instanceof Boolean) {
            return value;
        }
        return value != null;
    }

    public int getRelation() {
        return 8;
    }

    public int getInverseRelation() {
        return 8;
    }

    public IArray calculateAll(Context ctx) {
        IArray leftResult = this.left.calculateAll(ctx);
        if (this.right instanceof Relation) {
            return ((Relation)this.right).calculateOr(ctx, leftResult);
        }
        IArray array = this.right.calculateAll(ctx, leftResult, false);
        return leftResult.calcRelation(array, 8);
    }

    public IArray calculateAll(Context ctx, IArray signArray, boolean sign) {
        IArray leftResult = this.left.calculateAll(ctx, signArray, sign);
        if (this.right instanceof Relation) {
            return ((Relation)this.right).calculateOr(ctx, leftResult);
        }
        IArray array = this.right.calculateAll(ctx, leftResult, false);
        return leftResult.calcRelation(array, 8);
    }

    public BoolArray calculateAnd(Context ctx, IArray leftResult) {
        IArray result = this.calculateAll(ctx, leftResult, true);
        return leftResult.calcRelation(result, 7);
    }

    public BoolArray calculateOr(Context ctx, IArray leftResult) {
        IArray array;
        if (this.left instanceof Relation) {
            leftResult = ((Relation)this.left).calculateOr(ctx, leftResult);
        } else {
            array = this.left.calculateAll(ctx, leftResult, false);
            leftResult = leftResult.calcRelation(array, 8);
        }
        if (this.right instanceof Relation) {
            return ((Relation)this.right).calculateOr(ctx, leftResult);
        }
        array = this.right.calculateAll(ctx, leftResult, false);
        return leftResult.calcRelation(array, 8);
    }

    public int isValueRangeMatch(Context ctx) {
        int result = this.left.isValueRangeMatch(ctx);
        if (result == 1) {
            return result;
        }
        int rightResult = this.right.isValueRangeMatch(ctx);
        return result < rightResult ? rightResult : result;
    }
}

