/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide;

import com.scudata.cellset.datamodel.Command;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.dm.KeyWord;
import com.scudata.expression.DfxFunction;
import com.scudata.expression.Expression;
import com.scudata.expression.fn.PCSFunction;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CellSetUtil;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FuncUtil {
    private static String replaceMacros(String text) {
        int len = text.length();
        StringBuffer newStr = null;
        int idx = 0;
        while (idx < len) {
            char c = text.charAt(idx);
            if (c == '\'' || c == '\"') {
                int match = Sentence.scanQuotation(text, idx);
                if (match < 0) {
                    if (newStr != null) {
                        newStr.append(c);
                    }
                    ++idx;
                    continue;
                }
                if (newStr != null) {
                    newStr.append(text.substring(idx, match + 1));
                }
                idx = match + 1;
                continue;
            }
            if (KeyWord.isSymbol(c)) {
                if (newStr != null) {
                    newStr.append(c);
                }
                ++idx;
                continue;
            }
            int last = KeyWord.scanId(text, idx + 1);
            char lc = text.charAt(last - 1);
            if (last < len && lc == '$') {
                char nc = text.charAt(last);
                if (nc == '{') {
                    int match = Sentence.scanBrace(text, last);
                    if (match == -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("{,}" + mm.getMessage("Expression.illMatched"));
                    }
                    if (newStr == null) {
                        newStr = new StringBuffer(len + 80);
                        newStr.append(text.substring(0, idx));
                    }
                    newStr.append(text.substring(idx, last - 1));
                    idx = match + 1;
                    continue;
                }
                if (newStr != null) {
                    newStr.append(text.substring(idx, last));
                }
                idx = last;
                continue;
            }
            if (newStr != null) {
                String subStr = text.substring(idx, last);
                newStr.append(subStr);
            }
            idx = last;
        }
        return newStr == null ? text : newStr.toString();
    }

    private static int deepCopy(PgmCellSet.FuncInfo funcInfo, PgmCellSet resultCs, int resultRowIndex, ArrayList<String> fnList) {
        int resultEndRow;
        PgmNormalCell cell = funcInfo.getCell();
        PgmCellSet pcs = (PgmCellSet)cell.getCellSet();
        int startRow = cell.getRow();
        int startCol = cell.getCol();
        int endRow = funcInfo.getEndRow();
        int endCol = pcs.getColCount();
        int rowCount = resultCs.getRowCount();
        int colCount = resultCs.getColCount();
        if (endCol > colCount) {
            resultCs.addCol(endCol - colCount);
        }
        if ((resultEndRow = resultRowIndex + endRow - startRow) > rowCount) {
            resultCs.addRow(resultEndRow - rowCount);
        }
        PgmNormalCell srcCell = pcs.getPgmNormalCell(startRow, startCol);
        PgmNormalCell resultCell = resultCs.getPgmNormalCell(resultRowIndex, startCol);
        String expStr = srcCell.getExpString();
        resultCell.setExpString(expStr);
        boolean[] error = new boolean[1];
        int rowIncrement = resultRowIndex - startRow;
        int r = startRow;
        while (r <= endRow) {
            int c = startCol + 1;
            while (c <= endCol) {
                srcCell = pcs.getPgmNormalCell(r, c);
                expStr = srcCell.getExpString();
                if (srcCell.needRegulateString()) {
                    expStr = resultCs.relativeRegulateString(pcs, expStr, rowIncrement, 0, error);
                }
                resultCell = resultCs.getPgmNormalCell(resultRowIndex, c);
                resultCell.setExpString(expStr);
                ++c;
            }
            ++r;
            ++resultRowIndex;
        }
        Context ctx = pcs.getContext();
        int nextRow = resultEndRow + 1;
        int r2 = startRow;
        while (r2 <= endRow) {
            int c = startCol + 1;
            while (c <= endCol) {
                srcCell = pcs.getPgmNormalCell(r2, c);
                Command command = srcCell.getCommand();
                String str = null;
                if (command != null) {
                    str = command.getExpression();
                } else {
                    expStr = srcCell.getExpString();
                    if (expStr != null && (expStr.startsWith("=") || expStr.startsWith(">"))) {
                        str = expStr.substring(1);
                    }
                }
                if (str != null) {
                    str = FuncUtil.replaceMacros(str);
                    try {
                        Expression exp = new Expression(pcs, ctx, str, false, false);
                        ArrayList<Object> pcsFuncList = Expression.getSpecFunc(exp, PCSFunction.class);
                        for (Object func : pcsFuncList) {
                            PCSFunction pcsFunc = (PCSFunction)func;
                            funcInfo = pcsFunc.getFuncInfo();
                            String fnName = funcInfo.getFnName();
                            if (fnList.contains(fnName)) continue;
                            fnList.add(fnName);
                            nextRow = FuncUtil.deepCopy(funcInfo, resultCs, nextRow, fnList);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                ++c;
            }
            ++r2;
            ++resultRowIndex;
        }
        return nextRow;
    }

    public static void deepFuncCopy(String funcList, String splxList, String targetSplx) {
        if (funcList == null || funcList.length() == 0 || splxList == null || splxList.length() == 0) {
            return;
        }
        JobSpace js = new JobSpace("tmp_func_jobspace");
        Context ctx = new Context();
        ctx.setJobSpace(js);
        ArgumentTokenizer tokenizer = new ArgumentTokenizer(splxList);
        while (tokenizer.hasNext()) {
            String pathName = tokenizer.next();
            FileObject fo = new FileObject(pathName);
            PgmCellSet pcs = fo.readPgmCellSet();
            pcs.setContext(ctx);
            HashMap<String, PgmCellSet.FuncInfo> map = pcs.getFunctionMap();
            Set<Map.Entry<String, PgmCellSet.FuncInfo>> set = map.entrySet();
            for (Map.Entry<String, PgmCellSet.FuncInfo> entry : set) {
                js.addDFXFunction(entry.getKey(), entry.getValue());
            }
        }
        tokenizer = new ArgumentTokenizer(funcList);
        ArrayList<String> fnList = new ArrayList<String>();
        PgmCellSet resultCs = new PgmCellSet(1, 1);
        int nextRow = 1;
        while (tokenizer.hasNext()) {
            String fnName = tokenizer.next();
            if (fnList.contains(fnName)) continue;
            DfxFunction fn = js.getDFXFunction(fnName);
            if (fn == null) {
                throw new RQException("\u6ca1\u6709\u627e\u5230\u51fd\u6570\uff1a" + fnName);
            }
            fnList.add(fnName);
            PgmCellSet.FuncInfo funcInfo = fn.getFuncInfo();
            nextRow = FuncUtil.deepCopy(funcInfo, resultCs, nextRow, fnList);
        }
        FileObject fo = new FileObject(targetSplx);
        OutputStream os = fo.getBufferedOutputStream(false);
        try {
            try {
                CellSetUtil.writePgmCellSet(os, resultCs);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static int copy(PgmCellSet.FuncInfo funcInfo, PgmCellSet resultCs, int resultRowIndex, ArrayList<String> fnList) {
        int resultEndRow;
        PgmNormalCell cell = funcInfo.getCell();
        PgmCellSet pcs = (PgmCellSet)cell.getCellSet();
        int startRow = cell.getRow();
        int startCol = cell.getCol();
        int endRow = funcInfo.getEndRow();
        int endCol = pcs.getColCount();
        int rowCount = resultCs.getRowCount();
        int colCount = resultCs.getColCount();
        if (endCol > colCount) {
            resultCs.addCol(endCol - colCount);
        }
        if ((resultEndRow = resultRowIndex + endRow - startRow) > rowCount) {
            resultCs.addRow(resultEndRow - rowCount);
        }
        PgmNormalCell srcCell = pcs.getPgmNormalCell(startRow, startCol);
        PgmNormalCell resultCell = resultCs.getPgmNormalCell(resultRowIndex, startCol);
        String expStr = srcCell.getExpString();
        resultCell.setExpString(expStr);
        boolean[] error = new boolean[1];
        int rowIncrement = resultRowIndex - startRow;
        int r = startRow;
        while (r <= endRow) {
            int c = startCol + 1;
            while (c <= endCol) {
                srcCell = pcs.getPgmNormalCell(r, c);
                expStr = srcCell.getExpString();
                if (srcCell.needRegulateString()) {
                    expStr = resultCs.relativeRegulateString(pcs, expStr, rowIncrement, 0, error);
                }
                resultCell = resultCs.getPgmNormalCell(resultRowIndex, c);
                resultCell.setExpString(expStr);
                ++c;
            }
            ++r;
            ++resultRowIndex;
        }
        return resultEndRow + 1;
    }

    public static void funcCopy(String funcList, String splxList, String targetSplx) {
        if (funcList == null || funcList.length() == 0 || splxList == null || splxList.length() == 0) {
            return;
        }
        JobSpace js = new JobSpace("tmp_func_jobspace");
        Context ctx = new Context();
        ctx.setJobSpace(js);
        ArgumentTokenizer tokenizer = new ArgumentTokenizer(splxList);
        while (tokenizer.hasNext()) {
            String pathName = tokenizer.next();
            FileObject fo = new FileObject(pathName);
            PgmCellSet pcs = fo.readPgmCellSet();
            pcs.setContext(ctx);
            HashMap<String, PgmCellSet.FuncInfo> map = pcs.getFunctionMap();
            Set<Map.Entry<String, PgmCellSet.FuncInfo>> set = map.entrySet();
            for (Map.Entry<String, PgmCellSet.FuncInfo> entry : set) {
                js.addDFXFunction(entry.getKey(), entry.getValue());
            }
        }
        tokenizer = new ArgumentTokenizer(funcList);
        ArrayList<String> fnList = new ArrayList<String>();
        PgmCellSet resultCs = new PgmCellSet(1, 1);
        int nextRow = 1;
        while (tokenizer.hasNext()) {
            String fnName = tokenizer.next();
            if (fnList.contains(fnName)) continue;
            DfxFunction fn = js.getDFXFunction(fnName);
            if (fn == null) {
                throw new RQException("\u6ca1\u6709\u627e\u5230\u51fd\u6570\uff1a" + fnName);
            }
            fnList.add(fnName);
            PgmCellSet.FuncInfo funcInfo = fn.getFuncInfo();
            nextRow = FuncUtil.copy(funcInfo, resultCs, nextRow, fnList);
        }
        FileObject fo = new FileObject(targetSplx);
        OutputStream os = fo.getBufferedOutputStream(false);
        try {
            try {
                CellSetUtil.writePgmCellSet(os, resultCs);
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                os.close();
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }
}

