/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.Console;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAppFrame;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.swing.RQTextArea;
import java.awt.Cursor;
import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public abstract class AppFrame
extends JFrame
implements IAppFrame {
    private static final long serialVersionUID = 1L;
    protected JDesktopPane desk;
    ImageIcon frameIcon = null;
    public static final String RELEASE_DATE = "2025-08-01";

    public AppFrame() {
        super("");
        try {
            Object[] objectArray = new Object[2];
            objectArray[0] = "ctrl F9";
            UIManager.put("Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(objectArray));
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
        this.mixpanel();
    }

    public static void holdConsole() {
        Font font = new Font("Dialog", GC.font.getStyle(), GC.font.getSize());
        if (GV.console == null) {
            RQTextArea jta = new RQTextArea();
            jta.setFont(font);
            GV.console = new Console(jta);
        } else {
            GV.console.getTextArea().setFont(font);
        }
    }

    public abstract String getProductName();

    @Override
    public abstract boolean exit();

    public abstract void quit();

    @Override
    public abstract JInternalFrame openSheetFile(String var1) throws Exception;

    public JInternalFrame openSheetFile(InputStream in, String fileName, byte sheetType) throws Exception {
        return null;
    }

    public abstract void changeMenuAndToolBar(JMenuBar var1, JToolBar var2);

    public abstract boolean closeSheet(Object var1);

    @Override
    public abstract boolean closeAll();

    public void resetRunStatus() {
    }

    public JDesktopPane getDesk() {
        return this.desk;
    }

    public void setProgramPart() {
        String fixTitle = this.getFixTitle();
        this.setTitle(fixTitle);
        this.frameIcon = GM.getLogoImage(true);
        if (this.frameIcon != null) {
            this.setIconImage(this.frameIcon.getImage());
        }
    }

    public ImageIcon getFrameIcon() {
        return this.frameIcon;
    }

    public String resetTitle() {
        String fixTitle = this.getFixTitle();
        IPrjxSheet sheet = GV.appSheet;
        if (sheet != null) {
            String sheetTitle = sheet.getSheetTitle();
            fixTitle = String.valueOf(fixTitle) + "  [" + sheetTitle + "]";
        }
        this.setTitle(fixTitle);
        return fixTitle;
    }

    public void arrangeSheet(short cmd) throws Exception {
        JInternalFrame[] frames = this.desk.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        int x = 0;
        int y = 0;
        int w = 450;
        int h = 280;
        switch (cmd) {
            case 205: {
                int i = 0;
                while (i < frames.length) {
                    if (!frames[i].isIcon()) {
                        frames[i].setMaximum(false);
                        frames[i].setBounds(x, y, w, h);
                        frames[i].setSelected(true);
                        x += 20;
                        y += 20;
                    }
                    ++i;
                }
                break;
            }
            case 210: {
                int deskWidth = this.desk.getWidth();
                w = deskWidth / frames.length;
                h = this.desk.getHeight();
                int i = 0;
                while (i < frames.length) {
                    x = i * w;
                    if (!frames[i].isIcon()) {
                        frames[i].setMaximum(false);
                        frames[i].setBounds(x, y, w, h);
                        frames[i].update(frames[i].getGraphics());
                    }
                    ++i;
                }
                break;
            }
            case 215: {
                int deskHeight = this.desk.getHeight();
                h = deskHeight / frames.length;
                w = this.desk.getWidth();
                int i = 0;
                while (i < frames.length) {
                    y = i * h;
                    if (!frames[i].isIcon()) {
                        frames[i].setMaximum(false);
                        frames[i].setBounds(x, y, w, h);
                        frames[i].update(frames[i].getGraphics());
                    }
                    ++i;
                }
                break;
            }
            case 220: {
                JInternalFrame f = this.desk.getSelectedFrame();
                if (f == null) break;
                f.setMaximum(true);
                f.setBounds(0, 0, this.desk.getWidth(), this.desk.getHeight());
            }
        }
        this.desk.invalidate();
        this.desk.update(this.desk.getGraphics());
    }

    public String getFixTitle() {
        String title = this.getProductName();
        return title;
    }

    public void openConnection(String dsName) {
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DataSource ds = GV.dsModel.getDataSource(dsName);
                if (ds != null) {
                    ds.getDBSession();
                }
            }
            catch (Throwable e2) {
                GM.showException(GV.appFrame, e2);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public JInternalFrame getSheet(String title) {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].getTitle().equalsIgnoreCase(title)) {
                return frames[i];
            }
            ++i;
        }
        return null;
    }

    public boolean showSheet(JInternalFrame s) throws Exception {
        return this.showSheet(s, true);
    }

    public boolean showSheet(JInternalFrame s, boolean showIcon) throws Exception {
        if (s == null) {
            return false;
        }
        boolean setMax = false;
        if (GV.appSheet != null) {
            if (!GV.appSheet.submitEditor()) {
                return false;
            }
            if (GV.appSheet.isMaximum() && !GV.appSheet.isIcon()) {
                setMax = true;
                GV.appSheet.resumeSheet();
                if (!s.isMaximum() || s.isIcon() && s.isMaximum()) {
                    ((IPrjxSheet)s).setForceMax();
                }
            }
        }
        s.toFront();
        s.setVisible(true);
        s.setSelected(true);
        if (showIcon && s.isIcon()) {
            s.setIcon(false);
        }
        if (setMax) {
            s.setMaximum(true);
        }
        return true;
    }

    public JInternalFrame getActiveSheet() {
        return this.desk.getSelectedFrame();
    }

    public static void resetInstallDirectories() {
        String startHome = System.getProperty("start.home");
        if (!StringUtils.isValidString(startHome)) {
            System.setProperty("raqsoft.home", System.getProperty("user.home"));
        } else {
            System.setProperty("raqsoft.home", String.valueOf(startHome));
        }
        String[] path = new String[]{"config", "logo", "log", "backup"};
        int i = 0;
        while (i < path.length) {
            File f = new File(GM.getAbsolutePath(path[i]));
            if (!f.exists()) {
                f.mkdirs();
            }
            ++i;
        }
    }

    public JInternalFrame[] getAllSheets() {
        return this.desk.getAllFrames();
    }

    public static void initGlobalFontSetting(Font fnt) {
        FontUIResource fontRes = new FontUIResource(fnt);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, fontRes);
        }
    }

    protected void mixpanel() {
    }

    public List<String> getSheetNameList() {
        JInternalFrame[] frames;
        ArrayList<String> sheetNameList = new ArrayList<String>();
        JInternalFrame[] jInternalFrameArray = frames = this.desk.getAllFrames();
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n2];
            sheetNameList.add(jInternalFrame.getTitle());
            ++n2;
        }
        return sheetNameList;
    }

    public void showNextSheet(boolean isCtrlDown) {
        if (this.desk == null) {
            return;
        }
        JInternalFrame[] frames = this.desk.getAllFrames();
        if (frames.length <= 1) {
            return;
        }
        JInternalFrame activeSheet = this.getActiveSheet();
        int size = frames.length;
        int index = size - 1;
        int i = 0;
        while (i < size) {
            if (frames[i].equals(activeSheet)) {
                if (isCtrlDown) {
                    index = size - 1;
                    break;
                }
                if (i == size - 1) {
                    index = 0;
                    break;
                }
                index = i + 1;
                break;
            }
            ++i;
        }
        try {
            if (!this.showSheet(frames[index])) {
                return;
            }
            this.refreshToolBarWindow(frames[index]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refreshToolBarWindow(JInternalFrame sheet) {
    }

    public String getReleaseDate() {
        return RELEASE_DATE;
    }
}

