/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.IntArrayList;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigMenuAction;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.GMSpl;
import com.scudata.ide.spl.GVSpl;
import com.scudata.ide.spl.resources.IdeSplMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AppMenu
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    public JMenuItem[] connItem = new JMenuItem[20];
    public JMenuItem[] fileItem = new JMenuItem[20];
    public JMenuItem[] mainPathItem = new JMenuItem[20];
    public JMenuItem[] configFileItem = new JMenuItem[20];
    private static final int LIVE_MENU_COUNT = 9;
    protected JMenu tmpLiveMenu;
    protected static HashSet<JMenuItem> liveMenuItems = new HashSet();
    protected static JMenu liveMenu;
    protected static HashMap<Short, JMenuItem> menuItems;
    private MessageManager mManager = IdeCommonMessage.get();
    public static JMenu windowMenu;
    public static JMenu helpMenu;
    protected static HashSet<JMenuItem> tmpLiveMenuItems;
    private MessageManager mm = IdeCommonMessage.get();
    private final String PRE_LIVE_MENU = "live_";
    private static final String MAINPATH_OTHER;
    private static final String CONFIGFILE_OTHER;
    protected ActionListener menuAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String menuId = "";
            try {
                JMenuItem mi = (JMenuItem)e.getSource();
                menuId = mi.getName();
                short cmdId = Short.parseShort(menuId);
                AppMenu.this.executeCmd(cmdId);
            }
            catch (Exception ex) {
                GM.showException(GV.appFrame, ex);
            }
        }
    };
    protected MessageManager mmSpl = IdeSplMessage.get();

    static {
        menuItems = new HashMap();
        tmpLiveMenuItems = new HashSet();
        MAINPATH_OTHER = IdeCommonMessage.get().getMessage("prjxappmenu.other");
        CONFIGFILE_OTHER = IdeCommonMessage.get().getMessage("prjxappmenu.other");
    }

    public void resetPrivilegeMenu() {
    }

    public void setEnable(short[] menuIds, boolean enable) {
        int i = 0;
        while (i < menuIds.length) {
            JMenuItem mi = menuItems.get(menuIds[i]);
            if (mi != null) {
                mi.setEnabled(enable);
            }
            ++i;
        }
    }

    public void setMenuVisible(short[] menuIds, boolean visible) {
        int i = 0;
        while (i < menuIds.length) {
            JMenuItem mi = menuItems.get(menuIds[i]);
            if (mi != null) {
                mi.setVisible(visible);
            }
            ++i;
        }
    }

    public void addLiveMenu(String sheetTitle) {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object o = e.getSource();
                    if (o == null) {
                        return;
                    }
                    JMenuItem rmi = (JMenuItem)o;
                    rmi.setIcon(AppMenu.this.getSelectedIcon(true));
                    JMenuItem tt = (JMenuItem)e.getSource();
                    JInternalFrame sheet = GV.appFrame.getSheet(tt.getText());
                    if (!GV.appFrame.showSheet(sheet)) {
                        return;
                    }
                    GV.toolWin.refreshSheet(sheet);
                }
                catch (Throwable e2) {
                    GM.showException(GV.appFrame, e2);
                }
            }
        };
        if (liveMenu == null) {
            return;
        }
        JMenuItem mi = GM.getMenuByName(this, "live_" + sheetTitle);
        this.resetLiveMenuItems();
        if (mi == null) {
            if (liveMenu.getItemCount() == 8) {
                liveMenu.addSeparator();
            }
            JMenuItem rmi = new JMenuItem(sheetTitle);
            rmi.setName("live_" + sheetTitle);
            rmi.addActionListener(action);
            liveMenu.add(rmi);
            liveMenuItems.add(rmi);
            rmi.setIcon(this.getSelectedIcon(true));
        } else {
            JMenuItem rmi = mi;
            rmi.setIcon(this.getSelectedIcon(true));
        }
    }

    private Icon getSelectedIcon(boolean isSelected) {
        if (isSelected) {
            return GM.getMenuImageIcon("selected");
        }
        return GM.getMenuImageIcon("blank");
    }

    public void removeLiveMenu(String sheetTitle) {
        JMenuItem mi = GM.getMenuByName(this, "live_" + sheetTitle);
        if (mi != null) {
            liveMenu.remove(mi);
            liveMenuItems.remove(mi);
        }
        if (liveMenu != null && liveMenu.getItemCount() == 9) {
            liveMenu.remove(8);
        }
    }

    public void renameLiveMenu(String srcName, String tarName) {
        JMenuItem mi = GM.getMenuByName(this, srcName);
        if (mi != null) {
            mi.setName(tarName);
            mi.setText(tarName);
        }
    }

    private void resetLiveMenuItems() {
        for (JMenuItem rmi : liveMenuItems) {
            rmi.setIcon(this.getSelectedIcon(false));
        }
    }

    public abstract void dataSourceConnected();

    public JMenu getRecentConn() {
        AbstractAction actionNew = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem tt = (JMenuItem)e.getSource();
                GV.appFrame.openConnection(tt.getText());
                try {
                    ConfigUtilIde.writeActiveConfig();
                }
                catch (Exception ex) {
                    Logger.debug(ex);
                }
                AppMenu.this.dataSourceConnected();
            }
        };
        JMenu menu = GM.getMenuItem(this.mManager.getMessage("menu.file.recentconns"), 'T', false);
        try {
            ConfigFile.getConfigFile().loadRecentConnection(this.connItem);
            int i = 0;
            while (i < 20) {
                this.connItem[i].addActionListener(actionNew);
                if (this.connItem[i].isVisible()) {
                    menu.add(this.connItem[i]);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
        }
        return menu;
    }

    public void refreshRecentConn(String dsName) throws Throwable {
        String tempConnName;
        if (!StringUtils.isValidString(dsName)) {
            return;
        }
        int point = 19;
        int i = 0;
        while (i < 20) {
            if (this.connItem[i] == null) {
                return;
            }
            tempConnName = this.connItem[i].getText();
            if (dsName.equals(tempConnName)) {
                point = i;
                break;
            }
            ++i;
        }
        i = point;
        while (i > 0) {
            tempConnName = this.connItem[i - 1].getText();
            this.connItem[i].setText(tempConnName);
            this.connItem[i].setVisible(!tempConnName.equals(""));
            --i;
        }
        this.connItem[0].setText(dsName);
        this.connItem[0].setVisible(true);
        ConfigFile.getConfigFile().storeRecentConnections(this.connItem);
    }

    public JMenu getWindowMenu() {
        return this.getWindowMenu(true);
    }

    public JMenu getWindowMenu(boolean showViewConsole) {
        if (windowMenu != null) {
            return windowMenu;
        }
        JMenu menu = this.getCommonMenuItem("window", 'W', true);
        menu.add(this.newCommonMenuItem((short)251, "edit.showwinlist", 'W', 64, false));
        JMenuItem mi = this.newCommonMenuItem((short)253, "edit.viewconsole", 'Q', 9, false);
        mi.setEnabled(showViewConsole);
        mi.setVisible(showViewConsole);
        menu.add(mi);
        mi = this.newCommonMenuItem((short)255, "edit.viewright", 'R', 9, false);
        mi.setEnabled(showViewConsole);
        mi.setVisible(showViewConsole);
        menu.add(mi);
        menu.addSeparator();
        menu.add(this.newCommonMenuItem((short)205, "window.cascade", 'C', 64, true));
        menu.add(this.newCommonMenuItem((short)210, "window.tilehorizontal", 'H', 64));
        menu.add(this.newCommonMenuItem((short)215, "window.tilevertical", 'V', 64));
        menu.add(this.newCommonMenuItem((short)220, "window.layer", 'M', 64));
        windowMenu = menu;
        return menu;
    }

    @Override
    public JMenu getHelpMenu() {
        if (helpMenu != null) {
            return helpMenu;
        }
        JMenu menu = this.getCommonMenuItem("help", 'H', true);
        List<Object> configMenus = this.buildMenuFromConfig();
        int i = 0;
        while (i < configMenus.size()) {
            Object o = configMenus.get(i);
            if (o instanceof JMenu) {
                menu.add((Component)((JMenu)o), i);
                ((JMenu)o).setIcon(GM.getMenuImageIcon("blank"));
            } else if (o instanceof JMenuItem) {
                menu.add((Component)((JMenuItem)o), i);
                ((JMenuItem)o).setIcon(GM.getMenuImageIcon("blank"));
            } else if (o instanceof JSeparator) {
                menu.add((Component)((JSeparator)o), i);
            }
            ++i;
        }
        menu.add(this.newCommonMenuItem((short)305, "help.about", 'A', 64, true));
        menu.add(this.newCommonMenuItem((short)310, "help.memorytidy", 'M', 64));
        helpMenu = menu;
        return menu;
    }

    public JMenu getCommonMenuItem(String menuId, char mneKey, boolean isMain) {
        return GM.getMenuItem(this.mm.getMessage("menu." + menuId), mneKey, isMain);
    }

    public void resetLiveMenu() {
        liveMenuItems = tmpLiveMenuItems;
        liveMenu = this.tmpLiveMenu;
    }

    public void refreshRecentFile(String fileName) throws Throwable {
        String tempFileName;
        if (!StringUtils.isValidString(fileName)) {
            return;
        }
        GM.setCurrentPath(fileName);
        int point = 19;
        int i = 0;
        while (i < this.fileItem.length) {
            tempFileName = this.fileItem[i].getText();
            if (fileName.equals(tempFileName)) {
                point = i;
                break;
            }
            ++i;
        }
        i = point;
        while (i > 0) {
            tempFileName = this.fileItem[i - 1].getText();
            this.fileItem[i].setText(tempFileName);
            this.fileItem[i].setVisible(!tempFileName.equals(""));
            --i;
        }
        this.fileItem[0].setText(fileName);
        this.fileItem[0].setVisible(true);
        ConfigFile.getConfigFile().storeRecentFiles("dm", this.fileItem);
    }

    public void refreshRecentFileOnClose(String fileName, JInternalFrame[] frames) throws Throwable {
        if (!StringUtils.isValidString(fileName)) {
            return;
        }
        if (frames == null || frames.length == 0) {
            return;
        }
        int point = -1;
        int i = 0;
        while (i < this.fileItem.length) {
            if (fileName.equals(this.fileItem[i].getText())) {
                point = i;
                break;
            }
            ++i;
        }
        if (point == -1) {
            return;
        }
        if (frames.length > 20) {
            i = point;
            while (i < 19) {
                String tempFileName = this.fileItem[i + 1].getText();
                this.fileItem[i].setText(tempFileName);
                this.fileItem[i].setVisible(!tempFileName.equals(""));
                ++i;
            }
            HashSet<String> lastNames = new HashSet<String>();
            int i2 = 0;
            while (i2 < 19) {
                if (StringUtils.isValidString(this.fileItem[i2].getText())) {
                    lastNames.add(this.fileItem[i2].getText());
                }
                ++i2;
            }
            long maxTime = 0L;
            String lastSheetName = null;
            JInternalFrame[] jInternalFrameArray = frames;
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                JInternalFrame frame = jInternalFrameArray[n2];
                IPrjxSheet sheet = (IPrjxSheet)frame;
                String sheetName = sheet.getFileName();
                if (!(lastNames.contains(sheetName) || lastSheetName != null && sheet.getCreateTime() <= maxTime)) {
                    maxTime = sheet.getCreateTime();
                    lastSheetName = sheetName;
                }
                ++n2;
            }
            this.fileItem[19].setText(lastSheetName);
            this.fileItem[19].setVisible(true);
        } else {
            i = point;
            while (i < frames.length + 1) {
                String tempFileName = this.fileItem[i + 1].getText();
                this.fileItem[i].setText(tempFileName);
                this.fileItem[i].setVisible(!tempFileName.equals(""));
                ++i;
            }
            this.fileItem[frames.length].setText(fileName);
            this.fileItem[frames.length].setVisible(true);
        }
        ConfigFile.getConfigFile().storeRecentFiles("dm", this.fileItem);
    }

    public JMenu getRecentFile() {
        final JMenu menu = this.getCommonMenuItem("file.recentfiles", 'F', false);
        AbstractAction actionNew = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            /*
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block11: {
                    tt = (JMenuItem)e.getSource();
                    try {
                        GV.appFrame.openSheetFile(tt.getText());
                        break block11;
                    }
                    catch (Throwable t) {
                        GM.showException(GV.appFrame, t);
                        if (!StringUtils.isValidString(tt.getText()) || (f = new File(tt.getText())).exists() || AppMenu.this.fileItem == null) break block11;
                        len = AppMenu.this.fileItem.length;
                        index = -1;
                        i = 0;
                        ** while (i < len)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (tt.getText().equalsIgnoreCase(AppMenu.this.fileItem[i].getText())) {
                            index = i;
                            break;
                        }
                        ++i;
                        continue;
                    }
lbl18:
                    // 2 sources

                    if (index == -1) {
                        return;
                    }
                    newFileItem = new JMenuItem[20];
                    if (index > 0) {
                        System.arraycopy(AppMenu.this.fileItem, 0, newFileItem, 0, index);
                    }
                    if (index < len - 1) {
                        System.arraycopy(AppMenu.this.fileItem, index + 1, newFileItem, index, len - index - 1);
                    }
                    newFileItem[len - 1] = new JMenuItem("");
                    newFileItem[len - 1].setVisible(false);
                    newFileItem[len - 1].addActionListener(this);
                    AppMenu.this.fileItem = newFileItem;
                    try {
                        ConfigFile.getConfigFile().storeRecentFiles("dm", AppMenu.this.fileItem);
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                    try {
                        AppMenu.access$1(AppMenu.this, menu, this);
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        try {
            this.loadRecentFiles(menu, actionNew);
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
        }
        return menu;
    }

    private void loadRecentFiles(JMenu menu, Action actionNew) throws Throwable {
        menu.removeAll();
        ConfigFile.getConfigFile().loadRecentFiles("dm", this.fileItem);
        int i = 0;
        while (i < 20) {
            this.fileItem[i].addActionListener(actionNew);
            if (this.fileItem[i].isVisible()) {
                menu.add(this.fileItem[i]);
            }
            ++i;
        }
    }

    public void refreshRecentMainPath(String fileName) throws Throwable {
        String tempFileName;
        if (!StringUtils.isValidString(fileName)) {
            return;
        }
        int point = 19;
        int i = 0;
        while (i < this.mainPathItem.length) {
            tempFileName = this.mainPathItem[i].getText();
            if (fileName.equals(tempFileName)) {
                point = i;
                break;
            }
            ++i;
        }
        i = point;
        while (i > 0) {
            tempFileName = this.mainPathItem[i - 1].getText();
            this.mainPathItem[i].setText(tempFileName);
            this.mainPathItem[i].setVisible(!tempFileName.equals(""));
            --i;
        }
        this.mainPathItem[0].setText(fileName);
        this.mainPathItem[0].setVisible(false);
        ConfigFile.getConfigFile().storeRecentMainPaths("dm", this.mainPathItem);
    }

    public JMenu getRecentMainPaths() {
        final JMenu menu = this.getCommonMenuItem("file.recentmainpaths", 'M', false);
        AbstractAction actionNew = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File f;
                JMenuItem tt;
                block17: {
                    tt = (JMenuItem)e.getSource();
                    try {
                        String sdir;
                        if (MAINPATH_OTHER.equals(tt.getText())) {
                            String sdir2 = GM.dialogSelectDirectory(GV.appFrame, GV.lastDirectory);
                            if (sdir2 == null) {
                                return;
                            }
                            ConfigOptions.sMainPath = sdir2;
                            GV.config.setMainPath(sdir2);
                            ConfigOptions.applyOptions();
                            ConfigUtilIde.writeActiveConfig();
                            AppMenu.this.refreshRecentMainPath(sdir2);
                            if (GVSpl.fileTree != null) {
                                GVSpl.fileTree.changeMainPath(sdir2);
                            }
                            GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("prjxappmenu.setmainpath", sdir2));
                            break block17;
                        }
                        f = new File(tt.getText());
                        if (!f.exists() || !f.isDirectory()) {
                            GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("prjxappmenu.nomainpath", tt.getText()));
                            break block17;
                        }
                        ConfigOptions.sMainPath = sdir = tt.getText();
                        GV.config.setMainPath(sdir);
                        ConfigOptions.applyOptions();
                        if (GVSpl.fileTree != null) {
                            GVSpl.fileTree.changeMainPath(sdir);
                        }
                        ConfigUtilIde.writeConfig();
                        AppMenu.this.refreshRecentMainPath(sdir);
                        GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("prjxappmenu.setmainpath", sdir));
                        return;
                    }
                    catch (Throwable t) {
                        GM.showException(GV.appFrame, t);
                    }
                }
                if (StringUtils.isValidString(tt.getText()) && !(f = new File(tt.getText())).exists() && AppMenu.this.mainPathItem != null) {
                    int len = AppMenu.this.mainPathItem.length;
                    int index = -1;
                    int i = 0;
                    while (i < len) {
                        if (tt.getText().equalsIgnoreCase(AppMenu.this.mainPathItem[i].getText())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        return;
                    }
                    JMenuItem[] newFileItem = new JMenuItem[20];
                    if (index > 0) {
                        System.arraycopy(AppMenu.this.mainPathItem, 0, newFileItem, 0, index);
                    }
                    if (index < len - 1) {
                        System.arraycopy(AppMenu.this.mainPathItem, index + 1, newFileItem, index, len - index - 1);
                    }
                    newFileItem[len - 1] = new JMenuItem("");
                    newFileItem[len - 1].setVisible(false);
                    newFileItem[len - 1].addActionListener(this);
                    AppMenu.this.mainPathItem = newFileItem;
                    try {
                        ConfigFile.getConfigFile().storeRecentMainPaths("dm", AppMenu.this.mainPathItem);
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                    try {
                        AppMenu.this.loadRecentMainPaths(menu, this);
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        try {
            this.loadRecentMainPaths(menu, actionNew);
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
        }
        return menu;
    }

    private void loadRecentMainPaths(JMenu menu, Action actionNew) throws Throwable {
        menu.removeAll();
        boolean hasVisible = ConfigFile.getConfigFile().loadRecentMainPaths("dm", this.mainPathItem);
        int i = 0;
        while (i < 20) {
            this.mainPathItem[i].addActionListener(actionNew);
            menu.add(this.mainPathItem[i]);
            ++i;
        }
        if (hasVisible) {
            menu.addSeparator();
        }
        JMenuItem other = new JMenuItem(MAINPATH_OTHER);
        other.addActionListener(actionNew);
        menu.add(other);
    }

    public void refreshRecentConfigFile(String fileName) throws Throwable {
        String tempFileName;
        if (!StringUtils.isValidString(fileName)) {
            return;
        }
        int point = 19;
        int i = 0;
        while (i < this.configFileItem.length) {
            tempFileName = this.configFileItem[i].getText();
            if (fileName.equals(tempFileName)) {
                point = i;
                break;
            }
            ++i;
        }
        i = point;
        while (i > 0) {
            tempFileName = this.configFileItem[i - 1].getText();
            this.configFileItem[i].setText(tempFileName);
            this.configFileItem[i].setVisible(!tempFileName.equals(""));
            --i;
        }
        this.configFileItem[0].setText(fileName);
        this.configFileItem[0].setVisible(false);
        ConfigFile.getConfigFile().storeRecentConfigFiles("dm", this.configFileItem);
    }

    public JMenu getRecentConfigFiles() {
        final JMenu menu = this.getCommonMenuItem("file.recentconfigfiles", 'G', false);
        AbstractAction actionNew = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File f;
                JMenuItem tt;
                block15: {
                    tt = (JMenuItem)e.getSource();
                    try {
                        if (CONFIGFILE_OTHER.equals(tt.getText())) {
                            f = GM.dialogSelectFile(GV.appFrame, "xml");
                            if (f == null) {
                                return;
                            }
                            String path = f.getAbsolutePath();
                            GM.switchConfigFile(path);
                            AppMenu.this.refreshRecentConfigFile(path);
                            GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("appmenu.setconfigfile", path));
                            break block15;
                        }
                        f = new File(GM.getAbsolutePath(tt.getText()));
                        if (!f.exists() || !f.isFile()) {
                            GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("appmenu.noconfigfile", tt.getText()));
                            break block15;
                        }
                        String path = tt.getText();
                        GM.switchConfigFile(path);
                        AppMenu.this.refreshRecentConfigFile(path);
                        GM.messageDialog(GV.appFrame, IdeCommonMessage.get().getMessage("appmenu.setconfigfile", path));
                        return;
                    }
                    catch (Throwable t) {
                        GM.showException(GV.appFrame, t);
                    }
                }
                if (StringUtils.isValidString(tt.getText()) && !(f = new File(tt.getText())).exists() && AppMenu.this.configFileItem != null) {
                    int len = AppMenu.this.configFileItem.length;
                    int index = -1;
                    int i = 0;
                    while (i < len) {
                        if (tt.getText().equalsIgnoreCase(AppMenu.this.configFileItem[i].getText())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        return;
                    }
                    JMenuItem[] newFileItem = new JMenuItem[20];
                    if (index > 0) {
                        System.arraycopy(AppMenu.this.configFileItem, 0, newFileItem, 0, index);
                    }
                    if (index < len - 1) {
                        System.arraycopy(AppMenu.this.configFileItem, index + 1, newFileItem, index, len - index - 1);
                    }
                    newFileItem[len - 1] = new JMenuItem("");
                    newFileItem[len - 1].setVisible(false);
                    newFileItem[len - 1].addActionListener(this);
                    AppMenu.this.configFileItem = newFileItem;
                    try {
                        ConfigFile.getConfigFile().storeRecentConfigFiles("dm", AppMenu.this.configFileItem);
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                    try {
                        AppMenu.this.loadRecentConfigFiles(menu, this);
                    }
                    catch (Throwable e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        try {
            this.loadRecentConfigFiles(menu, actionNew);
        }
        catch (Throwable e) {
            GM.showException(GV.appFrame, e);
        }
        return menu;
    }

    private void loadRecentConfigFiles(JMenu menu, Action actionNew) throws Throwable {
        menu.removeAll();
        boolean hasVisible = ConfigFile.getConfigFile().loadRecentConfigFiles("dm", this.configFileItem);
        int i = 0;
        while (i < 20) {
            this.configFileItem[i].addActionListener(actionNew);
            menu.add(this.configFileItem[i]);
            ++i;
        }
        if (hasVisible) {
            menu.addSeparator();
        }
        JMenuItem other = new JMenuItem(CONFIGFILE_OTHER);
        other.addActionListener(actionNew);
        menu.add(other);
    }

    public void enableSave(boolean enable) {
        JMenuItem mi = menuItems.get((short)50);
        mi.setEnabled(enable);
    }

    public void executeCmd(short cmdId) {
        try {
            GMSpl.executeCmd(cmdId);
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
        }
    }

    protected JMenu getSplMenuItem(String menuId, char mneKey, boolean isMain) {
        return GM.getMenuItem(this.mmSpl.getMessage("menu." + menuId), mneKey, isMain);
    }

    protected JMenuItem newSplMenuItem(short cmdId, String menuId, char mneKey, int mask) {
        return this.newSplMenuItem(cmdId, menuId, mneKey, mask, false);
    }

    protected JMenuItem newSplMenuItem(short cmdId, String menuId, char mneKey, int mask, boolean hasIcon) {
        String menuText = menuId;
        if (menuText.indexOf(46) > 0) {
            menuText = this.mmSpl.getMessage("menu." + menuId);
        }
        return this.newMenuItem(cmdId, menuId, mneKey, mask, hasIcon, menuText);
    }

    protected JMenuItem newMenuItem(short cmdId, String menuId, char mneKey, int mask, boolean hasIcon, String menuText) {
        JMenuItem mItem = GM.getMenuItem(cmdId, menuId, mneKey, mask, hasIcon, menuText);
        mItem.addActionListener(this.menuAction);
        menuItems.put(cmdId, mItem);
        return mItem;
    }

    public JMenuItem cloneMenuItem(short cmdId) {
        return this.cloneMenuItem(cmdId, null);
    }

    public JMenuItem cloneMenuItem(short cmdId, ActionListener listener) {
        JMenuItem mItem = new JMenuItem();
        JMenuItem jmi = menuItems.get(cmdId);
        String text = jmi.getText();
        int pos = text.indexOf("(");
        if (pos > 0) {
            text = text.substring(0, pos);
        }
        mItem.setText(text);
        mItem.setName(jmi.getName());
        mItem.setIcon(jmi.getIcon());
        mItem.setVisible(jmi.isVisible());
        mItem.setEnabled(jmi.isEnabled());
        mItem.setAccelerator(jmi.getAccelerator());
        if (listener == null) {
            mItem.addActionListener(jmi.getActionListeners()[0]);
        } else {
            mItem.addActionListener(listener);
        }
        return mItem;
    }

    protected JMenuItem newCommonMenuItem(short cmdId, String menuId, char mneKey, int mask) {
        return this.newCommonMenuItem(cmdId, menuId, mneKey, mask, false);
    }

    protected JMenuItem newCommonMenuItem(short cmdId, String menuId, char mneKey, int mask, boolean hasIcon) {
        JMenuItem mItem = GM.getMenuItem(cmdId, menuId, mneKey, mask, hasIcon, this.mm.getMessage("menu." + menuId));
        mItem.addActionListener(this.menuAction);
        menuItems.put(cmdId, mItem);
        return mItem;
    }

    public void setMenuEnabled(short cmdId, boolean enabled) {
        JMenuItem mi = menuItems.get(cmdId);
        if (mi != null) {
            mi.setEnabled(enabled);
        }
    }

    public boolean isMenuEnabled(short cmdId) {
        JMenuItem mi = menuItems.get(cmdId);
        if (mi != null) {
            return mi.isEnabled();
        }
        return false;
    }

    public void setMenuEnabled(IntArrayList cmdIds, boolean enabled) {
        if (cmdIds == null) {
            return;
        }
        int i = 0;
        while (i < cmdIds.size()) {
            short cmdId = (short)cmdIds.getInt(i);
            this.setMenuEnabled(cmdId, enabled);
            ++i;
        }
    }

    public void setMenuEnabled(short[] cmdIds, boolean enabled) {
        if (cmdIds == null) {
            return;
        }
        int i = 0;
        while (i < cmdIds.length) {
            short cmdId = cmdIds[i];
            this.setMenuEnabled(cmdId, enabled);
            ++i;
        }
    }

    public void setMenuVisible(short cmdId, boolean visible) {
        JMenuItem mi = menuItems.get(cmdId);
        if (mi != null) {
            mi.setVisible(visible);
        }
    }

    public void setMenuVisible(IntArrayList cmdIds, boolean visible) {
        if (cmdIds == null) {
            return;
        }
        int i = 0;
        while (i < cmdIds.size()) {
            short cmdId = (short)cmdIds.getInt(i);
            this.setMenuVisible(cmdId, visible);
            ++i;
        }
    }

    public abstract short[] getMenuItems();

    protected List<Object> buildMenuFromConfig() {
        return this.buildMenuFromConfig("menuconfig");
    }

    protected List<Object> buildMenuFromConfig(String fileName) {
        ArrayList<Object> helpMenus = new ArrayList<Object>();
        try {
            Document doc = null;
            File configFile = new File(GM.getAbsolutePath("config"), String.valueOf(fileName) + GM.getLanguageSuffix() + "." + "xml");
            doc = this.buildDocument(configFile.getAbsolutePath());
            Element root = doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node el = list.item(i);
                if (el.getNodeName().equalsIgnoreCase("help")) {
                    NodeList helpList = el.getChildNodes();
                    int j = 0;
                    while (j < helpList.getLength()) {
                        el = helpList.item(j);
                        if (el.getNodeName().equalsIgnoreCase("menu")) {
                            helpMenus.add(this.buildMenu(el));
                        } else if (el.getNodeName().equalsIgnoreCase("menuitem")) {
                            helpMenus.add(this.getNewItem(el));
                        } else if (el.getNodeName().equalsIgnoreCase("separator")) {
                            helpMenus.add(new JSeparator());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            GM.writeLog(ex);
        }
        return helpMenus;
    }

    private Document buildDocument(String filename) throws Exception {
        Document doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        doc = docBuilder.parse(new File(filename));
        return doc;
    }

    private JMenu buildMenu(Node rootEl) {
        NodeList list = rootEl.getChildNodes();
        NamedNodeMap tmp = rootEl.getAttributes();
        JMenu menu = new JMenu(tmp.getNamedItem("text").getNodeValue());
        menu.setName(tmp.getNamedItem("name").getNodeValue());
        String hk = tmp.getNamedItem("hotKey").getNodeValue();
        if (hk != null && !hk.trim().equals("")) {
            menu.setMnemonic(hk.charAt(0));
        }
        int i = 0;
        while (i < list.getLength()) {
            Node el = list.item(i);
            if (el.getNodeName().equalsIgnoreCase("Separator")) {
                menu.addSeparator();
            } else if (el.getNodeName().equalsIgnoreCase("menuitem")) {
                try {
                    menu.add(this.getNewItem(el));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return menu;
    }

    private JMenuItem getNewItem(Node el) throws Exception {
        NodeList list = el.getChildNodes();
        NamedNodeMap tmp = el.getAttributes();
        String a = tmp.getNamedItem("text").getNodeValue();
        String classname = AppMenu.getChild(list, "commonderClass").getNodeValue();
        Node argNode = AppMenu.getChild(list, "commonderArgs");
        String pathname = argNode == null ? null : argNode.getNodeValue();
        JMenuItem jmenuitem = new JMenuItem(a);
        ConfigMenuAction cma = (ConfigMenuAction)Class.forName(classname).newInstance();
        cma.setConfigArgument(pathname);
        jmenuitem.addActionListener(cma);
        String hk = tmp.getNamedItem("hotKey").getNodeValue();
        if (hk != null && !"".equals(hk)) {
            jmenuitem.setMnemonic(hk.charAt(0));
        }
        return jmenuitem;
    }

    private static Node getChild(NodeList list, String key) {
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node != null && node.getNodeName().equals(key)) {
                return node.getChildNodes().item(0);
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ void access$1(AppMenu appMenu, JMenu jMenu, Action action) throws Throwable {
        appMenu.loadRecentFiles(jMenu, action);
    }
}

