/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.ToolbarGradient;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;

public abstract class AppToolBar
extends ToolbarGradient {
    private static final long serialVersionUID = 1L;
    public static HashMap<Short, AbstractButton> buttonHolder = new HashMap();
    protected MessageManager mm = IdeCommonMessage.get();
    public Dimension seperator = new Dimension(6, 2);
    protected ActionListener actionNormal = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String menuId = "";
            try {
                menuId = e.getActionCommand();
                short cmdId = Short.parseShort(menuId);
                AppToolBar.this.executeCmd(cmdId);
            }
            catch (Exception ex) {
                GM.showException(GV.appFrame, ex);
            }
        }
    };

    public AppToolBar() {
        this(IdeCommonMessage.get().getMessage("public.toolbar"));
    }

    public AppToolBar(String name) {
        super(name);
        this.setFloatable(false);
        this.setToolTipText(this.mm.getMessage("public.toolbar"));
    }

    public abstract void setBarEnabled(boolean var1);

    public abstract void executeCmd(short var1);

    public JButton getCommonButton(short cmdId, String menuId) {
        JButton b = this.getButton(cmdId, menuId, this.mm.getMessage("menu." + menuId), this.actionNormal);
        buttonHolder.put(cmdId, b);
        b.setFocusable(false);
        return b;
    }

    public void setButtonEnabled(short cmdId, boolean enabled) {
        this.setButtonsEnabled(new short[]{cmdId}, enabled);
    }

    public void setButtonsEnabled(short[] cmdIds, boolean enabled) {
        int i = 0;
        while (i < cmdIds.length) {
            AbstractButton b = buttonHolder.get(cmdIds[i]);
            if (b != null) {
                b.setEnabled(enabled);
            }
            ++i;
        }
    }

    public void setButtonVisible(short cmdId, boolean visible) {
        this.setButtonsVisible(new short[]{cmdId}, visible);
    }

    public void setButtonsVisible(short[] cmdIds, boolean visible) {
        int i = 0;
        while (i < cmdIds.length) {
            buttonHolder.get(cmdIds[i]).setVisible(visible);
            ++i;
        }
    }

    public void enableSave(boolean enable) {
        AbstractButton saveButton = buttonHolder.get((short)50);
        if (saveButton != null) {
            saveButton.setEnabled(enable);
        }
    }
}

