/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.common.Section;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.FTPInfo;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class ConfigFile {
    public static String LOCAL_PARAM = "LOCAL_PARAM";
    public static String NODE_OPTIONS = "OPTIONS";
    public static String NODE_DIMENSION = "WINDOW_DIMENSION";
    public static String NODE_CUSTOMGRAPH = "CUSTOM_GRAPH";
    public static String NODE_FORMAT = "COL_FORMAT";
    public static String NODE_COL_WIDHT = "COL_WIDTH";
    public static String NODE_BREAKPOINTS = "DFX_BREAKS";
    public static String NODE_RAQSOFT = "RAQSOFT";
    public static final String PATH_DATASOURCE = String.valueOf(NODE_RAQSOFT) + "/DATASOURCE";
    public static final String PATH_DATASETTYPE = String.valueOf(NODE_RAQSOFT) + "/DATASETTYPE";
    public static final String APP_DM = "dm";
    private static final String NODE_RECENT_FILES = "RECENTFILES";
    private static final String NODE_RECENT_MAINPATHS = "RECENTMAINPATHS";
    private static final String NODE_RECENT_CONFIGFILES = "RECENTCONFIGFILES";
    private XMLFile configFile = null;
    private String configNode = "CONFIG";
    private static ConfigFile cf = null;
    private static String FILE_PATH = null;

    private ConfigFile(XMLFile file) {
        this.configFile = file;
    }

    public XMLFile xmlFile() {
        return this.configFile;
    }

    public static void setFileName(String absoluteFileName) {
        FILE_PATH = absoluteFileName;
        cf = null;
    }

    public static String getFilePath() {
        if (StringUtils.isValidString(FILE_PATH)) {
            return FILE_PATH;
        }
        return GM.getAbsolutePath("config/userconfig.xml");
    }

    public static ConfigFile getSystemConfigFile() {
        String file = "config/systemconfig" + GM.getLanguageSuffix() + "." + "xml";
        String filePath = GM.getAbsolutePath(file);
        try {
            File f = new File(filePath);
            if (f.exists()) {
                return new ConfigFile(new XMLFile(filePath));
            }
        }
        catch (Throwable x) {
            GM.writeLog(x);
            InputStream is = XMLFile.class.getResourceAsStream(file);
            try {
                if (is != null) {
                    return new ConfigFile(new XMLFile(is));
                }
            }
            catch (Throwable t) {
                GM.writeLog(t);
            }
        }
        return null;
    }

    private static ConfigFile newInstance(String fileName) throws Throwable {
        XMLFile file = XMLFile.newXML(fileName, NODE_RAQSOFT);
        file.newElement(NODE_RAQSOFT, "DATASOURCE");
        file.newElement(NODE_RAQSOFT, "PARAM");
        file.newElement(NODE_RAQSOFT, "FUNCTIONS");
        file.newElement(String.valueOf(NODE_RAQSOFT) + "//FUNCTIONS", "DataSet");
        file.newElement(String.valueOf(NODE_RAQSOFT) + "//FUNCTIONS", "Normal");
        file.save();
        return new ConfigFile(file);
    }

    public void loadRecentFiles(String appName, JMenuItem[] items) {
        int i = 0;
        while (i < 20) {
            String sTmp = "f" + i;
            String name = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/" + NODE_RECENT_FILES + "/" + sTmp);
            items[i] = new JMenuItem(name);
            if (name.equals("")) {
                items[i].setVisible(false);
            }
            ++i;
        }
    }

    public void storeRecentFiles(String appName, JMenuItem[] items) {
        try {
            String path = String.valueOf(NODE_RAQSOFT) + "/" + appName;
            if (!this.configFile.isPathExists(path)) {
                this.configFile.newElement(NODE_RAQSOFT, appName);
            }
            if (!this.configFile.isPathExists(path = String.valueOf(path) + "/RECENTFILES")) {
                this.configFile.newElement(String.valueOf(NODE_RAQSOFT) + "/" + appName, NODE_RECENT_FILES);
            }
            int i = 0;
            while (i < 20) {
                String sTmp = "f" + i;
                this.configFile.setAttribute(String.valueOf(path) + "/" + sTmp, items[i].getText());
                ++i;
            }
            this.configFile.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<String> getRecentMainPaths(String appName) {
        ArrayList<String> mainPaths = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            String sTmp = "m" + i;
            String name = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/" + NODE_RECENT_MAINPATHS + "/" + sTmp);
            if (StringUtils.isValidString(name)) {
                mainPaths.add(name);
            }
            ++i;
        }
        return mainPaths;
    }

    public List<String> getRecentConfigFiles(String appName) {
        ArrayList<String> configFiles = new ArrayList<String>();
        int i = 0;
        while (i < 20) {
            String sTmp = "m" + i;
            String name = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/" + NODE_RECENT_CONFIGFILES + "/" + sTmp);
            if (StringUtils.isValidString(name)) {
                configFiles.add(name);
            }
            ++i;
        }
        return configFiles;
    }

    public boolean loadRecentMainPaths(String appName, JMenuItem[] items) {
        boolean hasVisible = false;
        int i = 0;
        while (i < 20) {
            String sTmp = "m" + i;
            String name = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/" + NODE_RECENT_MAINPATHS + "/" + sTmp);
            items[i] = new JMenuItem(name);
            if (!StringUtils.isValidString(name)) {
                items[i].setVisible(false);
            } else if (name.equals(GV.config.getMainPath())) {
                items[i].setVisible(false);
            } else {
                hasVisible = true;
            }
            ++i;
        }
        return hasVisible;
    }

    public void storeRecentMainPaths(String appName, JMenuItem[] items) {
        try {
            String path = String.valueOf(NODE_RAQSOFT) + "/" + appName;
            if (!this.configFile.isPathExists(path)) {
                this.configFile.newElement(NODE_RAQSOFT, appName);
            }
            if (!this.configFile.isPathExists(path = String.valueOf(path) + "/RECENTMAINPATHS")) {
                this.configFile.newElement(String.valueOf(NODE_RAQSOFT) + "/" + appName, NODE_RECENT_MAINPATHS);
            }
            int i = 0;
            while (i < 20) {
                String sTmp = "m" + i;
                this.configFile.setAttribute(String.valueOf(path) + "/" + sTmp, items[i].getText());
                ++i;
            }
            this.configFile.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean loadRecentConfigFiles(String appName, JMenuItem[] items) {
        boolean hasVisible = false;
        int i = 0;
        while (i < 20) {
            String sTmp = "m" + i;
            String name = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/" + NODE_RECENT_CONFIGFILES + "/" + sTmp);
            items[i] = new JMenuItem(name);
            if (!StringUtils.isValidString(name)) {
                items[i].setVisible(false);
            } else if (name.equals(ConfigOptions.sConfigFile)) {
                items[i].setVisible(false);
            } else {
                hasVisible = true;
            }
            ++i;
        }
        return hasVisible;
    }

    public void storeRecentConfigFiles(String appName, JMenuItem[] items) {
        try {
            String path = String.valueOf(NODE_RAQSOFT) + "/" + appName;
            if (!this.configFile.isPathExists(path)) {
                this.configFile.newElement(NODE_RAQSOFT, appName);
            }
            if (!this.configFile.isPathExists(path = String.valueOf(path) + "/RECENTCONFIGFILES")) {
                this.configFile.newElement(String.valueOf(NODE_RAQSOFT) + "/" + appName, NODE_RECENT_CONFIGFILES);
            }
            int i = 0;
            while (i < 20) {
                String sTmp = "m" + i;
                this.configFile.setAttribute(String.valueOf(path) + "/" + sTmp, items[i].getText());
                ++i;
            }
            this.configFile.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FTPInfo[] loadFTP(String appName) throws Exception {
        Section ftps = this.configFile.listElement("RAQSOFT/" + appName + "/FTP");
        if (ftps == null || ftps.size() == 0) {
            return null;
        }
        FTPInfo[] ftpInfos = new FTPInfo[ftps.size()];
        int i = 0;
        while (i < ftpInfos.length) {
            ftpInfos[i] = new FTPInfo();
            String host = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/FTP/" + ftps.getSection(i) + "/HOST");
            ftpInfos[i].setHost(host);
            String port = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/FTP/" + ftps.getSection(i) + "/PORT");
            if (StringUtils.isValidString(port)) {
                try {
                    ftpInfos[i].setPort(Integer.parseInt(port));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String user = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/FTP/" + ftps.getSection(i) + "/USER");
            ftpInfos[i].setUser(user);
            String password = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/FTP/" + ftps.getSection(i) + "/PASSWORD");
            ftpInfos[i].setPassword(password);
            String directory = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/FTP/" + ftps.getSection(i) + "/DIRECTORY");
            ftpInfos[i].setDirectory(directory);
            String selected = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/" + appName + "/FTP/" + ftps.getSection(i) + "/SELECTED");
            try {
                ftpInfos[i].setSelected(Boolean.valueOf(selected));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return ftpInfos;
    }

    public void storeFTP(String appName, FTPInfo[] ftpInfos) {
        if (ftpInfos == null || ftpInfos.length == 0) {
            return;
        }
        try {
            String path = String.valueOf(NODE_RAQSOFT) + "/" + appName;
            if (!this.configFile.isPathExists(path)) {
                this.configFile.newElement("RAQSOFT", appName);
            }
            if (this.configFile.isPathExists(path = String.valueOf(path) + "/FTP")) {
                this.configFile.deleteElement(path);
            }
            this.configFile.newElement(String.valueOf(NODE_RAQSOFT) + "/" + appName, "FTP");
            int i = 0;
            while (i < ftpInfos.length) {
                String nodeName = "ftp" + i;
                this.configFile.newElement(path, nodeName);
                this.configFile.setAttribute(String.valueOf(path) + "/" + nodeName + "/HOST", ftpInfos[i].getHost());
                this.configFile.setAttribute(String.valueOf(path) + "/" + nodeName + "/PORT", String.valueOf(ftpInfos[i].getPort()));
                this.configFile.setAttribute(String.valueOf(path) + "/" + nodeName + "/USER", ftpInfos[i].getUser());
                this.configFile.setAttribute(String.valueOf(path) + "/" + nodeName + "/PASSWORD", ftpInfos[i].getPassword());
                this.configFile.setAttribute(String.valueOf(path) + "/" + nodeName + "/DIRECTORY", ftpInfos[i].getDirectory());
                this.configFile.setAttribute(String.valueOf(path) + "/" + nodeName + "/SELECTED", new Boolean(ftpInfos[i].isSelected()).toString());
                ++i;
            }
            this.configFile.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadRecentConnection(JMenuItem[] items) {
        int i = 0;
        while (i < 20) {
            String sTmp = "c" + i;
            String name = this.configFile.getAttribute(String.valueOf(NODE_RAQSOFT) + "/RECENTCONNECTIONS/" + sTmp);
            items[i] = new JMenuItem(name);
            if (name.equals("")) {
                items[i].setVisible(false);
            }
            ++i;
        }
    }

    public void storeRecentConnections(JMenuItem[] items) {
        try {
            String path = String.valueOf(NODE_RAQSOFT) + "/RECENTCONNECTIONS";
            if (!this.configFile.isPathExists(path)) {
                this.configFile.newElement(NODE_RAQSOFT, "RECENTCONNECTIONS");
            }
            int i = 0;
            while (i < 20) {
                String sTmp = "c" + i;
                this.configFile.setAttribute(String.valueOf(path) + "/" + sTmp, items[i].getText());
                ++i;
            }
            this.configFile.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadDataSource(DataSourceListModel list, byte dsFrom) throws Exception {
        Section ss = new Section();
        ss = this.configFile.listElement(PATH_DATASOURCE);
        int i = 0;
        while (i < ss.size()) {
            String sId = ss.getSection(i);
            String name = this.configFile.getAttribute(String.valueOf(PATH_DATASOURCE) + "/" + sId + "/name");
            if (list.existDSName(name)) {
                Logger.debug("Notice: datasource[ " + name + " ] exist, ignore.");
            } else {
                String config = this.configFile.getAttribute(String.valueOf(PATH_DATASOURCE) + "/" + sId + "/config");
                DataSource ds = new DataSource(config);
                ds.setName(name);
                ds.setDSFrom(dsFrom);
                list.addElement(ds);
            }
            ++i;
        }
    }

    public void storeDataSource(DataSourceListModel list) throws Throwable {
        GM.resetEnvDataSource(GV.dsModel);
        this.configFile.deleteElement(PATH_DATASOURCE);
        this.configFile.newElement(NODE_RAQSOFT, "DATASOURCE");
        int i = 0;
        while (i < list.getSize()) {
            DataSource ds = (DataSource)list.get(i);
            if (ds.isLocal()) {
                String sId = "ds" + i;
                this.configFile.newElement(PATH_DATASOURCE, sId);
                this.configFile.setAttribute(String.valueOf(PATH_DATASOURCE) + "/" + sId + "/name", ds.getName());
                this.configFile.setAttribute(String.valueOf(PATH_DATASOURCE) + "/" + sId + "/config", ds.toString());
            }
            ++i;
        }
        this.configFile.save();
    }

    public static ConfigFile getConfigFile() throws Throwable {
        XMLFile file;
        block9: {
            String renameMessage;
            String filePath;
            if (cf != null) {
                return cf;
            }
            file = null;
            String fp = ConfigFile.getFilePath();
            File f = new File(fp);
            try {
                if (f.isFile()) {
                    file = new XMLFile(fp);
                    if (!file.isPathExists(NODE_RAQSOFT)) {
                        cf = ConfigFile.newInstance(fp);
                        return cf;
                    }
                    break block9;
                }
                cf = ConfigFile.newInstance(fp);
                return cf;
            }
            catch (Throwable err) {
                filePath = fp;
                renameMessage = "";
                try {
                    String name = f.getName();
                    if (name.toLowerCase().endsWith(".xml")) {
                        name = name.substring(0, name.length() - 4);
                    }
                    File bakFile = new File(f.getParentFile(), String.valueOf(name) + "_bak.xml");
                    int index = 1;
                    while (bakFile.exists()) {
                        bakFile = new File(f.getParentFile(), String.valueOf(name) + "_bak" + index + ".xml");
                        ++index;
                    }
                    f.renameTo(bakFile);
                    renameMessage = IdeCommonMessage.get().getMessage("configfile.renamefile", bakFile.getName(), f.getName());
                }
                catch (Exception name) {
                    // empty catch block
                }
            }
            String errorMessage = err == null ? "" : err.getMessage();
            GM.showException(GV.appFrame, IdeCommonMessage.get().getMessage("configfile.damagedfile", filePath, String.valueOf(errorMessage) + "\n" + renameMessage));
            cf = ConfigFile.newInstance(fp);
            return cf;
        }
        cf = new ConfigFile(file);
        return cf;
    }

    public XMLFile getXMLFile() {
        return this.configFile;
    }

    public void setConfigNode(String node) {
        this.configNode = node.toUpperCase();
    }

    public void resetDefaultConfigNode() {
        this.configNode = "CONFIG";
        cf = null;
    }

    public String getConfigNode() {
        return this.configNode;
    }

    public void setAttrValue(String attr, Object val) {
        if (val == null) {
            return;
        }
        try {
            if (!this.configFile.isPathExists(String.valueOf(NODE_RAQSOFT) + "/" + this.configNode)) {
                this.configFile.newElement(NODE_RAQSOFT, this.configNode);
            }
            this.configFile.setAttribute(String.valueOf(NODE_RAQSOFT) + "/" + this.configNode + "/" + attr, val.toString());
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void backup() {
        String filePath = ConfigFile.getFilePath();
        File f = new File(filePath);
        File fb = new File(String.valueOf(filePath) + ".bak");
        fb.delete();
        f.renameTo(fb);
    }

    public void save() throws Exception {
        this.configFile.save();
    }

    public String getAttrValue(String attr) {
        String value = "";
        try {
            value = this.configFile.getAttribute("RAQSOFT/" + this.configNode + "/" + attr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }
}

