/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.config.ConfigUtil;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.dm.cursor.ICursor;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class ConfigOptions {
    protected static ConfigFile cf = null;
    protected static HashMap<String, Object> options = new HashMap();
    public static Boolean bIdeConsole = Boolean.TRUE;
    public static Boolean bAutoOpen = Boolean.FALSE;
    public static Boolean bAutoBackup = Boolean.TRUE;
    public static Boolean bAutoConnect = Boolean.FALSE;
    public static Boolean bWindowSize = Boolean.FALSE;
    public static Boolean bViewWinList = Boolean.TRUE;
    public static Boolean bUseUndo = Boolean.TRUE;
    public static Boolean bAutoTrimChar0 = Boolean.TRUE;
    public static Boolean bAdjustNoteCell = Boolean.TRUE;
    public static Byte iLookAndFeel = new Byte(1);
    public static Integer iConnectTimeout = new Integer(10);
    public static Boolean bAutoSave = Boolean.FALSE;
    public static Integer iAutoSaveMinutes = new Integer(10);
    public static String sBackupDirectory = "backup";
    public static String sAutoOpenFileNames = null;
    public static Integer iParallelNum = new Integer(1);
    public static Integer iCursorParallelNum = new Integer(1);
    public static Boolean bAutoCleanOutput = Boolean.FALSE;
    public static Boolean bDispOutCell = Boolean.TRUE;
    public static Boolean bAutoSizeRowHeight = Boolean.FALSE;
    public static Boolean bMultiLineExpEditor = Boolean.TRUE;
    public static Boolean bStepLastLocation = Boolean.FALSE;
    public static Boolean bFileTreeDemo = Boolean.TRUE;
    public static Boolean bNoticeExpiration = Boolean.TRUE;
    public static String sConfigFile = "config/raqsoftConfig.xml";
    public static String sLogFileName = null;
    public static String sPaths = null;
    public static String sMainPath = null;
    public static String sTempPath = "temp";
    public static String sExtLibsPath = null;
    public static String sInitSpl = null;
    public static String sCustomFunctionFile = null;
    public static String sSlimerjsDirectory = null;
    public static String sDateFormat = Env.getDateFormat();
    public static String sTimeFormat = Env.getTimeFormat();
    public static String sDateTimeFormat = Env.getDateTimeFormat();
    public static String sDefCharsetName = Env.getDefaultCharsetName();
    public static String sFileBuffer = String.valueOf(Env.FILE_BUFSIZE);
    public static String sBlockSize = String.valueOf(Env.BLOCK_SIZE);
    public static String sNullStrings = null;
    public static Integer iFetchCount = new Integer(ICursor.FETCHCOUNT);
    public static Boolean bAutoShowTip = Boolean.TRUE;
    public static Integer iAutoShowTip = new Integer(0);
    public static Boolean bShowHttpConfig = Boolean.TRUE;
    public static Boolean bSNPrompt = Boolean.TRUE;
    public static Integer iRowCount = new Integer(20);
    public static Integer iColCount = new Integer(5);
    public static Float fRowHeight = new Float(25.0f);
    public static Float fColWidth = new Float(150.0f);
    public static Color iConstFColor = Color.MAGENTA;
    public static Color iConstBColor = Color.white;
    public static Color iNoteFColor = new Color(51, 153, 0);
    public static Color iNoteBColor = Color.white;
    public static Color iCellNoteFColor = Color.GRAY;
    public static Color iCellNoteBColor = Color.white;
    public static Color iValueFColor = Color.black;
    public static Color iValueBColor = new Color(255, 255, 153);
    public static Color iNValueFColor = Color.black;
    public static Color iNValueBColor = Color.white;
    public static Color iBreakPointBColor = Color.MAGENTA;
    public static String sFontName = "Dialog";
    public static Short iFontSize = new Short(12);
    public static Boolean bBold = Boolean.FALSE;
    public static Boolean bItalic = Boolean.FALSE;
    public static Boolean bUnderline = Boolean.FALSE;
    public static Boolean bGridline = Boolean.TRUE;
    public static Byte iHAlign = new Byte(0);
    public static Byte iVAlign = new Byte(8);
    public static Integer iIndent = new Integer(3);
    public static Integer iSequenceDispMembers = new Integer(3);
    public static Boolean bShowDBStruct = Boolean.TRUE;
    public static Integer iDBRecordCount = new Integer(-1);
    public static Byte iLocale = null;
    public static Integer iConsoleLocation = new Integer(-1);
    public static Integer iGridLocation = new Integer(-1);
    public static Integer iFileLocation = new Integer(-1);
    public static String sFileTip = null;
    public static Color COLOR_DECIMAL = Color.RED;
    public static Color COLOR_INTEGER = Color.BLUE;
    public static Color COLOR_DOUBLE = Color.PINK.darker();
    public static Color COLOR_REF = Color.CYAN.darker();
    public static Color COLOR_NULL = Color.MAGENTA;
    public static String fileColor;
    public static String fileColorOpacity;
    public static String headerColor;
    public static String headerColorOpacity;
    public static String cellColor;
    public static String cellColorOpacity;
    public static String sFileTreeExpand;
    public static Boolean bTextEditorLineWrap;
    public static Boolean bFuncNotice;
    public static Boolean bAutoExcelServer;
    public static Boolean bLoadMathExtlib;
    public static Boolean bExcelXllType;
    public static String sQvsConfigFile;
    public static final int COPY_HTML = 0;
    public static final int COPY_TEXT = 1;
    public static Byte iCopyPresentType;
    public static Boolean bCopyPresentHeader;
    public static String sCopyPresentSep;
    public static Integer iUndoCount;

    static {
        bTextEditorLineWrap = Boolean.FALSE;
        bFuncNotice = Boolean.TRUE;
        bAutoExcelServer = Boolean.FALSE;
        bLoadMathExtlib = Boolean.FALSE;
        bExcelXllType = Boolean.TRUE;
        sQvsConfigFile = null;
        iCopyPresentType = 0;
        bCopyPresentHeader = Boolean.TRUE;
        sCopyPresentSep = "\t";
        iUndoCount = new Integer(20);
        ConfigOptions.putOptions();
    }

    public static void putOptions() {
        options.put("bIdeConsole", bIdeConsole);
        options.put("bAutoOpen", bAutoOpen);
        options.put("bAutoBackup", bAutoBackup);
        options.put("bAutoConnect", bAutoConnect);
        options.put("bWindowSize", bWindowSize);
        options.put("bViewWinList", bViewWinList);
        options.put("bUseUndo", bUseUndo);
        options.put("bTextEditorLineWrap", bTextEditorLineWrap);
        options.put("bAutoTrimChar0", bAutoTrimChar0);
        options.put("bAutoCleanOutput", bAutoCleanOutput);
        options.put("bAdjustNoteCell", bAdjustNoteCell);
        options.put("iLookAndFeel", iLookAndFeel);
        options.put("iConnectTimeout", iConnectTimeout);
        options.put("iFontSize", iFontSize);
        options.put("bDispOutCell", bDispOutCell);
        options.put("bAutoSizeRowHeight", bAutoSizeRowHeight);
        options.put("bMultiLineExpEditor", bMultiLineExpEditor);
        options.put("bStepLastLocation", bStepLastLocation);
        options.put("bFileTreeDemo", bFileTreeDemo);
        options.put("bAutoSave", bAutoSave);
        options.put("iAutoSaveMinutes", iAutoSaveMinutes);
        options.put("sBackupDirectory", sBackupDirectory);
        options.put("sAutoOpenFileNames", sAutoOpenFileNames);
        options.put("iConstFColor", new Integer(iConstFColor.getRGB()));
        options.put("iConstBColor", new Integer(iConstBColor.getRGB()));
        options.put("iNoteFColor", new Integer(iNoteFColor.getRGB()));
        options.put("iNoteBColor", new Integer(iNoteBColor.getRGB()));
        options.put("iCellNoteFColor", new Integer(iCellNoteFColor.getRGB()));
        options.put("iCellNoteBColor", new Integer(iCellNoteBColor.getRGB()));
        options.put("iValueFColor", new Integer(iValueFColor.getRGB()));
        options.put("iValueBColor", new Integer(iValueBColor.getRGB()));
        options.put("iNValueFColor", new Integer(iNValueFColor.getRGB()));
        options.put("iNValueBColor", new Integer(iNValueBColor.getRGB()));
        options.put("iBreakPointBColor", new Integer(iBreakPointBColor.getRGB()));
        options.put("iRowCount", iRowCount);
        options.put("iColCount", iColCount);
        options.put("fRowHeight", fRowHeight);
        options.put("fColWidth", fColWidth);
        options.put("sFontName", sFontName);
        options.put("iFontSize", iFontSize);
        options.put("bBold", bBold);
        options.put("bItalic", bItalic);
        options.put("bUnderline", bUnderline);
        options.put("bGirdLine", bGridline);
        options.put("iHAlign", iHAlign);
        options.put("iVAlign", iVAlign);
        options.put("iIndent", iIndent);
        options.put("iSequenceDispMembers", iSequenceDispMembers);
        options.put("sLogFileName", sLogFileName);
        options.put("bShowDBStruct", bShowDBStruct);
        options.put("bAutoShowTip", bAutoShowTip);
        options.put("iDBRecordCount", iDBRecordCount);
        options.put("iConsoleLocation", iConsoleLocation);
        options.put("iGridLocation", iGridLocation);
        options.put("iFileLocation", iFileLocation);
        options.put("sConfigFile", sConfigFile);
        options.put("bShowHttpConfig", bShowHttpConfig);
        options.put("iLocale", iLocale);
        options.put("sSlimerjsDirectory", sSlimerjsDirectory);
        options.put("sFileTreeExpand", sFileTreeExpand);
        options.put("iUndoCount", iUndoCount);
        options.put("sFileTip", sFileTip);
        options.put("bFuncNotice", bFuncNotice);
        options.put("bAutoExcelServer", bAutoExcelServer);
        options.put("bExcelXllType", bExcelXllType);
        options.put("sQvsConfigFile", sQvsConfigFile);
        options.put("bNoticeExpiration", bNoticeExpiration);
        options.put("bSNPrompt", bSNPrompt);
        options.put("bLoadMathExtlib", bLoadMathExtlib);
    }

    public static void save() throws Throwable {
        ConfigOptions.save(true);
    }

    public static void save(boolean holdConsole) throws Throwable {
        ConfigOptions.save(holdConsole, false);
    }

    public static void save(boolean holdConsole, boolean onlySave) throws Throwable {
        ConfigOptions.putOptions();
        cf = ConfigFile.getConfigFile();
        cf.setConfigNode(ConfigFile.NODE_OPTIONS);
        for (String option : options.keySet()) {
            Object optionVar = options.get(option);
            cf.setAttrValue(option, optionVar);
        }
        cf.save();
        if (onlySave) {
            return;
        }
        ConfigOptions.applyOptions(holdConsole);
    }

    public static void load() throws Throwable {
        ConfigOptions.load2(true);
    }

    public static void load2(boolean holdConsole) throws Throwable {
        ConfigOptions.load2(holdConsole, true);
    }

    public static void load2(boolean holdConsole, boolean applyOptions) throws Throwable {
        cf = ConfigFile.getConfigFile();
        cf.setConfigNode(ConfigFile.NODE_OPTIONS);
        Iterator<String> it = options.keySet().iterator();
        while (it.hasNext()) {
            ConfigOptions.loadOption(it.next());
        }
        if (applyOptions) {
            ConfigOptions.applyOptions(holdConsole);
        }
    }

    public static void loadOption(String option) {
        String val = cf.getAttrValue(option);
        if (!StringUtils.isValidString(val)) {
            return;
        }
        String type = option.substring(0, 1);
        if (type.equalsIgnoreCase("i")) {
            Integer ii = Integer.valueOf(val);
            if (option.equalsIgnoreCase("iLookAndFeel")) {
                iLookAndFeel = new Byte(ii.byteValue());
            } else if (option.equalsIgnoreCase("iConnectTimeout")) {
                iConnectTimeout = ii;
            } else if (option.equalsIgnoreCase("iRowCount")) {
                iRowCount = ii;
            } else if (option.equalsIgnoreCase("iColCount")) {
                iColCount = ii;
            } else if (option.equalsIgnoreCase("iConstFColor")) {
                iConstFColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iConstBColor")) {
                iConstBColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iNoteFColor")) {
                iNoteFColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iNoteBColor")) {
                iNoteBColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iCellNoteFColor")) {
                iCellNoteFColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iCellNoteBColor")) {
                iCellNoteBColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iValueFColor")) {
                iValueFColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iValueBColor")) {
                iValueBColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iNValueFColor")) {
                iNValueFColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iNValueBColor")) {
                iNValueBColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iBreakPointBColor")) {
                iBreakPointBColor = new Color(ii);
            } else if (option.equalsIgnoreCase("iFontSize")) {
                iFontSize = new Short(ii.shortValue());
            } else if (option.equalsIgnoreCase("iHAlign")) {
                iHAlign = new Byte(ii.byteValue());
            } else if (option.equalsIgnoreCase("iVAlign")) {
                iVAlign = new Byte(ii.byteValue());
            } else if (option.equalsIgnoreCase("iIndent")) {
                iIndent = ii;
            } else if (option.equalsIgnoreCase("iSequenceDispMembers")) {
                iSequenceDispMembers = ii;
            } else if (option.equalsIgnoreCase("iAutoShowTip")) {
                iAutoShowTip = ii;
            } else if (option.equalsIgnoreCase("iDBRecordCount")) {
                iDBRecordCount = ii;
            } else if (option.equalsIgnoreCase("iConsoleLocation")) {
                iConsoleLocation = ii;
            } else if (option.equalsIgnoreCase("iGridLocation")) {
                iGridLocation = ii;
            } else if (option.equalsIgnoreCase("iLocale")) {
                iLocale = new Byte(ii.byteValue());
            } else if (option.equalsIgnoreCase("iUndoCount")) {
                iUndoCount = ii;
            } else if (option.equalsIgnoreCase("iAutoSaveMinutes")) {
                iAutoSaveMinutes = ii;
            } else if (option.equalsIgnoreCase("iFileLocation")) {
                iFileLocation = ii;
            }
        } else if (type.equalsIgnoreCase("f")) {
            Float ii = Float.valueOf(val);
            if (option.equalsIgnoreCase("fRowHeight")) {
                fRowHeight = ii;
            } else if (option.equalsIgnoreCase("fColWidth")) {
                fColWidth = ii;
            }
        } else if (type.equalsIgnoreCase("b")) {
            Boolean ii = Boolean.valueOf(val);
            if (option.equalsIgnoreCase("bIdeConsole")) {
                bIdeConsole = ii;
            } else if (option.equalsIgnoreCase("bAutoOpen")) {
                bAutoOpen = ii;
            } else if (option.equalsIgnoreCase("bAutoBackup")) {
                bAutoBackup = ii;
            } else if (option.equalsIgnoreCase("bAutoConnect")) {
                bAutoConnect = ii;
            } else if (option.equalsIgnoreCase("bWindowSize")) {
                bWindowSize = ii;
            } else if (option.equalsIgnoreCase("bViewWinList")) {
                bViewWinList = ii;
            } else if (option.equalsIgnoreCase("bShowHttpConfig")) {
                bShowHttpConfig = ii;
            } else if (option.equalsIgnoreCase("bUseUndo")) {
                bUseUndo = ii;
            } else if (option.equalsIgnoreCase("bTextEditorLineWrap")) {
                bTextEditorLineWrap = ii;
            } else if (option.equalsIgnoreCase("bAutoTrimChar0")) {
                bAutoTrimChar0 = ii;
            } else if (option.equalsIgnoreCase("bAutoCleanOutput")) {
                bAutoCleanOutput = ii;
            } else if (option.equalsIgnoreCase("bAdjustNoteCell")) {
                bAdjustNoteCell = ii;
            } else if (option.equalsIgnoreCase("bDispOutCell")) {
                bDispOutCell = ii;
            } else if (option.equalsIgnoreCase("bAutoSizeRowHeight")) {
                bAutoSizeRowHeight = ii;
            } else if (!option.equalsIgnoreCase("bAutoCalc")) {
                if (option.equalsIgnoreCase("bMultiLineExpEditor")) {
                    bMultiLineExpEditor = ii;
                } else if (option.equalsIgnoreCase("bStepLastLocation")) {
                    bStepLastLocation = ii;
                } else if (option.equalsIgnoreCase("bBold")) {
                    bBold = ii;
                } else if (option.equalsIgnoreCase("bItalic")) {
                    bItalic = ii;
                } else if (option.equalsIgnoreCase("bUnderline")) {
                    bUnderline = ii;
                } else if (option.equalsIgnoreCase("bGirdLine")) {
                    bGridline = ii;
                } else if (option.equalsIgnoreCase("bShowDBStruct")) {
                    bShowDBStruct = ii;
                } else if (option.equalsIgnoreCase("bAutoShowTip")) {
                    bAutoShowTip = ii;
                } else if (option.equalsIgnoreCase("bFileTreeDemo")) {
                    bFileTreeDemo = ii;
                } else if (option.equalsIgnoreCase("bAutoSave")) {
                    bAutoSave = ii;
                } else if (option.equalsIgnoreCase("bFuncNotice")) {
                    bFuncNotice = ii;
                } else if (option.equalsIgnoreCase("bNoticeExpiration")) {
                    bNoticeExpiration = ii;
                } else if (option.equalsIgnoreCase("bAutoExcelServer")) {
                    bAutoExcelServer = ii;
                } else if (option.equalsIgnoreCase("bExcelXllType")) {
                    bExcelXllType = ii;
                } else if (option.equalsIgnoreCase("bSNPrompt")) {
                    bSNPrompt = ii;
                } else if (option.equalsIgnoreCase("bLoadMathExtlib")) {
                    bLoadMathExtlib = ii;
                }
            }
        } else if (StringUtils.isValidString(val)) {
            if (option.equalsIgnoreCase("sLogFileName")) {
                sLogFileName = val;
            } else if (option.equalsIgnoreCase("sFontName")) {
                sFontName = val;
            } else if (option.equalsIgnoreCase("sSlimerjsDirectory")) {
                sSlimerjsDirectory = val;
            } else if (option.equalsIgnoreCase("sFileTreeExpand")) {
                sFileTreeExpand = val;
            } else if (option.equalsIgnoreCase("sBackupDirectory")) {
                sBackupDirectory = val;
            } else if (option.equalsIgnoreCase("sAutoOpenFileNames")) {
                sAutoOpenFileNames = val;
            } else if (option.equalsIgnoreCase("sQvsConfigFile")) {
                sQvsConfigFile = val;
            } else if (option.equalsIgnoreCase("sFileTip")) {
                sFileTip = val;
            } else if (option.equalsIgnoreCase("sConfigFile")) {
                sConfigFile = val;
            }
        }
    }

    public static void applyOptions() {
        ConfigOptions.applyOptions(true);
    }

    public static void applyOptions(boolean holdConsole) {
        ConfigOptions.applyOptions(holdConsole, false);
    }

    public static void applyOptions(boolean holdConsole, boolean isReport) {
        int style = 0;
        if (bBold.booleanValue()) {
            ++style;
        }
        if (bItalic.booleanValue()) {
            style += 2;
        }
        GC.font = new Font(sFontName, style, iFontSize.intValue());
        Env.setPaths(GM.getPaths());
        String tempPath = sTempPath;
        if (tempPath != null && tempPath.trim().length() == 0) {
            tempPath = null;
        }
        Env.setTempPath(null);
        if (StringUtils.isValidString(sMainPath)) {
            String mainPath = ConfigUtil.getPath(System.getProperty("start.home"), sMainPath);
            Env.setMainPath(mainPath);
            if (StringUtils.isValidString(tempPath)) {
                Env.setTempPath(ConfigUtil.getPath(mainPath, tempPath));
            }
        } else {
            File tempDir;
            GM.setCurrentPath(null);
            if (StringUtils.isValidString(tempPath) && (tempDir = new File(tempPath)).isAbsolute()) {
                Env.setTempPath(tempPath);
            }
        }
        if (StringUtils.isValidString(Env.getTempPath())) {
            try {
                File f = new File(Env.getTempPath());
                if (!f.exists()) {
                    f.mkdir();
                }
            }
            catch (Exception ex) {
                Logger.info("Make temp directory failed:");
                ex.printStackTrace();
            }
        }
        if (StringUtils.isValidString(sDateFormat)) {
            Env.setDateFormat(sDateFormat);
        }
        if (StringUtils.isValidString(sTimeFormat)) {
            Env.setTimeFormat(sTimeFormat);
        }
        if (StringUtils.isValidString(sDateTimeFormat)) {
            Env.setDateTimeFormat(sDateTimeFormat);
        }
        if (StringUtils.isValidString(sDefCharsetName)) {
            Env.setDefaultChartsetName(sDefCharsetName);
        }
        ICursor.FETCHCOUNT = iFetchCount;
        if (GM.isBlockSizeEnabled()) {
            Env.setFileBufSize(ConfigUtil.parseBufferSize(sFileBuffer));
            if (StringUtils.isValidString(sBlockSize)) {
                ConfigUtil.setEnvBlockSize(sBlockSize);
            }
        }
        Env.setNullStrings(ConfigUtil.splitNullStrings(sNullStrings));
        Env.setParallelNum(iParallelNum);
        Env.setCursorParallelNum(iCursorParallelNum);
        Env.setAdjustNoteCell(bAdjustNoteCell);
        if (holdConsole && bIdeConsole.booleanValue()) {
            AppFrame.holdConsole();
        }
        if (!isReport) {
            try {
                Logger.setPropertyConfig(ConfigOptions.getLoggerProperty());
            }
            catch (Exception e) {
                GM.showException(GV.appFrame, e);
            }
            DriverManager.setLoginTimeout(iConnectTimeout);
        }
    }

    public static Properties getLoggerProperty() {
        Properties props = new Properties();
        String logName = "IDE_CONSOLE";
        String logPath = null;
        if (StringUtils.isValidString(sLogFileName)) {
            logName = String.valueOf(logName) + ",IDE_LOGFILE";
            logPath = GM.getAbsolutePath(sLogFileName);
        }
        props.put("Logger", logName);
        String sLogLevel = GV.config.getLogLevel();
        if (logPath != null) {
            props.put("IDE_LOGFILE", logPath);
            if (sLogLevel != null) {
                props.put("IDE_LOGFILE.Level", sLogLevel);
            }
            props.put("IDE_LOGFILE.Encoding", "UTF-8");
        }
        props.put("IDE_CONSOLE", "Console");
        if (sLogLevel != null) {
            props.put("IDE_CONSOLE.Level", sLogLevel);
        }
        props.put("IDE_CONSOLE.Encoding", "UTF-8");
        return props;
    }

    public static Vector<String> dispLevels() {
        String[] levelNames = Logger.listLevelNames();
        Vector<String> levels = new Vector<String>();
        if (levelNames != null) {
            String[] stringArray = levelNames;
            int n = levelNames.length;
            int n2 = 0;
            while (n2 < n) {
                String levelName = stringArray[n2];
                levels.add(levelName);
                ++n2;
            }
        }
        return levels;
    }

    public static Vector<String> codeLogTypes() {
        Vector<String> v = new Vector<String>();
        v.add("default");
        v.add("slf4j");
        return v;
    }

    public static Vector<String> dispLogTypes() {
        Vector<String> v = new Vector<String>();
        v.add(IdeCommonMessage.get().getMessage("configoptions.ltdefault"));
        v.add(IdeCommonMessage.get().getMessage("configoptions.ltslf"));
        return v;
    }

    public static Locale getLocaleByName(String dispName) {
        if (dispName == null) {
            return null;
        }
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            int i = 0;
            while (i < locales.length) {
                if (dispName.equals(locales[i].getDisplayName())) {
                    return locales[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static Color getFileColor() {
        String color = fileColor;
        if (StringUtils.isValidString(color) && color.length() == 7) {
            int red = Integer.parseInt(color.substring(1, 3), 16);
            int green = Integer.parseInt(color.substring(3, 5), 16);
            int blue = Integer.parseInt(color.substring(5, 7), 16);
            int opacity = StringUtils.isValidString(fileColorOpacity) ? Math.round(255.0f * Float.parseFloat(fileColorOpacity)) : 255;
            return new Color(red, green, blue, opacity);
        }
        return null;
    }

    public static Color getHeaderColor() {
        String color = headerColor;
        if (StringUtils.isValidString(color) && color.length() == 7) {
            int red = Integer.parseInt(color.substring(1, 3), 16);
            int green = Integer.parseInt(color.substring(3, 5), 16);
            int blue = Integer.parseInt(color.substring(5, 7), 16);
            int opacity = StringUtils.isValidString(headerColorOpacity) ? Math.round(255.0f * Float.parseFloat(headerColorOpacity)) : 255;
            return new Color(red, green, blue, opacity);
        }
        return null;
    }

    public static Color getCellColor() {
        String color = cellColor;
        if (StringUtils.isValidString(color) && color.length() == 7) {
            int red = Integer.parseInt(color.substring(1, 3), 16);
            int green = Integer.parseInt(color.substring(3, 5), 16);
            int blue = Integer.parseInt(color.substring(5, 7), 16);
            int opacity = StringUtils.isValidString(cellColorOpacity) ? Math.round(255.0f * Float.parseFloat(cellColorOpacity)) : 255;
            return new Color(red, green, blue, opacity);
        }
        return null;
    }
}

