/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.ConfigWriter;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.parallel.Task;
import com.scudata.parallel.UnitConfig;
import com.scudata.parallel.UnitContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ConfigUtilIde {
    public static String CONFIG_FILE = "config/raqsoftConfig.xml";
    public static final String UNIT_CONFIG_FILE = "config/" + UnitContext.UNIT_XML;

    public static void setTask() {
        ArrayList<String> dsNames = null;
        if (GV.dsModel != null) {
            int size = GV.dsModel.size();
            dsNames = new ArrayList<String>();
            int i = 0;
            while (i < size) {
                DataSource ds = (DataSource)GV.dsModel.get(i);
                if (!ds.isClosed()) {
                    dsNames.add(ds.getName());
                }
                ++i;
            }
        }
        Task.setConnectedDsNames(dsNames);
    }

    public static boolean writeConfig() throws Exception {
        return ConfigUtilIde.writeConfig(true);
    }

    public static boolean writeConfig(boolean resetDS) throws Exception {
        File f = new File(GM.getAbsolutePath(CONFIG_FILE));
        return ConfigUtilIde.writeConfig(resetDS, GV.config, f);
    }

    public static boolean writeActiveConfig() throws Exception {
        return ConfigUtilIde.writeActiveConfig(true);
    }

    public static boolean writeActiveConfig(boolean resetDS) throws Exception {
        File f = new File(GM.getAbsolutePath(ConfigOptions.sConfigFile));
        return ConfigUtilIde.writeConfig(resetDS, GV.config, f);
    }

    public static boolean writeConfig(boolean resetDS, RaqsoftConfig config) throws Exception {
        File f = new File(GM.getAbsolutePath(ConfigOptions.sConfigFile));
        return ConfigUtilIde.writeConfig(resetDS, config, f);
    }

    public static boolean writeConfig(boolean resetDS, RaqsoftConfig config, File f) throws Exception {
        if (f == null) {
            return false;
        }
        if (resetDS) {
            GM.resetEnvDataSource(GV.dsModel);
            ConfigUtilIde.setTask();
        }
        if (f.exists() && !f.canWrite()) {
            String msg = IdeCommonMessage.get().getMessage("public.readonly", f.getName());
            throw new RQException(msg);
        }
        if (config == null) {
            GV.config = config = new RaqsoftConfig();
        }
        String filePath = f.getAbsolutePath();
        String tmpPath = String.valueOf(filePath) + ".tmp";
        File tmpFile = new File(tmpPath);
        try {
            ConfigUtil.write(tmpFile.getAbsolutePath(), config);
            try {
                new File(filePath).delete();
                tmpFile.renameTo(new File(filePath));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        finally {
            tmpFile = new File(tmpPath);
            if (tmpFile != null && tmpFile.exists() && tmpFile.isFile()) {
                try {
                    tmpFile.delete();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return true;
    }

    public static boolean writeUnitConfig(UnitConfig config) throws Exception {
        String filePath = GM.getAbsolutePath(UNIT_CONFIG_FILE);
        File f = new File(filePath);
        if (f.exists() && !f.canWrite()) {
            String msg = IdeCommonMessage.get().getMessage("public.readonly", f.getName());
            throw new RQException(msg);
        }
        ConfigUtilIde.writeUnitConfig(filePath, config);
        return true;
    }

    public static void writeUnitConfig(String filePath, UnitConfig config) throws Exception {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(filePath);
            bos = new BufferedOutputStream(fos);
            ConfigWriter cw = new ConfigWriter();
            cw.writeUnitConfig(bos, config);
            ((BufferedOutputStream)bos).flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static RaqsoftConfig loadConfig(boolean setLogLevel) throws IOException {
        String home = System.getProperty("start.home");
        String filePath = ConfigUtil.getPath(home, CONFIG_FILE);
        return ConfigUtilIde.loadConfig(filePath, setLogLevel);
    }

    public static RaqsoftConfig loadConfig(String filePath, boolean setLogLevel) throws IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(filePath);
            bis = new BufferedInputStream(fis);
            RaqsoftConfig raqsoftConfig = ConfigUtilIde.loadConfig(bis, setLogLevel);
            return raqsoftConfig;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static RaqsoftConfig loadConfig(InputStream is) {
        return ConfigUtilIde.loadConfig(is, true);
    }

    public static RaqsoftConfig loadConfig(InputStream is, boolean setLogLevel) {
        try {
            RaqsoftConfig config = ConfigUtil.load(is);
            if (config != null) {
                try {
                    ConfigUtil.setConfig(Env.getApplication(), System.getProperty("start.home"), config, setLogLevel, false, false, false);
                }
                catch (Exception e) {
                    GM.showException(GV.appFrame, e);
                }
                ConfigUtilIde.setConfigOptions(config);
            }
            return config;
        }
        catch (Exception e) {
            GM.showException(GV.appFrame, e);
            return null;
        }
    }

    public static void setConfigOptions(RaqsoftConfig config) {
        String slimerjsDir;
        String tempPath;
        String mainPath;
        try {
            ConfigOptions.iParallelNum = new Integer(config.getParallelNum());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ConfigOptions.iParallelNum < 1) {
            ConfigOptions.iParallelNum = new Integer(1);
        }
        try {
            ConfigOptions.iCursorParallelNum = new Integer(config.getCursorParallelNum());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ConfigOptions.iCursorParallelNum < 1) {
            ConfigOptions.iCursorParallelNum = new Integer(1);
        }
        List<String> splList = config.getSplPathList();
        StringBuffer paths = null;
        if (splList != null && !splList.isEmpty()) {
            paths = new StringBuffer();
            int i = 0;
            while (i < splList.size()) {
                if (i > 0) {
                    paths.append(";");
                }
                paths.append(splList.get(i));
                ++i;
            }
        }
        ConfigOptions.sPaths = paths == null ? null : paths.toString();
        ConfigOptions.sMainPath = mainPath = config.getMainPath();
        ConfigOptions.sTempPath = tempPath = config.getTempPath();
        Properties pro = config.getServerProperties();
        if (pro != null && (slimerjsDir = pro.getProperty("slimerjsDir")) != null && slimerjsDir.trim().length() > 0) {
            ConfigOptions.sSlimerjsDirectory = slimerjsDir;
        }
        ConfigOptions.sDateFormat = config.getDateFormat();
        ConfigOptions.sTimeFormat = config.getTimeFormat();
        ConfigOptions.sDateTimeFormat = config.getDateTimeFormat();
        ConfigOptions.sDefCharsetName = config.getCharSet();
        ConfigOptions.sNullStrings = config.getNullStrings();
        String sFetchCount = config.getFetchCount();
        if (StringUtils.isValidString(sFetchCount)) {
            try {
                int fetchCount = Integer.parseInt(sFetchCount);
                ConfigOptions.iFetchCount = new Integer(fetchCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConfigOptions.sExtLibsPath = config.getExtLibsPath();
        ConfigOptions.sInitSpl = config.getInitSpl();
        ConfigOptions.sCustomFunctionFile = config.getCustomFunctionFile();
        if (StringUtils.isValidString(config.getBufSize())) {
            ConfigOptions.sFileBuffer = config.getBufSize();
        }
        if (StringUtils.isValidString(config.getBlockSize())) {
            ConfigOptions.sBlockSize = config.getBlockSize();
        }
    }
}

