/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.LimitedQueue;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Console {
    private int MAX_LENGTH = 500000;
    private JTextArea jta = null;
    private PrintStream ps;
    private Object rowLock = new Object();
    private LimitedQueue rowBuffers = new LimitedQueue(10000);
    private ArrayList<InputStreamFlusher> flushers = new ArrayList();

    public Console(JTextArea jta) {
        this(jta, null);
    }

    public Console(final JTextArea jta, InputStream[] is) {
        this.jta = jta;
        ConsoleOutputStream cos = new ConsoleOutputStream(jta);
        this.ps = new PrintStream(cos);
        if (is == null) {
            System.setOut(this.ps);
            System.setErr(this.ps);
        } else {
            this.setInputStreams(is);
        }
        Timer timer = new Timer();
        TimerTask tt = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Console.this.rowLock;
                synchronized (object) {
                    if (!Console.this.rowBuffers.isChanged()) {
                        return;
                    }
                    int rows = Console.this.rowBuffers.size();
                    final ArrayList<String> strList = new ArrayList<String>();
                    int r = 0;
                    while (r < rows) {
                        strList.add((String)Console.this.rowBuffers.get(r));
                        ++r;
                    }
                    Console.this.rowBuffers.clear();
                    Console.this.rowBuffers.setUnChanged();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 0;
                                while (i < strList.size()) {
                                    jta.append((String)strList.get(i));
                                    ++i;
                                }
                                String text = jta.getText();
                                if (text != null) {
                                    int len = text.length();
                                    if (len > Console.this.MAX_LENGTH) {
                                        text = text.substring(Console.this.MAX_LENGTH / 2);
                                        jta.setText(text);
                                    }
                                    if (!Console.this.isTextSelected()) {
                                        jta.setCaretPosition(text.length());
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        };
        timer.scheduleAtFixedRate(tt, 1000L, 1000L);
    }

    public void clear() {
        this.jta.setText(null);
        this.rowBuffers.clear();
    }

    public void clearCaseSelection() {
        if (this.isTextSelected()) {
            this.jta.replaceSelection("");
        } else {
            this.clear();
        }
    }

    protected boolean isTextSelected() {
        return this.jta.getSelectionStart() != this.jta.getSelectionEnd();
    }

    public void setInputStreams(InputStream[] is) {
        this.clearFlusher();
        int len = is.length;
        int i = 0;
        while (i < len) {
            InputStreamFlusher isFlush = new InputStreamFlusher(is[i]);
            this.flushers.add(isFlush);
            isFlush.start();
            ++i;
        }
    }

    public JTextArea getTextArea() {
        return this.jta;
    }

    private void clearFlusher() {
        for (InputStreamFlusher flusher : this.flushers) {
            flusher.shutDown();
        }
        this.flushers.clear();
    }

    class ConsoleOutputStream
    extends OutputStream {
        byte LF = (byte)10;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(17);
        JTextArea jta = null;
        final String SYS_RETURN = System.getProperty("line.separator", "\n");

        public ConsoleOutputStream(JTextArea jta) {
            this.jta = jta;
        }

        @Override
        public void write(int b) throws IOException {
            this.baos.write(b);
            if (b == this.LF) {
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            String output = this.baos.toString();
            this.baos.reset();
            if (("Yo" + this.SYS_RETURN).equals(output)) {
                return;
            }
            Object object = Console.this.rowLock;
            synchronized (object) {
                Console.this.rowBuffers.add(output);
            }
        }
    }

    class InputStreamFlusher
    extends Thread {
        InputStream is;
        volatile boolean stop = false;

        public InputStreamFlusher(InputStream is) {
            this.is = is;
        }

        public void shutDown() {
            this.stop = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BufferedReader br1 = new BufferedReader(new InputStreamReader(this.is));
            try {
                try {
                    String line1 = null;
                    while (true) {
                        line1 = br1.readLine();
                        if (line1 == null) return;
                        if (this.stop) {
                            return;
                        }
                        if (line1 == null) continue;
                        Console.this.ps.println(line1);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.is.close();
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

