/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.common.Section;
import com.scudata.common.DBTypes;
import com.scudata.common.IntArrayList;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.XMLFile;
import java.util.StringTokenizer;

public class DBTypeEx
extends DBTypes {
    public static final String TITLE_ORACLE = "ORACLE";
    public static final String TITLE_MS_SQL_Server = "MS_SQL_Server";
    public static final String TITLE_DB2 = "IBM_DB2";
    public static final String TITLE_SYBASE = "Sybase";
    public static final String TITLE_ACCESS = "Access";
    public static final String TITLE_MYSQL = "My_SQL";
    public static final String TITLE_HSQL = "HSQL";
    public static final String TITLE_TERADATA = "TERADATA";
    public static final String TITLE_POSTGRES = "POSTGRES";
    public static final String TITLE_DBONE = "DBONE";
    public static final String TITLE_ESPROC = "esProc";
    public static final String TITLE_DATALOGIC = "DataLogic";
    public static final String TITLE_DAMENG = "DAMENG";
    public static final String TITLE_ESPROC_SQL = "esProc_sql";
    public static final String TITLE_UNKNOWN = "Other";

    public static int[] listDefaultDBTypes() {
        int[] nArray = new int[15];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 9;
        nArray[3] = 3;
        nArray[4] = 7;
        nArray[5] = 10;
        nArray[6] = 13;
        nArray[7] = 14;
        nArray[8] = 15;
        nArray[9] = 20;
        nArray[10] = 21;
        nArray[11] = 16;
        nArray[12] = 22;
        nArray[13] = 23;
        return nArray;
    }

    public static String[] listDefaultDBTitles() {
        return new String[]{TITLE_ORACLE, TITLE_MS_SQL_Server, TITLE_DB2, TITLE_SYBASE, TITLE_ACCESS, TITLE_MYSQL, TITLE_HSQL, TITLE_TERADATA, TITLE_POSTGRES, TITLE_DBONE, TITLE_ESPROC, TITLE_DATALOGIC, TITLE_DAMENG, TITLE_ESPROC_SQL, TITLE_UNKNOWN};
    }

    public static int getDBType(String dbTypeName) {
        return DBTypeEx.getDBType(dbTypeName, DBTypeEx.getXMLFile());
    }

    public static int getDBType(String dbTypeName, XMLFile file) {
        if (dbTypeName == null) {
            return 0;
        }
        String[] dbNames = DBTypeEx.listDBTitles(file);
        int[] dbTypes = DBTypeEx.listDBTypes(file);
        if (dbNames == null || dbTypes == null || dbNames.length != dbTypes.length) {
            dbNames = DBTypeEx.listDefaultDBTitles();
            dbTypes = DBTypeEx.listDefaultDBTypes();
        }
        String dtn = dbTypeName.trim();
        int i = 0;
        while (i < dbNames.length) {
            if (dbNames[i].equalsIgnoreCase(dtn)) {
                return dbTypes[i];
            }
            ++i;
        }
        return 0;
    }

    public static String getDBTypeName(int dbType) {
        return DBTypeEx.getDBTypeName(dbType, DBTypeEx.getXMLFile());
    }

    public static String getDBTypeName(int dbType, XMLFile file) {
        String[] dbNames = DBTypeEx.listDBTitles(file);
        int[] dbTypes = DBTypeEx.listDBTypes(file);
        if (dbNames == null || dbTypes == null || dbNames.length != dbTypes.length) {
            dbNames = DBTypeEx.listDefaultDBTitles();
            dbTypes = DBTypeEx.listDefaultDBTypes();
        }
        int i = 0;
        while (i < dbTypes.length) {
            if (dbType == dbTypes[i]) {
                return dbNames[i];
            }
            ++i;
        }
        return "UNKNOWN";
    }

    public static String[] getFixedDriver(String dbTitle) {
        String[] s = new String[]{""};
        if (dbTitle == null) {
            return s;
        }
        if (dbTitle.equalsIgnoreCase(TITLE_ORACLE)) {
            s = new String[]{"oracle.jdbc.driver.OracleDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_MS_SQL_Server)) {
            s = new String[]{"com.newatlanta.jturbo.driver.Driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DB2)) {
            s = new String[]{"COM.ibm.db2.jdbc.app.DB2Driver", "COM.ibm.db2.jdbc.net.DB2Driver", "com.ibm.db2.jcc.DB2Driver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_SYBASE)) {
            s = new String[]{"com.sybase.jdbc2.jdbc.SybDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_ACCESS)) {
            s = new String[]{"sun.jdbc.odbc.JdbcOdbcDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_MYSQL)) {
            s = new String[]{"com.mysql.jdbc.Driver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_HSQL)) {
            s = new String[]{"org.hsqldb.jdbcDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_TERADATA)) {
            s = new String[]{"com.ncr.teradata.TeraDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_POSTGRES)) {
            s = new String[]{"org.postgresql.Driver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DBONE)) {
            s = new String[]{"com.intple.dbone.Driver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_ESPROC) || dbTitle.equalsIgnoreCase(TITLE_ESPROC_SQL)) {
            s = new String[]{"com.esproc.jdbc.InternalDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DATALOGIC)) {
            s = new String[]{"com.datalogic.jdbc.LogicDriver"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DAMENG)) {
            s = new String[]{"dm.jdbc.driver.DmDriver"};
        }
        return s;
    }

    public static String[] getFixedURL(String dbTitle) {
        String[] s = new String[]{""};
        if (dbTitle == null) {
            return s;
        }
        if (dbTitle.equalsIgnoreCase(TITLE_ORACLE)) {
            s = new String[]{"jdbc:oracle:thin:@127.0.0.1:1521:[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_MS_SQL_Server)) {
            s = new String[]{"jdbc:JTurbo://127.0.0.1/[database name]/charset=ISO-8859-1", "jdbc:sqlserver://127.0.0.1:1433;DatabaseName=[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DB2)) {
            s = new String[]{"jdbc:Db2:[database name]", "jdbc:db2://127.0.0.1:6789/[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_SYBASE)) {
            s = new String[]{"jdbc:sybase:Tds:127.0.0.1:2048/[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_ACCESS)) {
            s = new String[]{"jdbc:odbc:[odbc data source name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_MYSQL)) {
            s = new String[]{"jdbc:mysql://127.0.0.1:3306/[database name]?useCursorFetch=[true/false]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_HSQL)) {
            s = new String[]{"jdbc:hsqldb:hsql://127.0.0.1/"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_TERADATA)) {
            s = new String[]{"jdbc:teradata://127.0.0.1/CLIENT_CHARSET=EUC_CN,TMODE=TERA,CHARSET=ASCII,DATABASE=[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_POSTGRES)) {
            s = new String[]{"jdbc:postgresql://127.0.0.1:5432/[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DBONE)) {
            s = new String[]{"jdbc:dbone://127.0.0.1:9001/[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_ESPROC) || dbTitle.equalsIgnoreCase(TITLE_ESPROC_SQL)) {
            s = new String[]{"jdbc:esproc:local://"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DATALOGIC)) {
            s = new String[]{"jdbc:datalogic://127.0.0.1:3366/[database name]"};
        } else if (dbTitle.equalsIgnoreCase(TITLE_DAMENG)) {
            s = new String[]{"jdbc:dm://127.0.0.1:5236/[database name]"};
        }
        return s;
    }

    public static String[] getDBSampleDriver(String dbTitle) {
        return DBTypeEx.getDBSampleDriver(dbTitle, DBTypeEx.getXMLFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getDBSampleDriver(String dbTitle, XMLFile file) {
        try {
            if (file == null) {
                return DBTypeEx.getFixedDriver(dbTitle);
            }
            String titleKey = Sentence.replace(dbTitle, " ", "_", 0);
            String PATH = "RAQSOFT/DATABASE/" + titleKey + "/driver";
            Section drivers = new Section();
            int c = 1;
            String buff = file.getAttribute(String.valueOf(PATH) + c);
            if (!StringUtils.isValidString(buff)) {
                return DBTypeEx.getFixedDriver(dbTitle);
            }
            while (true) {
                if (!StringUtils.isValidString(buff)) {
                    return drivers.toStringArray();
                }
                drivers.addSection(buff);
                buff = file.getAttribute(String.valueOf(PATH) + ++c);
            }
        }
        catch (Throwable e) {
            return DBTypeEx.getFixedDriver(dbTitle);
        }
    }

    public static String[] getDBSampleURL(String dbTitle) {
        return DBTypeEx.getDBSampleURL(dbTitle, DBTypeEx.getXMLFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getDBSampleURL(String dbTitle, XMLFile file) {
        try {
            if (file == null) {
                return DBTypeEx.getFixedURL(dbTitle);
            }
            String titleKey = Sentence.replace(dbTitle, " ", "_", 0);
            String PATH = "RAQSOFT/DATABASE/" + titleKey + "/url";
            Section urls = new Section();
            int c = 1;
            String buff = file.getAttribute(String.valueOf(PATH) + c);
            if (!StringUtils.isValidString(buff)) {
                return DBTypeEx.getFixedURL(dbTitle);
            }
            while (true) {
                if (!StringUtils.isValidString(buff)) {
                    return urls.toStringArray();
                }
                urls.addSection(buff);
                buff = file.getAttribute(String.valueOf(PATH) + ++c);
            }
        }
        catch (Throwable e) {
            return DBTypeEx.getFixedURL(dbTitle);
        }
    }

    public static String[] listDBTitles() {
        return DBTypeEx.listDBTitles(DBTypeEx.getXMLFile());
    }

    public static XMLFile getXMLFile() {
        ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
        if (sysConfig == null) {
            return null;
        }
        return sysConfig.xmlFile();
    }

    public static String[] listDBTitles(XMLFile file) {
        try {
            String PATH;
            String buff;
            Section urls;
            if (file != null && (urls = new Section(buff = file.getAttribute(PATH = "RAQSOFT/DATABASE/titles"))).size() > 0) {
                return urls.toStringArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DBTypeEx.listDefaultDBTitles();
    }

    public static int[] listDBTypes() {
        return DBTypeEx.listDBTypes(DBTypeEx.getXMLFile());
    }

    public static int[] listDBTypes(XMLFile file) {
        try {
            if (file != null) {
                String PATH = "RAQSOFT/DATABASE/types";
                String buff = file.getAttribute(PATH);
                StringTokenizer st = new StringTokenizer(buff, ",");
                IntArrayList typeList = new IntArrayList();
                while (st.hasMoreElements()) {
                    typeList.addInt(Integer.parseInt((String)st.nextElement()));
                }
                if (typeList.size() > 0) {
                    return typeList.toIntArray();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DBTypeEx.listDefaultDBTypes();
    }

    public static String getErrorMessage(String dbTitle) {
        return DBTypeEx.getErrorMessage(dbTitle, DBTypeEx.getXMLFile());
    }

    public static String getErrorMessage(String dbTitle, XMLFile file) {
        try {
            if (file == null) {
            }
            String PATH = "RAQSOFT/DATABASE/" + dbTitle + "/errormessage";
            String buff = file.getAttribute(PATH);
            if (!StringUtils.isValidString(buff)) {
            }
            return buff;
        }
        finally {
            return null;
        }
    }
}

