/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.DBConfig;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.GV;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class DataSourceListModel
extends DefaultListModel<DataSource>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public DataSourceListModel() {
        this(true);
    }

    public DataSourceListModel(boolean loadDS) {
        if (loadDS) {
            this.loadDataSources();
        }
    }

    @Override
    public int size() {
        return super.getSize();
    }

    public DataSource getDataSource(int index) {
        return (DataSource)this.getElementAt(index);
    }

    public DataSource getDataSource(String name) {
        if (!StringUtils.isValidString(name)) {
            return null;
        }
        Enumeration dd = this.elements();
        DataSource ds = null;
        while (dd.hasMoreElements()) {
            ds = (DataSource)dd.nextElement();
            String tmpName = ds.getName();
            if (!name.equalsIgnoreCase(tmpName)) continue;
            return ds;
        }
        return null;
    }

    public void addDataSource(DataSource ds) {
        super.addElement(ds);
    }

    public void setDataSource(int index, DataSource ds) {
        super.setElementAt(ds, index);
    }

    public void insertDataSource(int index, DataSource ds) {
        super.insertElementAt(ds, index);
    }

    public void removeDataSource(int index) {
        super.removeElementAt(index);
    }

    public void removeAll() {
        super.removeAllElements();
    }

    protected RaqsoftConfig getRaqsoftConfig() {
        return GV.config;
    }

    protected void loadDataSources() {
        List<DBConfig> dbList;
        RaqsoftConfig config;
        try {
            ConfigFile sysConfig = ConfigFile.getSystemConfigFile();
            if (sysConfig != null) {
                sysConfig.loadDataSource(this, (byte)1);
            }
        }
        catch (Exception sysConfig) {
            // empty catch block
        }
        if ((config = this.getRaqsoftConfig()) != null && (dbList = config.getDBList()) != null) {
            int i = 0;
            while (i < dbList.size()) {
                DBConfig db = dbList.get(i);
                if (this.existDSName(db.getName())) {
                    Logger.debug("Notice: datasource[ " + db.getName() + " ] exist, ignore.");
                } else {
                    DataSource ds = new DataSource(db);
                    this.addElement(ds);
                }
                ++i;
            }
        }
    }

    public boolean existDSName(String name) {
        return this.getDataSource(name) != null;
    }

    public Vector<String> listNames() {
        Enumeration dd = this.elements();
        Vector<String> names = new Vector<String>();
        while (dd.hasMoreElements()) {
            DataSource ds = (DataSource)dd.nextElement();
            names.add(ds.getDBInfo().getName());
        }
        return names;
    }

    public void addRemoteDataSource(DataSource ds) {
        if (this.existDSName(ds.getName())) {
            Logger.debug("Notice: Remote datasource[ " + ds.getName() + " ] replaced the same name local or system one.");
            this.removeElement(this.getDataSource(ds.getName()));
        }
        ds.setDSFrom((byte)2);
        this.addElement(ds);
    }
}

