/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.MessageManager;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class DataSourceRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    public DataSourceRenderer() {
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DataSource ds = (DataSource)value;
        String dispText = ds.getDBInfo().getName();
        MessageManager mm = IdeCommonMessage.get();
        if (ds.isClosed()) {
            this.setForeground(Color.black);
            if (ds.isSystem()) {
                this.setText(String.valueOf(mm.getMessage("datasourcelist.system")) + dispText + mm.getMessage("datasourcelist.notconnect"));
            } else if (ds.isRemote()) {
                this.setText(String.valueOf(mm.getMessage("datasourcelist.remote")) + dispText + mm.getMessage("datasourcelist.notconnect"));
            } else {
                this.setText(String.valueOf(dispText) + mm.getMessage("datasourcelist.notconnect"));
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
        } else {
            this.setForeground(Color.magenta);
            if (ds.isSystem()) {
                this.setText(String.valueOf(mm.getMessage("datasourcelist.system")) + dispText + mm.getMessage("datasourcelist.connect"));
            } else if (ds.isRemote()) {
                this.setText(String.valueOf(mm.getMessage("datasourcelist.remote")) + dispText + mm.getMessage("datasourcelist.connect"));
            } else {
                this.setText(String.valueOf(dispText) + mm.getMessage("datasourcelist.connect"));
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
        }
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }

    private int getTab(int index) {
        int defaultTab = 50;
        return defaultTab * index;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color colorRetainer = g.getColor();
        FontMetrics fm = g.getFontMetrics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top + fm.getAscent();
        StringTokenizer st = new StringTokenizer(this.getText(), "\t");
        while (st.hasMoreTokens()) {
            String sNext = st.nextToken();
            g.drawString(sNext, x, y);
            x += fm.stringWidth(sNext);
            if (!st.hasMoreTokens()) break;
            int index = 0;
            while (x >= this.getTab(index)) {
                ++index;
            }
            x = this.getTab(index);
        }
        g.setColor(colorRetainer);
    }
}

