/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import com.scudata.app.common.Section;
import com.scudata.app.config.ConfigUtil;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.GMBase;
import com.scudata.common.IntArrayList;
import com.scudata.common.Logger;
import com.scudata.common.Matrix;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DBObject;
import com.scudata.dm.Env;
import com.scudata.dm.IResource;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.KeyWord;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.sql.SQLUtil;
import com.scudata.ide.common.AppFrame;
import com.scudata.ide.common.ConfigFile;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.ConfigUtilIde;
import com.scudata.ide.common.DBTypeEx;
import com.scudata.ide.common.DataSource;
import com.scudata.ide.common.DataSourceListModel;
import com.scudata.ide.common.FileChooserUICN;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IDialogDimensionListener;
import com.scudata.ide.common.IPrjxSheet;
import com.scudata.ide.common.ImageFileView;
import com.scudata.ide.common.XMLFile;
import com.scudata.ide.common.dialog.DialogInputText;
import com.scudata.ide.common.dialog.DialogMaxmizable;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.AllPurposeEditor;
import com.scudata.ide.common.swing.AllPurposeRenderer;
import com.scudata.ide.common.swing.DateChooser;
import com.scudata.ide.common.swing.JComboBoxEx;
import com.scudata.ide.common.swing.JOptionPaneEx;
import com.scudata.ide.common.swing.JTableEx;
import com.scudata.ide.common.swing.RQTextArea;
import com.scudata.ide.spl.GMSpl;
import com.scudata.util.CellSetUtil;
import com.scudata.util.Variant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GM
extends GMBase {
    public static final byte B_OPEN = 0;
    public static final byte B_ADD = 1;
    public static final byte B_DEL = 2;
    public static final byte B_UP = 3;
    public static final byte B_DOWN = 4;
    public static final byte B_COPY = 5;
    public static final byte B_PASTE = 6;
    public static String saveAsExt = null;
    private static IDialogDimensionListener iDDListener = null;
    private static final String STRING_DIMENSION = ".dimension";
    private static boolean canPaste = false;
    private static Map<KeyStroke, String> customKeyTexts = new HashMap<KeyStroke, String>();
    private static final String NAME_ANY_WHERE = "anywhere";
    private static final int MAX_COLUMN = 999;
    private static final String[] STR_COLID;
    public static HashMap<Integer, Font> fontMap;

    static {
        HashMap<KeyStroke, String> customKeyTexts = new HashMap<KeyStroke, String>();
        customKeyTexts.put(KeyStroke.getKeyStroke(47, 0), "/");
        customKeyTexts.put(KeyStroke.getKeyStroke(38, 0), "Up");
        customKeyTexts.put(KeyStroke.getKeyStroke(40, 0), "Down");
        customKeyTexts.put(KeyStroke.getKeyStroke(37, 0), "Left");
        customKeyTexts.put(KeyStroke.getKeyStroke(39, 0), "Right");
        STR_COLID = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        fontMap = new HashMap();
    }

    public static void setMacOSDockIcon(Image image) throws Exception {
        if (image == null) {
            return;
        }
        Class<?> clz = Class.forName("com.apple.eawt.Application");
        Method m = clz.getMethod("getApplication", new Class[0]);
        Object obj = m.invoke(null, new Object[0]);
        m = clz.getMethod("setDockIconImage", Image.class);
        m.invoke(obj, image);
    }

    public static long setBitByPos(long value, byte pos, boolean enabled) {
        value = enabled ? (value |= 1L << pos) : (value &= 1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
        return value;
    }

    public static boolean getBitByPos(long value, byte pos) {
        return (value & 1L << pos) != 0L;
    }

    public static String getDispText(byte codeKey, Vector code, Vector disp) {
        int i = 0;
        while (i < code.size()) {
            byte codeVal = (Byte)code.get(i);
            if (codeKey == codeVal) {
                return (String)disp.get(i);
            }
            ++i;
        }
        return "";
    }

    public static Object getOptionTrimChar0Value(Object val) {
        if (!ConfigOptions.bAutoTrimChar0.booleanValue()) {
            return val;
        }
        if (val != null && val instanceof String) {
            val = GM.getOptionTrimChar0String((String)val);
        }
        return val;
    }

    public static String getOptionTrimChar0String(String str) {
        if (!ConfigOptions.bAutoTrimChar0.booleanValue()) {
            return str;
        }
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.charAt(str.length() - 1) == '\u0000') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String renderValueText(Object val) {
        if (val == null) {
            return "";
        }
        if (val instanceof byte[]) {
            return "(blob)";
        }
        try {
            return GM.renderText(val);
        }
        catch (Exception x) {
            return "Error#" + x.getMessage();
        }
    }

    private static String renderText(Object val) {
        String dispText;
        if (val == null) {
            return "";
        }
        if (val instanceof Sequence) {
            Sequence s = (Sequence)val;
            int c = Math.min(s.length(), ConfigOptions.iSequenceDispMembers);
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            int i = 1;
            while (i <= c) {
                if (i > 1) {
                    sb.append(",");
                }
                Object v = s.get(i);
                sb.append(GM.renderText(v));
                ++i;
            }
            if (s.length() > ConfigOptions.iSequenceDispMembers) {
                sb.append(", ...");
            }
            sb.append("]");
            dispText = sb.toString();
        } else {
            if (val instanceof BaseRecord) {
                BaseRecord r = (BaseRecord)val;
                return GM.renderText(r.value());
            }
            dispText = Variant.toString(val);
        }
        return dispText;
    }

    public static String getRecordDispName(BaseRecord r, Context context) {
        int[] mkIndex = r.dataStruct().getPKIndex();
        if (mkIndex == null || mkIndex.length == 0) {
            int fieldCount = r.dataStruct().getFieldCount();
            if (fieldCount == 0) {
                return null;
            }
            Object temp = r.getFieldValue(0);
            if (temp == null) {
                return null;
            }
            if (temp instanceof BaseRecord) {
                return GM.getRecordDispName((BaseRecord)temp, context);
            }
            return GM.renderValueText(temp);
        }
        String dispName = "";
        int i = 0;
        while (i < mkIndex.length) {
            Object temp = r.getFieldValue(mkIndex[i]);
            if (temp != null) {
                if (StringUtils.isValidString(dispName)) {
                    dispName = String.valueOf(dispName) + ",";
                }
                dispName = temp instanceof BaseRecord ? String.valueOf(dispName) + GM.getRecordDispName((BaseRecord)temp, context) : String.valueOf(dispName) + GM.renderValueText(temp);
            }
            ++i;
        }
        return dispName;
    }

    public static byte getOperationSytem() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") > -1) {
            return 0;
        }
        if (osName.indexOf("mac") > -1) {
            return 1;
        }
        return 2;
    }

    public static boolean isWindowsOS() {
        return GM.getOperationSytem() == 0;
    }

    public static boolean isMacOS() {
        return GM.getOperationSytem() == 1;
    }

    public static boolean isChineseLanguage() {
        Locale local = Locale.getDefault();
        return "zh".equalsIgnoreCase(local.getLanguage());
    }

    public static FileFilter getFileFilter(final String[] extNames, final String desc) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                if (f.isDirectory()) {
                    return true;
                }
                String[] stringArray = extNames;
                int n = extNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String extName = stringArray[n2];
                    if (s.endsWith(extName)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return desc;
            }
        };
    }

    public static Vector<String> getActiveDSNames() {
        DataSourceListModel dsList = GV.dsModel;
        Vector<String> names = dsList.listNames();
        Vector<String> actives = new Vector<String>();
        int i = 0;
        while (i < names.size()) {
            DataSource ds = dsList.getDataSource(names.get(i));
            if (!ds.isClosed()) {
                actives.add(ds.getName());
            }
            ++i;
        }
        return actives;
    }

    public static JButton getCommonIconButton(byte type) {
        String sIcon;
        String tip;
        switch (type) {
            case 0: {
                tip = IdeCommonMessage.get().getMessage("gm.open");
                sIcon = "m_open.gif";
                break;
            }
            case 1: {
                tip = IdeCommonMessage.get().getMessage("gm.add");
                sIcon = "m_addrecord.gif";
                break;
            }
            case 2: {
                tip = IdeCommonMessage.get().getMessage("gm.delete");
                sIcon = "m_deleterecord.gif";
                break;
            }
            case 3: {
                tip = IdeCommonMessage.get().getMessage("gm.rowup");
                sIcon = "m_shiftup.gif";
                break;
            }
            case 4: {
                tip = IdeCommonMessage.get().getMessage("gm.rowdown");
                sIcon = "m_shiftdown.gif";
                break;
            }
            case 5: {
                tip = IdeCommonMessage.get().getMessage("gm.copy");
                sIcon = "m_copy.gif";
                break;
            }
            case 6: {
                tip = IdeCommonMessage.get().getMessage("gm.paste");
                sIcon = "m_paste.gif";
                break;
            }
            default: {
                return null;
            }
        }
        return GM.getIconButton(null, tip, sIcon);
    }

    public static JButton getIconButton(String text, String tip, String iconName) {
        JButton b = new JButton(GM.getImageIcon("/com/scudata/ide/common/resources/" + iconName));
        b.setToolTipText(tip);
        Dimension d = new Dimension(24, 24);
        b.setMinimumSize(d);
        b.setMaximumSize(d);
        b.setPreferredSize(d);
        b.setOpaque(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        return b;
    }

    public static File dialogSelectFile(String fileExts) {
        return GM.dialogSelectFile(GV.appFrame, fileExts);
    }

    public static File dialogSelectFile(Component parent, String fileExts) {
        return GM.dialogSelectFile(parent, fileExts, true);
    }

    public static File dialogSelectFile(Component parent, String fileExts, boolean useAllFileFilter) {
        return (File)GM.dialogSelectFiles(parent, fileExts, GV.lastDirectory, "", null, false, null, useAllFileFilter);
    }

    public static File dialogSelectFile(Component parent, String fileExts, boolean useAllFileFilter, String oldFileName) {
        return GM.dialogSelectFile(parent, fileExts, GV.lastDirectory, "", oldFileName, useAllFileFilter);
    }

    public static File dialogSelectFile(Component parent, String fileExts, boolean useAllFileFilter, Image image) {
        return (File)GM.dialogSelectFiles(parent, fileExts, GV.lastDirectory, "", null, false, null, useAllFileFilter, image);
    }

    public static File dialogSelectFile(Component parent, String fileExts, String currentDirectory, String title, String oldFileName) {
        return GM.dialogSelectFile(parent, fileExts, currentDirectory, title, oldFileName, true);
    }

    public static File dialogSelectFile(Component parent, String fileExts, String currentDirectory, String title, String oldFileName, boolean useAllFileFilter) {
        return (File)GM.dialogSelectFiles(parent, fileExts, currentDirectory, title, new File(oldFileName), false, null, useAllFileFilter);
    }

    public static File[] dialogSelectFiles(Component parent, String fileExts) {
        return GM.dialogSelectFiles(parent, fileExts, GV.lastDirectory, "", null);
    }

    public static File[] dialogSelectFiles(Component parent, String fileExts, Image image) {
        return (File[])GM.dialogSelectFiles(parent, fileExts, GV.lastDirectory, "", null, true, null, true, image);
    }

    public static File[] dialogSelectFiles(Component parent, String fileExts, String currentDirectory, String title, File[] oldFiles) {
        return (File[])GM.dialogSelectFiles(parent, fileExts, currentDirectory, title, oldFiles, true, null);
    }

    public static Object dialogSelectFiles(Component parent, String fileExts, String currentDirectory, String buttonText, Object oldFiles, boolean multiSelect, String dialogTitle) {
        return GM.dialogSelectFiles(parent, fileExts, currentDirectory, buttonText, oldFiles, multiSelect, null, true);
    }

    public static Object dialogSelectFiles(Component parent, String fileExts, String currentDirectory, String buttonText, Object oldFiles, boolean multiSelect, String dialogTitle, boolean useAllFileFilter) {
        return GM.dialogSelectFiles(parent, fileExts, currentDirectory, buttonText, oldFiles, multiSelect, dialogTitle, useAllFileFilter, null);
    }

    public static Object dialogSelectFiles(Component parentComponent, String fileExts, String currentDirectory, String buttonText, Object oldFiles, boolean multiSelect, String dialogTitle, boolean useAllFileFilter, final Image image) {
        int r;
        Component parent;
        String[] extArr;
        if (currentDirectory == null) {
            currentDirectory = GV.lastDirectory;
        }
        if (fileExts == null) {
            fileExts = "";
        }
        fileExts = fileExts.toLowerCase();
        JFileChooser chooser = new JFileChooser(currentDirectory){
            private static final long serialVersionUID = 1L;

            @Override
            protected void setUI(ComponentUI newUI) {
                super.setUI(new FileChooserUICN(this));
            }

            @Override
            public JDialog createDialog(Component parent) throws HeadlessException {
                boolean supportsWindowDecorations;
                String title = this.getUI().getDialogTitle(this);
                this.putClientProperty("AccessibleDescription", title);
                Window window = JOptionPaneEx.getJWindowForComponent(parent);
                JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
                if (image != null) {
                    dialog.setIconImage(image);
                }
                dialog.setComponentOrientation(this.getComponentOrientation());
                Container contentPane = dialog.getContentPane();
                contentPane.setLayout(new BorderLayout());
                contentPane.add((Component)this, "Center");
                if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                    dialog.getRootPane().setWindowDecorationStyle(6);
                }
                dialog.pack();
                dialog.setLocationRelativeTo(parent);
                if (parent != null && !(parent instanceof AppFrame) && GM.isMacOS()) {
                    dialog.setAlwaysOnTop(true);
                }
                return dialog;
            }
        };
        chooser.setFileView(new ImageFileView());
        chooser.setMultiSelectionEnabled(multiSelect);
        chooser.setAcceptAllFileFilterUsed(useAllFileFilter);
        chooser.setFileSelectionMode(0);
        boolean isMuiltExts = false;
        if (fileExts.startsWith("\"") && fileExts.endsWith("\"")) {
            String ext = fileExts.substring(1, fileExts.length() - 1);
            extArr = new String[]{ext};
            isMuiltExts = ext.split(",").length > 1;
        } else {
            File oldFile;
            extArr = fileExts.split(",");
            String firstExt = saveAsExt;
            if (firstExt != null) {
                int i = 0;
                while (i < extArr.length) {
                    String ext = extArr[i];
                    if (firstExt.equals(ext)) {
                        extArr[i] = extArr[0];
                        extArr[0] = ext;
                        break;
                    }
                    ++i;
                }
            } else if (!multiSelect && extArr.length > 1 && oldFiles != null && (oldFile = (File)oldFiles) != null) {
                int i = 0;
                while (i < extArr.length) {
                    String ext = extArr[i];
                    if (oldFile.getName().toLowerCase().endsWith("." + ext)) {
                        extArr[i] = extArr[0];
                        extArr[0] = ext;
                        break;
                    }
                    ++i;
                }
            }
        }
        saveAsExt = null;
        int i = extArr.length - 1;
        while (i >= 0) {
            String ext = extArr[i];
            if (StringUtils.isValidString(ext)) {
                String[] exts = ext.split(",");
                StringBuffer desc = new StringBuffer();
                int j = 0;
                while (j < exts.length) {
                    exts[j] = "." + exts[j];
                    if (desc.length() > 0) {
                        desc.append(",");
                    }
                    desc.append("*" + exts[j]);
                    ++j;
                }
                chooser.setFileFilter(GM.getFileFilter(exts, desc.toString()));
            }
            --i;
        }
        if (multiSelect) {
            if (oldFiles != null) {
                chooser.setSelectedFiles((File[])oldFiles);
            }
        } else {
            chooser.setSelectedFile((File)oldFiles);
        }
        if (StringUtils.isValidString(dialogTitle)) {
            chooser.setDialogTitle(dialogTitle);
        }
        if ((parent = parentComponent) == null) {
            if (GV.appFrame != null) {
                parent = GV.appFrame;
            } else {
                parent = new JFrame();
                try {
                    ImageIcon ii = GM.getLogoImage(false);
                    if (ii != null && ii.getImage() != null) {
                        ((JFrame)parent).setIconImage(ii.getImage());
                    }
                }
                catch (Throwable ii) {
                    // empty catch block
                }
            }
        }
        if ((r = StringUtils.isValidString(buttonText) ? chooser.showDialog(parent, buttonText) : chooser.showOpenDialog(parent)) == 0) {
            boolean fileHasExt;
            GV.lastDirectory = chooser.getSelectedFile().getParent();
            if (multiSelect) {
                return chooser.getSelectedFiles();
            }
            String fileExt = chooser.getFileFilter().getDescription();
            int dot = fileExt.lastIndexOf(".");
            fileExt = dot < 0 ? "" : fileExt.substring(dot);
            String path = chooser.getSelectedFile().getAbsolutePath();
            if (!isMuiltExts && !(fileHasExt = path.toLowerCase().endsWith(fileExt)) && fileExt.startsWith(".")) {
                File fWithExt = new File(String.valueOf(path) + fileExt);
                return fWithExt;
            }
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static String dialogSelectDate(Component parent, String initDate) {
        String val = null;
        DateChooser dc = parent instanceof Dialog ? new DateChooser((Dialog)parent, true) : new DateChooser((Frame)parent, true);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        GM.centerWindow(dc);
        try {
            val = initDate;
            cal.setTime(formatter.parse(val));
            dc.initDate(cal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dc.setVisible(true);
        cal = dc.getSelectedDate();
        val = cal == null ? null : formatter.format(cal.getTime());
        return val;
    }

    public static String dialogSelectDirectory(Component parent, String currentDirectory) {
        return GM.dialogSelectDirectory(parent, currentDirectory, null, null);
    }

    public static String dialogSelectDirectory(Component parent, String currentDirectory, String buttonText, String title) {
        JFileChooser chooser = new JFileChooser(currentDirectory);
        chooser.setFileSelectionMode(1);
        try {
            GM.resetFileNameLabel(chooser);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (StringUtils.isValidString(buttonText)) {
            chooser.setApproveButtonText(buttonText);
        }
        if (StringUtils.isValidString(title)) {
            chooser.setDialogTitle(title);
        }
        if (chooser.showOpenDialog(parent) == 0) {
            GV.lastDirectory = chooser.getSelectedFile().getAbsolutePath();
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static void setDialogDimensionListener(IDialogDimensionListener listener) {
        iDDListener = listener;
    }

    public static void setWindowDimension(Component dlg) {
        if (iDDListener != null) {
            iDDListener.saveWindowDimension(dlg);
            return;
        }
        if (ConfigOptions.bWindowSize.booleanValue()) {
            try {
                ConfigFile cf = ConfigFile.getConfigFile();
                if (cf != null) {
                    String oldNode = cf.getConfigNode();
                    Dimension d = dlg.getSize();
                    cf.setConfigNode(ConfigFile.NODE_DIMENSION);
                    String nodeName = String.valueOf(dlg.getClass().getName()) + STRING_DIMENSION;
                    String nodeValue = String.valueOf(d.width) + "," + d.height + "," + dlg.getX() + "," + dlg.getY();
                    nodeName = GM.removeXmlKeyWords(nodeName);
                    nodeValue = GM.removeXmlKeyWords(nodeValue);
                    cf.setAttrValue(nodeName, nodeValue);
                    cf.setConfigNode(oldNode);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String removeXmlKeyWords(String str) {
        str = str.replaceAll("\\$", "");
        str = str.replaceAll("&", "");
        str = str.replaceAll("<", "");
        str = str.replaceAll(">", "");
        str = str.replaceAll("'", "");
        str = str.replaceAll("\"", "");
        return str;
    }

    public static void centerWindow(Component w) {
        boolean b = GM.loadWindowSize(w);
        if (!b) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension winSize = w.getSize();
            if (winSize.height > screenSize.height) {
                winSize.height = screenSize.height;
            }
            if (winSize.width > screenSize.width) {
                winSize.width = screenSize.width;
            }
            w.setLocation((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2);
        }
    }

    public static boolean loadWindowSize(Component jc) {
        if (iDDListener != null) {
            return iDDListener.loadWindowDimension(jc);
        }
        String str = String.valueOf(jc.getClass().getName()) + STRING_DIMENSION;
        str = GM.removeXmlKeyWords(str);
        boolean b = false;
        try {
            ConfigFile cf;
            if (ConfigOptions.bWindowSize.booleanValue() && (cf = ConfigFile.getConfigFile()) != null) {
                String oldNode = cf.getConfigNode();
                cf.setConfigNode(ConfigFile.NODE_DIMENSION);
                String dimension = cf.getAttrValue(str);
                if (StringUtils.isValidString(dimension)) {
                    dimension = GM.removeXmlKeyWords(dimension);
                    Section s = new Section(dimension);
                    String[] size = s.toStringArray();
                    jc.setSize(Integer.parseInt(size[0]), Integer.parseInt(size[1]));
                    jc.setLocation(Integer.parseInt(size[2]), Integer.parseInt(size[3]));
                    b = true;
                }
                cf.setConfigNode(oldNode);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return b;
    }

    public static void mixpanel() {
        try {
            MessageBuilder messageBuilder = new MessageBuilder("aa81d647e91020b8aaad6dcfc824479a");
            JSONObject props = new JSONObject();
            props.put("mp_country_code", (Object)Locale.getDefault().getCountry());
            props.put("Language", (Object)Locale.getDefault().getLanguage());
            JSONObject newLogin = messageBuilder.event(UUID.randomUUID().toString(), "login", props);
            ClientDelivery delivery = new ClientDelivery();
            delivery.addMessage(newLogin);
            MixpanelAPI mixpanel = new MixpanelAPI();
            mixpanel.deliver(delivery);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void saveValueColInfo(String colName, ValueColInfo colInfo) {
        ConfigFile cf = null;
        try {
            cf = ConfigFile.getConfigFile();
            String oldNode = cf.getConfigNode();
            XMLFile xml = cf.xmlFile();
            if (!xml.isPathExists(ConfigFile.NODE_FORMAT)) {
                xml.newElement("RAQSOFT", ConfigFile.NODE_FORMAT);
            }
            if (!xml.isPathExists(ConfigFile.NODE_COL_WIDHT)) {
                xml.newElement("RAQSOFT", ConfigFile.NODE_COL_WIDHT);
            }
            cf.setConfigNode(ConfigFile.NODE_FORMAT);
            if (StringUtils.isValidString(colInfo.format)) {
                cf.setAttrValue(colName, colInfo.format);
            } else {
                cf.setAttrValue(colName, "");
            }
            cf.setConfigNode(ConfigFile.NODE_COL_WIDHT);
            cf.setAttrValue(colName, colInfo.colWidth);
            cf.setConfigNode(oldNode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ValueColInfo getValueColInfo(String colName) {
        if (colName == null) {
            return null;
        }
        try {
            String format;
            ValueColInfo colInfo = new ValueColInfo();
            ConfigFile cf = ConfigFile.getConfigFile();
            String oldNode = cf.getConfigNode();
            cf.setConfigNode(ConfigFile.NODE_FORMAT);
            colInfo.format = format = cf.getAttrValue(colName);
            cf.setConfigNode(ConfigFile.NODE_COL_WIDHT);
            String sColWidth = cf.getAttrValue(colName);
            try {
                int colWidth;
                colInfo.colWidth = colWidth = Integer.parseInt(sColWidth);
            }
            catch (Exception exception) {
                // empty catch block
            }
            cf.setConfigNode(oldNode);
            return colInfo;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void resetFileNameLabel(Container p) {
        int cc = p.getComponentCount();
        int i = 0;
        while (i < cc) {
            Component c = p.getComponent(i);
            if (c instanceof JLabel) {
                String text = ((JLabel)c).getText();
                if (!StringUtils.isValidString(text)) {
                    Dimension size = c.getPreferredSize();
                    if (size.getHeight() < 21.0) {
                        size.setSize(size.getWidth(), 21.0);
                    }
                    ((JLabel)c).setText(IdeCommonMessage.get().getMessage("gm.labelfoldername"));
                    c.setPreferredSize(size);
                } else {
                    String labelFileName = IdeCommonMessage.get().getMessage("gm.labelfilename");
                    String labelFolderName = IdeCommonMessage.get().getMessage("gm.labelfoldername");
                    String fileNamePre = labelFileName.substring(0, labelFileName.length() - 1).toLowerCase();
                    String folderNamePre = labelFolderName.substring(0, labelFolderName.length() - 1).toLowerCase();
                    if (text.toLowerCase().startsWith(fileNamePre) || text.toLowerCase().startsWith(folderNamePre)) {
                        JLabel newLabel = new JLabel(labelFolderName);
                        newLabel.setPreferredSize(c.getPreferredSize());
                        p.remove(c);
                        p.add((Component)newLabel, i);
                        return;
                    }
                }
            } else if (c instanceof Container) {
                GM.resetFileNameLabel((Container)c);
            }
            ++i;
        }
    }

    public static void resetClipBoard() {
        canPaste = StringUtils.isValidString(GM.clipBoard(false));
    }

    public static boolean canPaste() {
        if (GV.cellSelection != null) {
            return true;
        }
        return canPaste;
    }

    public static void clipBoard(String data) {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection ss = new StringSelection(data);
            clip.setContents(ss, null);
            canPaste = StringUtils.isValidString(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String clipBoard() {
        return GM.clipBoard(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String clipBoard(boolean caseHtml) {
        DataFlavor[] dfs;
        Transferable tf;
        block4: {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            tf = clip.getContents(null);
            if (!caseHtml) return (String)tf.getTransferData(DataFlavor.stringFlavor);
            dfs = tf.getTransferDataFlavors();
            if (dfs != null) break block4;
            return "";
        }
        try {
            Object obj = null;
            int i = 0;
            while (i < dfs.length) {
                String mineType = dfs[i].getMimeType();
                if (mineType.indexOf("text/html") > -1 && StringUtils.isValidString(obj = tf.getTransferData(dfs[i]))) break;
                ++i;
            }
            if (!StringUtils.isValidString(obj)) return (String)tf.getTransferData(DataFlavor.stringFlavor);
            String htmlStr = (String)obj;
            if (!GM.isHtmlString(htmlStr)) return (String)tf.getTransferData(DataFlavor.stringFlavor);
            return htmlStr;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static byte[] inputStream2Bytes(InputStream is) throws Exception {
        if (is == null) {
            return new byte[0];
        }
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int totalBytes = 0;
        byte[] b = new byte[102400];
        int readBytes = 0;
        while ((readBytes = is.read(b)) > 0) {
            byte[] bb = new byte[readBytes];
            System.arraycopy(b, 0, bb, 0, readBytes);
            al.add(bb);
            totalBytes += readBytes;
        }
        b = new byte[totalBytes];
        int pos = 0;
        int i = 0;
        while (i < al.size()) {
            byte[] bb = (byte[])al.get(i);
            System.arraycopy(bb, 0, b, pos, bb.length);
            pos += bb.length;
            ++i;
        }
        return b;
    }

    public static ImageIcon getImageIcon(String filePath) {
        return GM.getImageIcon(filePath, true);
    }

    public static ImageIcon getImageIcon(Component parent, String filePath) {
        return GM.getImageIcon(parent, filePath, true);
    }

    public static ImageIcon getImageIcon(String filePath, boolean showException) {
        return GM.getImageIcon(GV.appFrame, filePath, showException);
    }

    public static ImageIcon getImageIcon(Component parent, String filePath, boolean showException) {
        try {
            File f = new File(filePath);
            InputStream is = null;
            if (f.exists()) {
                is = new FileInputStream(f);
            } else {
                if (!(filePath = Sentence.replace(filePath, "\\", "/", 0)).startsWith("/")) {
                    filePath = "/" + filePath;
                }
                if ((is = GM.class.getResourceAsStream(filePath)) == null) {
                    is = GM.class.getResourceAsStream(filePath.toLowerCase());
                }
            }
            if (is == null) {
                throw new Exception("Get image file: " + filePath + " failure!");
            }
            byte[] bt = GM.inputStream2Bytes(is);
            ((InputStream)is).close();
            return new ImageIcon(bt);
        }
        catch (Exception e) {
            if (showException) {
                GM.showException(parent, e);
            }
            return null;
        }
    }

    public static void showException(Object oMsg) {
        GM.showException(GV.appFrame, oMsg);
    }

    public static void showException(Component parent, Object oMsg) {
        GM.showException(parent, oMsg, true);
    }

    public static void showException(Component parent, Object oMsg, boolean canCopyMsg) {
        GM.showException(parent, oMsg, canCopyMsg, null);
    }

    public static void showException(Component parent, Object oMsg, boolean canCopyMsg, ImageIcon logo) {
        GM.showException(parent, oMsg, canCopyMsg, logo, null);
    }

    public static void showException(Component parent, Object oMsg, boolean canCopyMsg, ImageIcon logo, String pre) {
        String msg;
        Throwable e = null;
        if (oMsg instanceof Throwable) {
            Throwable cause;
            e = (Throwable)oMsg;
            if (e != null) {
                if (e instanceof ThreadDeath) {
                    return;
                }
                cause = e.getCause();
                int i = 0;
                while (cause != null) {
                    if (cause instanceof ThreadDeath) {
                        return;
                    }
                    cause = cause.getCause();
                    if (++i > 10) break;
                }
            }
            msg = !StringUtils.isValidString(e.getMessage()) ? e.toString() : e.getMessage();
            cause = e.getCause();
            if (cause != null) {
                if (StringUtils.isValidString(cause.getMessage())) {
                    if (msg.indexOf(cause.getMessage()) < 0) {
                        msg = String.valueOf(msg) + GM.getLineSeparator() + cause.getMessage();
                    }
                } else if ((cause = cause.getCause()) != null && StringUtils.isValidString(cause.getMessage()) && msg.indexOf(cause.getMessage()) < 0) {
                    msg = String.valueOf(msg) + GM.getLineSeparator() + cause.getMessage();
                }
            }
        } else {
            String string = msg = oMsg == null ? null : oMsg.toString();
        }
        if (pre != null) {
            msg = String.valueOf(pre) + "\n" + msg;
        }
        if (parent == null || !(parent instanceof Dialog) && !(parent instanceof Frame)) {
            parent = GV.appFrame;
        }
        if (canCopyMsg) {
            DialogInputText dit = parent instanceof Dialog ? new DialogInputText((Dialog)parent, IdeCommonMessage.get().getMessage("gm.errorprompt"), false) : new DialogInputText((Frame)parent, IdeCommonMessage.get().getMessage("gm.errorprompt"), false);
            dit.setText(msg);
            dit.setMessageMode();
            if (logo != null) {
                dit.setIconImage(logo.getImage());
            }
            if (GM.isMacOS()) {
                dit.setAlwaysOnTop(true);
            }
            dit.setVisible(true);
        } else {
            GM.messageDialog(parent, msg, IdeCommonMessage.get().getMessage("gm.errorprompt"), 1);
        }
        GM.writeLog(e != null ? e : msg);
    }

    public static void writeLog(Object e) {
        if (e == null) {
            return;
        }
        Logger.error(e);
    }

    public static void outputMessage(Object e) {
        GM.writeLog(e);
    }

    private static Object extractMenuObject(Object menu, String str, short type) {
        Accessible tmpItem;
        Accessible sItem;
        int i;
        int c;
        Accessible pMenu;
        String sTmp = "";
        if (menu instanceof Menu) {
            pMenu = (Menu)menu;
            c = ((Menu)pMenu).getItemCount();
            i = 0;
            while (i < c) {
                sItem = ((Menu)pMenu).getItem(i);
                if (sItem != null) {
                    if (sItem instanceof Menu && (tmpItem = (MenuItem)GM.extractMenuObject(sItem, str, type)) != null) {
                        return tmpItem;
                    }
                    if (type == 0) {
                        sTmp = ((MenuComponent)((Object)sItem)).getName();
                    } else if (type == 2) {
                        sTmp = ((MenuItem)sItem).getLabel();
                    }
                    if (sTmp != null && sTmp.equalsIgnoreCase(str)) {
                        return sItem;
                    }
                }
                ++i;
            }
        }
        if (menu instanceof JMenu) {
            pMenu = (JMenu)menu;
            c = ((JMenu)pMenu).getItemCount();
            i = 0;
            while (i < c) {
                sItem = ((JMenu)pMenu).getItem(i);
                if (sItem != null) {
                    if (sItem instanceof JMenu && (tmpItem = (JMenuItem)GM.extractMenuObject(sItem, str, type)) != null) {
                        return tmpItem;
                    }
                    if (type == 0) {
                        sTmp = ((Component)((Object)sItem)).getName();
                    } else if (type == 1) {
                        sTmp = ((AbstractButton)((Object)sItem)).getText();
                    }
                    if (sTmp != null && sTmp.equalsIgnoreCase(str)) {
                        return sItem;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static JMenuItem findMenuItem(JMenuBar menuBar, String str, short searchType) {
        int c = menuBar.getMenuCount();
        int i = 0;
        while (i < c) {
            JMenuItem sItem = (JMenuItem)GM.extractMenuObject(menuBar.getMenu(i), str, searchType);
            if (sItem != null) {
                return sItem;
            }
            ++i;
        }
        return null;
    }

    public static JMenuItem getMenuByName(JMenuBar menuBar, String name) {
        return GM.findMenuItem(menuBar, name, (short)0);
    }

    public static JMenuItem getMenuByText(JMenuBar menuBar, String text) {
        return GM.findMenuItem(menuBar, text, (short)1);
    }

    public static void setWindowToolSize(Window w) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        w.setSize((int)(d.getWidth() * 0.75), (int)(d.getHeight() * 0.75));
    }

    public static void setDialogDefaultButton(Window dlg, JButton okButton, final JButton cancelButton) {
        JRootPane pane = null;
        if (dlg instanceof DialogMaxmizable) {
            pane = ((JDialog)dlg).getRootPane();
            DialogMaxmizable dm = (DialogMaxmizable)dlg;
            dm.oldSize = dm.getSize();
            dlg.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DialogMaxmizable f = (DialogMaxmizable)e.getSource();
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        if (f.isMaxized) {
                            f.setSize(f.oldSize);
                            int newX = (screenSize.width - f.oldSize.width) / 2;
                            int newY = (screenSize.height - f.oldSize.height) / 2;
                            f.setLocation(newX, newY);
                            f.isMaxized = false;
                        } else {
                            f.setLocation(0, 0);
                            f.setSize(screenSize);
                            f.isMaxized = true;
                        }
                    }
                }
            });
        } else if (dlg instanceof JDialog) {
            pane = ((JDialog)dlg).getRootPane();
            ((JDialog)dlg).setResizable(true);
        } else if (dlg instanceof JFrame) {
            pane = ((JFrame)dlg).getRootPane();
        } else {
            return;
        }
        pane.setDefaultButton(okButton);
        okButton.requestFocus();
        AbstractAction cancelAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                cancelButton.doClick();
            }
        };
        String o = new String("esc");
        pane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), o);
        pane.getActionMap().put(o, cancelAction);
        dlg.setSize(dlg.getWidth() + 10, dlg.getHeight() + 10);
        GM.centerWindow(dlg);
    }

    public static String[] getFontNames() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getAvailableFontFamilyNames(GV.language);
    }

    public static JComboBoxEx getFontSizes() {
        JComboBoxEx combo = new JComboBoxEx();
        Section ss = new Section(GC.FONTSIZECODE);
        Vector code = ss.toVector();
        if (GV.language.equals(Locale.CHINA) || GV.language.equals(Locale.CHINESE) || GC.LANGUAGE == 0) {
            ss = new Section(GC.FONTSIZEDISP);
        } else {
            ss = new Section();
            int i = 0;
            while (i < code.size()) {
                ss.addSection(code.get(i).toString());
                ++i;
            }
        }
        Vector disp = ss.toVector();
        combo.x_setData(code, disp);
        return combo;
    }

    public static boolean dialogEditTableText(Component parent, JTableEx table, int r, int c) {
        DefaultCellEditor editor;
        Component cp;
        TableCellEditor o = table.getCellEditor(r, c);
        if (o instanceof DefaultCellEditor && (cp = (editor = (DefaultCellEditor)o).getComponent()) instanceof JCheckBox) {
            return false;
        }
        Object sData = table.getValueAt(r, c);
        try {
            sData = sData.toString();
        }
        catch (Exception ex) {
            sData = "";
        }
        if (parent == null) {
            parent = GV.appFrame;
        }
        DialogInputText dit = parent instanceof Dialog ? new DialogInputText((Dialog)parent, true) : new DialogInputText((Frame)parent, true);
        dit.setText(sData.toString());
        dit.setVisible(true);
        table.acceptText();
        if (dit.getOption() == 0) {
            table.setValueAt(dit.getText(), r, c);
            table.acceptText();
            return true;
        }
        return false;
    }

    public static String getTableUniqueName(JTableEx table, int column, String namePrefix) {
        int m;
        int r = 0;
        int t = table.getRowCount();
        block0: do {
            ++r;
            m = 0;
            while (m < t) {
                String tmpName = (String)table.getValueAt(m, column);
                if (tmpName != null && tmpName.equalsIgnoreCase(String.valueOf(namePrefix) + Integer.toString(r))) continue block0;
                ++m;
            }
        } while (m < t);
        m = r;
        return String.valueOf(namePrefix) + Integer.toString(m);
    }

    public static GridBagConstraints getGBC(int row, int col) {
        return GM.getGBC(row, col, false);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill) {
        return GM.getGBC(row, col, hFill, false);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill, boolean vFill) {
        return GM.getGBC(row, col, hFill, vFill, 8);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill, boolean vFill, int hGap) {
        return GM.getGBC(row, col, hFill, vFill, hGap, 3);
    }

    public static GridBagConstraints getGBC(int row, int col, boolean hFill, boolean vFill, int hGap, int vGap) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(vGap, hGap, vGap, hGap);
        gbc.fill = 2;
        if (hFill) {
            gbc.weightx = 1.0;
        }
        if (vFill) {
            gbc.fill = 1;
            gbc.weighty = 1.0;
        }
        return gbc;
    }

    public static boolean canSaveAsFile(String saveAsFile) {
        return GM.canSaveAsFile(GV.appFrame, saveAsFile);
    }

    public static boolean canSaveAsFile(Component parent, String saveAsFile) {
        int r;
        if (!StringUtils.isValidString(saveAsFile)) {
            GM.messageDialog(parent, IdeCommonMessage.get().getMessage("gm.inputfilename"));
            return false;
        }
        File saveFile = new File(saveAsFile);
        return !saveFile.exists() || (r = GM.optionDialog(parent, IdeCommonMessage.get().getMessage("gm.existfile", saveAsFile), IdeCommonMessage.get().getMessage("public.note"), 2)) == 0;
    }

    public static ImageIcon getMenuImageIcon(String menuId) {
        int dot = menuId.indexOf(".");
        String iconText = dot > 0 ? menuId.substring(dot + 1) : menuId;
        String iconPath = "/com/scudata/ide/common/resources/m_" + iconText.toLowerCase() + ".gif";
        return GM.getImageIcon(iconPath);
    }

    public static void resetFrameTitle(String dsName, String userName) {
        for (AppFrame af : GV.allFrames) {
            String tmpTitle = af.resetTitle();
            if (StringUtils.isValidString(dsName)) {
                tmpTitle = String.valueOf(tmpTitle) + " - " + IdeCommonMessage.get().getMessage("gm.connect", dsName);
            }
            if (StringUtils.isValidString(userName)) {
                tmpTitle = String.valueOf(tmpTitle) + " - " + IdeCommonMessage.get().getMessage("gm.activeuser", userName);
            }
            af.setTitle(tmpTitle);
        }
    }

    public static ImageIcon getLogoImage(boolean isGetIcon) {
        return GM.getLogoImage(GV.appFrame, isGetIcon);
    }

    public static ImageIcon getLogoImage(Component parent, boolean isGetIcon) {
        String relativeFile = "logo";
        boolean isShowException = false;
        String pLogo = "logo.png";
        if (isGetIcon) {
            int lastDot = pLogo.lastIndexOf(".");
            pLogo = lastDot > -1 ? String.valueOf(pLogo.substring(0, lastDot)) + "_ico." + pLogo.substring(lastDot + 1) : String.valueOf(pLogo) + "_ico";
        }
        relativeFile = pLogo.startsWith("/") ? String.valueOf(relativeFile) + pLogo.toLowerCase() : String.valueOf(relativeFile) + "/" + pLogo.toLowerCase();
        String logoPath = GM.getAbsolutePath(relativeFile);
        File f = new File(logoPath);
        ImageIcon ii = null;
        if (f.exists()) {
            ii = new ImageIcon(logoPath);
        } else {
            InputStream is;
            if (isGetIcon && (is = GM.class.getResourceAsStream(relativeFile)) == null) {
                return GM.getLogoImage(parent, false);
            }
            ii = GM.getImageIcon(parent, relativeFile, isShowException);
        }
        return ii;
    }

    public static JMenu getMenuItem(String menuText, char mneKey, boolean isMainMenu) {
        JMenu mItem = new JMenu(menuText);
        if (!isMainMenu) {
            mItem.setIcon(GM.getMenuImageIcon("blank"));
        }
        if (StringUtils.isValidString(String.valueOf(mneKey))) {
            mItem.setMnemonic(mneKey);
        }
        return mItem;
    }

    public static JMenuItem getMenuItem(short cmdId, String menuId, char mneKey, int mask, boolean hasIcon, String menuText) {
        JMenuItem mItem = null;
        mItem = new JMenuItem(menuText, mneKey);
        mItem.setName(Short.toString(cmdId));
        if (hasIcon) {
            mItem.setIcon(GM.getMenuImageIcon(menuId));
        } else {
            mItem.setIcon(GM.getMenuImageIcon("blank"));
        }
        if (mask != 64) {
            if (GM.isMacOS()) {
                if ((mask & 2) == 2) {
                    mask = mask - 2 + 4;
                }
                if (mneKey == '\u007f') {
                    mneKey = (char)8;
                }
            }
            KeyStroke ks = KeyStroke.getKeyStroke((int)mneKey, mask);
            mItem.setAccelerator(ks);
        }
        return mItem;
    }

    public static String getRealSchema(Object schema) {
        if (!StringUtils.isValidString(schema)) {
            return null;
        }
        if (schema.equals(GC.SCHEMA_ALL)) {
            return null;
        }
        return (String)schema;
    }

    public static void loadSchemas(DataSource ds, JComboBox<String> cbSchema) {
        cbSchema.removeAllItems();
        if (ds == null) {
            cbSchema.addItem(GC.SCHEMA_ALL);
        } else {
            DBInfo dbInfo = ds.getDBInfo();
            String dbcs = dbInfo.getDBCharset();
            String ccs = dbInfo.getClientCharset();
            boolean convert = dbcs != null && !dbcs.equals(ccs);
            try {
                Vector<String> schemas = ds.listSchemas();
                int i = 0;
                while (i < schemas.size()) {
                    String schema = schemas.get(i);
                    if (convert) {
                        schema = GM.convertDBString(ds, schema);
                    }
                    cbSchema.addItem(schema);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cbSchema.addItem(GC.SCHEMA_ALL);
        }
    }

    public static Object handleDSException(DataSource ds, Throwable x) {
        boolean noClass = false;
        if (x instanceof ClassNotFoundException) {
            noClass = true;
        } else if (x instanceof SQLException && x.getMessage() != null && x.getMessage().equals("No suitable driver")) {
            noClass = true;
        }
        if (noClass) {
            StringBuffer msg = new StringBuffer();
            String errorMsg = DBTypeEx.getErrorMessage(ds.getName());
            msg.append("Class [");
            msg.append(((DBConfig)ds.getDBInfo()).getDriver());
            msg.append("] is not found.");
            if (errorMsg != null) {
                msg.append("\r\n");
                msg.append("\r\n");
                msg.append(errorMsg);
            }
            return msg.toString();
        }
        return x;
    }

    public static void resetEnvDataSource(DataSourceListModel dsModel) {
        GM.resetEnvDataSource(dsModel, GV.config);
    }

    public static void resetEnvDataSource(DataSourceListModel dsModel, RaqsoftConfig config) {
        Env.clearDBSessionFactories();
        if (dsModel != null) {
            ArrayList<DBConfig> dbList = new ArrayList<DBConfig>();
            config.setDBList(dbList);
            int i = 0;
            while (i < dsModel.size()) {
                DataSource ds = (DataSource)dsModel.get(i);
                try {
                    if (ds.isLocal()) {
                        dbList.add(new DBConfig((DBConfig)ds.getDBInfo()));
                    }
                    Env.setDBSessionFactory(ds.getName(), ds.getDBInfo().createSessionFactory());
                }
                catch (Throwable x) {
                    Logger.debug(x);
                }
                ++i;
            }
        } else if (config != null) {
            config.setDBList(null);
        }
    }

    public static Vector<String> listSchemaTables(DataSource ds, String schema, boolean showMsg) {
        return GM.listSchemaTables(GV.appFrame, ds, schema, showMsg);
    }

    public static Vector<String> listSchemaTables(Component parent, DataSource ds, String schema, boolean showMsg) {
        try {
            if (ds == null || ds.isOLAP()) {
                return new Vector<String>();
            }
            return GM.listTableNames(ds, false, schema, true);
        }
        catch (Throwable e) {
            if (showMsg) {
                GM.showException(parent, e);
            } else {
                Logger.debug(e);
            }
            return new Vector<String>();
        }
    }

    public static Vector<String> listTableNames(String dsName) {
        if (StringUtils.isValidString(dsName) && GV.dsModel != null) {
            DataSource ds;
            block4: {
                ds = GV.dsModel.getDataSource(dsName);
                if (ds != null && !ds.isClosed()) break block4;
                return null;
            }
            try {
                return GM.listTableNames(ds, false, null, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static Vector<String> listTableNames(DataSource ds, boolean showSystemTables, String schema, boolean schemaPrefix) throws Throwable {
        boolean convert;
        Vector<String> tableNames = new Vector<String>();
        DBSession session = ds.getDBSession();
        if (session.isClosed()) {
            return tableNames;
        }
        boolean addTilde = ds.getDBConfig().isAddTilde();
        Connection con = (Connection)session.getSession();
        DatabaseMetaData md = con.getMetaData();
        String[] types = null;
        types = showSystemTables ? new String[]{"TABLE", "BASE TABLE", "VIEW", "SYSTEM TABLE"} : new String[]{"TABLE", "BASE TABLE", "VIEW"};
        String catalog = con.getCatalog();
        String productName = md.getDatabaseProductName();
        if (productName != null && productName.toLowerCase().indexOf(NAME_ANY_WHERE) > -1) {
            catalog = null;
        }
        DBInfo dbInfo = ds.getDBInfo();
        String dbcs = dbInfo.getDBCharset();
        String ccs = dbInfo.getClientCharset();
        boolean bl = convert = dbcs != null && !dbcs.equals(ccs);
        if (convert) {
            catalog = GM.convertDBSearchString(ds, catalog);
            schema = GM.convertDBSearchString(ds, schema);
        }
        ResultSet rs = md.getTables(catalog, schema, null, types);
        String tilde = md.getIdentifierQuoteString();
        while (rs.next()) {
            String name;
            String schemaName;
            String tableName = rs.getString("TABLE_NAME");
            if (convert) {
                tableName = GM.convertDBString(ds, tableName);
            }
            if (ds.isUseSchema() && schemaPrefix) {
                schemaName = rs.getString("TABLE_SCHEM");
                if (convert) {
                    schemaName = GM.convertDBString(ds, schemaName);
                }
                name = addTilde ? String.valueOf(GM.tildeString(schemaName, tilde)) + "." + GM.tildeString(tableName, tilde) : String.valueOf(schemaName) + "." + tableName;
            } else {
                schemaName = null;
                name = addTilde ? GM.tildeString(tableName, tilde) : tableName;
            }
            tableNames.addElement(name);
        }
        rs.close();
        return tableNames;
    }

    public static String tildeString(String name, String tilde) {
        return String.valueOf(tilde) + name + tilde;
    }

    public static Vector<String> listColumnNames(String dsName, String tableName) {
        Vector<String> colNames = new Vector<String>();
        if (!StringUtils.isValidString(dsName) || !StringUtils.isValidString(tableName)) {
            return colNames;
        }
        try {
            DataSource ds = GV.dsModel.getDataSource(dsName);
            if (ds == null || ds.isClosed()) {
                return colNames;
            }
            String[] names = GM.listColumnNames(ds, null, tableName);
            if (names != null) {
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    colNames.add(name);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return colNames;
    }

    public static String[] listColumnNames(DataSource ds, String schema, String table) throws Throwable {
        return GM.listColumnInfo(ds, schema, table, "COLUMN_NAME");
    }

    private static String[] listColumnInfo(DataSource ds, String schema, String table, String columnName) throws Throwable {
        boolean convert;
        DBObject dbo = new DBObject(ds.getDBSession());
        Object session = dbo.getDbSession().getSession();
        if (!(session instanceof Connection) || ((Connection)session).isClosed()) {
            return null;
        }
        DBInfo dbInfo = ds.getDBInfo();
        String dbcs = dbInfo.getDBCharset();
        String ccs = dbInfo.getClientCharset();
        boolean bl = convert = dbcs != null && !dbcs.equals(ccs);
        if (convert) {
            schema = GM.convertDBSearchString(ds, schema);
            table = GM.convertDBSearchString(ds, table);
        }
        Connection con = (Connection)session;
        DatabaseMetaData md = con.getMetaData();
        String[] schemaTable = GM.getRealSchemaTable(con, schema, table);
        Section columnNames = new Section();
        try (ResultSet rs = null;){
            rs = md.getColumns(null, schemaTable[0], schemaTable[1], null);
            while (rs.next()) {
                String colName = rs.getString(columnName);
                if (convert) {
                    colName = GM.convertDBString(ds, colName);
                }
                columnNames.addSection(colName);
            }
        }
        return columnNames.toStringArray();
    }

    public static String convertDBSearchString(DataSource ds, String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        DBInfo dbInfo = ds.getDBInfo();
        if (!dbInfo.getNeedTranSentence()) {
            return str;
        }
        String dbcs = dbInfo.getDBCharset();
        String ccs = dbInfo.getClientCharset();
        return new String(str.getBytes(ccs), dbcs);
    }

    public static String convertDBString(DataSource ds, String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        DBInfo dbInfo = ds.getDBInfo();
        if (!dbInfo.getNeedTranContent()) {
            return str;
        }
        String dbcs = dbInfo.getDBCharset();
        String ccs = dbInfo.getClientCharset();
        return new String(str.getBytes(dbcs), ccs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getPrimaryKeys(Object dbName, Object tableName) {
        if (!StringUtils.isValidString(dbName)) {
            return null;
        }
        if (!StringUtils.isValidString(tableName)) {
            return null;
        }
        try {
            DataSource ds = GV.dsModel.getDataSource((String)dbName);
            if (ds != null && !ds.isClosed()) {
                DBObject dbo = new DBObject(ds.getDBSession());
                return GM.getPrimaryKeys(dbo, null, (String)tableName);
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String[] getPrimaryKeys(DBObject dbo, String schema, String table) throws Exception {
        Object session = dbo.getDbSession().getSession();
        if (!(session instanceof Connection) || ((Connection)session).isClosed()) {
            return null;
        }
        Connection con = (Connection)session;
        DatabaseMetaData md = con.getMetaData();
        String[] schemaTable = GM.getRealSchemaTable(con, schema, table);
        Section columnNames = new Section();
        try (ResultSet rs = null;){
            rs = md.getPrimaryKeys(null, schemaTable[0], schemaTable[1]);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                columnNames.addSection(columnName);
            }
        }
        return columnNames.toStringArray();
    }

    public static String[] getRealSchemaTable(Connection con, String schema, String table) throws SQLException {
        String newTable;
        String newSchema = null;
        DatabaseMetaData md = con.getMetaData();
        String tilde = md.getIdentifierQuoteString();
        int index = table.indexOf(46);
        if (index > -1) {
            newSchema = table.substring(0, index);
            if (newSchema.startsWith(tilde)) {
                newSchema = newSchema.substring(tilde.length(), newSchema.length() - tilde.length());
            }
            if ((newTable = table.substring(index + 1, table.length())).startsWith(tilde)) {
                newTable = newTable.substring(tilde.length(), newTable.length() - tilde.length());
            }
        } else {
            newTable = table;
            if (newTable.startsWith(tilde)) {
                newTable = newTable.substring(tilde.length(), newTable.length() - tilde.length());
            }
        }
        if (!StringUtils.isValidString(newSchema)) {
            newSchema = schema;
        }
        return new String[]{newSchema, newTable};
    }

    public static void setEditStyle(JTableEx tableEx) {
        int c = 0;
        while (c < tableEx.getColumnCount()) {
            TableColumn tc = tableEx.getColumn(c);
            TableCellEditor tce = tc.getCellEditor();
            if (tce != null && tce.getClass().getName().equals("com.scudata.ide.common.swing.JTableEx$SimpleEditor")) {
                tc.setCellEditor(new AllPurposeEditor(new JTextField(), tableEx));
                tc.setCellRenderer(new AllPurposeRenderer());
            }
            ++c;
        }
    }

    public static Cursor getDndCursor() {
        String path = "/com/scudata/ide/common/resources/dnd_cursor.gif";
        Image im = GM.getImageIcon(path).getImage();
        return Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(0, 0), "cur");
    }

    public static Matrix getClipboardMatrix() {
        String data = GM.clipBoard(true);
        if (!StringUtils.isValidString(data)) {
            return null;
        }
        Matrix matrix = GM.isExcelClipboard() ? GM.parseExcelClipboard(data) : (GM.isWordClipboard() ? GM.parseWordClipboard(data) : GM.string2Matrix(data));
        return matrix;
    }

    public static boolean isWordClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.fragmentHtmlFlavor)) {
                String html = (String)transferable.getTransferData(DataFlavor.fragmentHtmlFlavor);
                return html.contains("<!-- Generated by Microsoft Word -->") || html.contains("mso-") || html.contains("urn:schemas-microsoft-com:office:word");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExcelClipboard() {
        try {
            DataFlavor[] flavors;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(null);
            if (content == null) {
                return false;
            }
            DataFlavor[] dataFlavorArray = flavors = content.getTransferDataFlavors();
            int n = flavors.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    if (!content.isDataFlavorSupported(DataFlavor.allHtmlFlavor)) return false;
                    String html = (String)content.getTransferData(DataFlavor.allHtmlFlavor);
                    if (html.contains("urn:schemas-microsoft-com:office:excel")) return true;
                    if (html.contains("<!--table from excel-->")) return true;
                    if (html.contains("generator=\"Excel\"")) return true;
                    return false;
                }
                DataFlavor flavor = dataFlavorArray[n2];
                String mimeType = flavor.getMimeType().toLowerCase();
                if (mimeType.contains("application/x-msexcel")) return true;
                if (mimeType.contains("application/vnd.ms-excel")) return true;
                if (mimeType.contains("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) return true;
                if (mimeType.contains("excel")) return true;
                if (mimeType.contains("xls")) {
                    return true;
                }
                if (flavor.isMimeTypeEqual(DataFlavor.imageFlavor) && flavor.getHumanPresentableName().contains("Excel")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static Matrix parseExcelClipboard(String data) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"|([^\t\n\r]+)");
        try {
            data = data.replaceAll("\r\n", "\n");
            data = data.replaceAll("\r", "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Matrix matrix = new Matrix(1, 1);
        if (data == null || data.equals("")) {
            return null;
        }
        int r = 0;
        int c = 0;
        ArgumentTokenizer rows = new ArgumentTokenizer(data, '\n', true, true, true);
        while (rows.hasMoreTokens()) {
            String ls_row = rows.nextToken();
            c = 0;
            if (r >= matrix.getRowSize()) {
                matrix.addRow();
            }
            Matcher matcher = pattern.matcher(ls_row);
            while (matcher.find()) {
                String value;
                String string = value = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
                if (c >= matrix.getColSize()) {
                    matrix.addCol();
                }
                value = value != null ? GM.unescapeHtml(value) : "";
                matrix.set(r, c, value);
                ++c;
            }
            ++r;
        }
        GM.removeLastEmptyRow(matrix);
        return matrix;
    }

    private static Matrix parseWordClipboard(String data) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.fragmentHtmlFlavor)) {
            return GM.string2Matrix(data);
        }
        try {
            String html = (String)transferable.getTransferData(DataFlavor.fragmentHtmlFlavor);
            Document doc = Jsoup.parse((String)html);
            Elements tables = doc.select("[class=MsoNormalTable], [style*=mso-table-layout-alt]");
            if (!tables.isEmpty()) {
                Element table = tables.first();
                Matrix matrix = GM.string2Matrix(table.toString());
                int r = 0;
                while (r < matrix.getRowSize()) {
                    int c = 0;
                    while (c < matrix.getColSize()) {
                        Object cell = matrix.get(r, c);
                        if (StringUtils.isValidString(cell)) {
                            String cellStr = (String)cell;
                            if (cellStr.indexOf("&nbsp;&nbsp; ") > -1) {
                                cellStr = cellStr.replaceAll("\r\n", "\n");
                                cellStr = cellStr.replaceAll("\r", "\n");
                                cellStr = cellStr.replaceAll("&nbsp;&nbsp; ", "\t");
                                String[] rowDatas = cellStr.split("\n");
                                StringBuffer buf = new StringBuffer();
                                String[] stringArray = rowDatas;
                                int n = rowDatas.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String rowData = stringArray[n2];
                                    if (buf.length() > 0) {
                                        buf.append("\n");
                                    }
                                    if (rowData != null) {
                                        if (buf.length() > 0) {
                                            rowData = rowData.trim();
                                        }
                                    } else {
                                        rowData = "";
                                    }
                                    buf.append(rowData);
                                    ++n2;
                                }
                                cellStr = buf.toString();
                            }
                            cellStr = GM.unescapeHtml(cellStr);
                            matrix.set(r, c, cellStr);
                        }
                        ++c;
                    }
                    ++r;
                }
                return matrix;
            }
        }
        catch (Exception html) {
            // empty catch block
        }
        Matrix matrix = GM.string2Matrix(data);
        return matrix;
    }

    public static Matrix string2Matrix(String data) {
        return GM.string2Matrix(data, false);
    }

    public static Matrix string2Matrix(String data, boolean parse) {
        if (!StringUtils.isValidString(data)) {
            return null;
        }
        if (!GM.isHtmlString(data)) {
            PgmCellSet cellSet = CellSetUtil.toPgmCellSet(data);
            int rc = cellSet.getRowCount();
            int cc = cellSet.getColCount();
            Matrix matrix = new Matrix(rc, cc);
            int r = 1;
            while (r <= rc) {
                int c = 1;
                while (c <= cc) {
                    PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                    String cellExp = cell.getExpString();
                    cellExp = GM.removeScanTag(cellExp);
                    cellExp = GM.unescapeHtml(cellExp);
                    matrix.set(r - 1, c - 1, cellExp);
                    ++c;
                }
                ++r;
            }
            return matrix;
        }
        Matrix matrix = GM.parseHtmlStringMatrix(data, parse);
        GM.removeLastEmptyRow(matrix);
        return matrix;
    }

    private static Matrix parseHtmlStringMatrix(String htmlStr, boolean parse) {
        htmlStr = GM.removeHtmlTag(htmlStr);
        Matrix matrix = null;
        String[] tableTag = GM.splitTableTag(htmlStr);
        while (tableTag != null) {
            String center = tableTag[1];
            if (center == null) break;
            if (StringUtils.isValidString(center)) {
                Matrix tmp = GM.getTableTagMatrix(center);
                matrix = matrix == null ? tmp : GM.unionMatrix(matrix, tmp);
            }
            tableTag = GM.splitTableTag(tableTag[2]);
        }
        return matrix;
    }

    public static String removeHtmlTag(String htmlStr) {
        if (htmlStr == null) {
            return null;
        }
        htmlStr = GM.replaceHtmlTag(htmlStr, ">\\s+<", "><");
        htmlStr = GM.replaceHtmlTag(htmlStr, "<p\\s*/?>", " ");
        htmlStr = GM.replaceHtmlTag(htmlStr, "&lt;(?i)(p|img)\\s*/?&gt;", " ");
        htmlStr = GM.replaceHtmlTag(htmlStr, "<br\\s*/?>", "\n");
        htmlStr = GM.replaceHtmlTag(htmlStr, "<head\\s*>[\\s\\S]*?</\\s*head>");
        htmlStr = GM.replaceHtmlTag(htmlStr, "<script[^>]*?>[\\s\\S]*?<\\/script>");
        htmlStr = GM.replaceHtmlTag(htmlStr, "<style[^>]*?>[\\s\\S]*?<\\/style>");
        return htmlStr;
    }

    public static String removeScanTag(String htmlStr) {
        if (htmlStr == null) {
            return null;
        }
        return htmlStr.replaceAll("\\<\\/?span[^>]*>", "");
    }

    public static String unescapeHtml(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&nbsp;", " ");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&apos;", "'");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        return str;
    }

    public static String escapeHtml(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(" ", "&nbsp;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    private static boolean isHtmlString(String htmlStr) {
        if (!StringUtils.isValidString(htmlStr)) {
            return false;
        }
        Pattern p = Pattern.compile("<\\s*table[^>]*>", 2);
        Matcher m = p.matcher(htmlStr);
        return m.find();
    }

    private static void removeLastEmptyRow(Matrix matrix) {
        int rowSize = matrix.getRowSize();
        int colSize = matrix.getColSize();
        int i = rowSize - 1;
        while (i >= 0) {
            boolean isEmptyRow = true;
            int j = 0;
            while (j < colSize) {
                Object val = matrix.get(i, j);
                if (val != null) {
                    if (!(val instanceof String)) {
                        isEmptyRow = false;
                        break;
                    }
                    if (StringUtils.isValidString(val)) {
                        isEmptyRow = false;
                        break;
                    }
                }
                ++j;
            }
            if (!isEmptyRow) break;
            matrix.deleteRow(i);
            --i;
        }
    }

    private static String[] splitTableTag(String htmlStr) {
        if (!StringUtils.isValidString(htmlStr)) {
            return null;
        }
        Pattern p = Pattern.compile("<\\s*table[^>]*>", 2);
        Matcher m = p.matcher(htmlStr);
        if (!m.find()) {
            String[] stringArray = new String[3];
            stringArray[0] = htmlStr;
            return stringArray;
        }
        int startIndex = m.start();
        String pre = htmlStr.substring(0, startIndex);
        int end = m.end();
        p = Pattern.compile("</\\s*table\\s*>", 2);
        m = p.matcher(htmlStr);
        int endIndex = m.find(end) ? m.end() : htmlStr.length() - 1;
        String center = htmlStr.substring(startIndex, endIndex);
        String suffix = null;
        if (htmlStr.length() > endIndex + 1) {
            suffix = htmlStr.substring(endIndex);
        }
        return new String[]{pre, center, suffix};
    }

    private static Matrix getTableTagMatrix(String tableTag) {
        String[] trTags = GM.splitTableRowTag(tableTag);
        if (trTags == null || trTags.length == 0) {
            return null;
        }
        Matrix matrix = new Matrix(trTags.length, 1);
        int r = 0;
        while (r < trTags.length) {
            String tr = trTags[r];
            String[] rowData = GM.splitTableDataTag(tr);
            if (rowData != null && rowData.length > 0) {
                if (rowData.length > matrix.getColSize()) {
                    matrix.addCols(rowData.length - matrix.getColSize());
                }
                int c = 0;
                while (c < rowData.length) {
                    String cellStr = rowData[c];
                    cellStr = GM.unescapeHtml(cellStr);
                    matrix.set(r, c, cellStr);
                    ++c;
                }
            }
            ++r;
        }
        if (matrix.getRowSize() == 0 || matrix.getColSize() == 0) {
            return null;
        }
        return matrix;
    }

    private static String[] splitTableRowTag(String tableTag) {
        if (!StringUtils.isValidString(tableTag)) {
            return null;
        }
        ArrayList<String> dataList = new ArrayList<String>();
        int index = 0;
        Pattern p1 = Pattern.compile("<\\s*tr[^>]*>", 2);
        Pattern p2 = Pattern.compile("</\\s*tr\\s*>", 2);
        Matcher m1 = p1.matcher(tableTag);
        Matcher m2 = p2.matcher(tableTag);
        while (index < tableTag.length() && m1.find(index)) {
            int endIndex;
            int startIndex = m1.start();
            index = m1.end();
            if (index >= tableTag.length()) break;
            if (m2.find(index)) {
                endIndex = m2.end();
                index = m2.end();
            } else {
                index = endIndex = tableTag.length() - 1;
            }
            dataList.add(tableTag.substring(startIndex, endIndex));
        }
        if (dataList.isEmpty()) {
            return null;
        }
        String[] datas = new String[dataList.size()];
        int i = 0;
        while (i < datas.length) {
            Object data = dataList.get(i);
            datas[i] = data == null ? null : (String)data;
            ++i;
        }
        return datas;
    }

    private static String[] splitTableDataTag(String trTag) {
        if (!StringUtils.isValidString(trTag)) {
            return null;
        }
        ArrayList<String> dataList = new ArrayList<String>();
        int index = 0;
        Pattern p1 = Pattern.compile("<\\s*t[hd][^>]*>", 2);
        Pattern p2 = Pattern.compile("</\\s*t[hd]\\s*>", 2);
        Matcher m1 = p1.matcher(trTag);
        Matcher m2 = p2.matcher(trTag);
        while (index < trTag.length() && m1.find(index)) {
            int endIndex;
            int startIndex = m1.end();
            index = m1.end();
            if (index >= trTag.length() - 1) break;
            if (m2.find(index)) {
                endIndex = m2.start();
                index = m2.end();
            } else {
                index = endIndex = trTag.length() - 1;
            }
            String data = trTag.substring(startIndex, endIndex);
            data = GM.replaceHtmlTag(data, "<[^>]+>");
            data = GM.replaceHtmlTag(data, "&lt;[^>]+/?&gt;");
            dataList.add(data);
        }
        if (dataList.isEmpty()) {
            return null;
        }
        String[] datas = new String[dataList.size()];
        int i = 0;
        while (i < datas.length) {
            Object data = dataList.get(i);
            datas[i] = data == null ? null : (String)data;
            ++i;
        }
        return datas;
    }

    private static String replaceHtmlTag(String htmlStr, String regEx) {
        if ((htmlStr = GM.replaceHtmlTag(htmlStr, regEx, "")) != null) {
            htmlStr = htmlStr.trim();
        }
        return htmlStr;
    }

    private static String replaceHtmlTag(String htmlStr, String regEx, String replaceStr) {
        Pattern p = Pattern.compile(regEx, 2);
        Matcher m = p.matcher(htmlStr);
        return m.replaceAll(replaceStr);
    }

    private static Matrix unionMatrix(Matrix m1, Matrix m2) {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        int colSize1 = m1.getColSize();
        int colSize2 = m2.getColSize();
        if (colSize2 > colSize1) {
            m1.addCols(colSize2 - colSize1);
        }
        int rowSize1 = m1.getRowSize();
        int rowSize2 = m2.getRowSize();
        m1.addRows(rowSize2);
        int r = 0;
        while (r < rowSize2) {
            int c = 0;
            while (c < colSize2) {
                m1.set(rowSize1 + r, c, m2.get(r, c));
                ++c;
            }
            ++r;
        }
        return m1;
    }

    public static Matrix getStringMatrix(String data, boolean parse) {
        int r = 0;
        int c = 0;
        try {
            data = data.replaceAll("\r\n", "\n");
            data = data.replaceAll("\r", "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Matrix matrix = new Matrix(1, 1);
        ArgumentTokenizer rows = new ArgumentTokenizer(data, '\n', true, true, true, true);
        while (rows.hasMoreTokens()) {
            String ls_row = rows.nextToken();
            ArgumentTokenizer items = new ArgumentTokenizer(ls_row, '\t', true, true, true, true);
            c = 0;
            if (r >= matrix.getRowSize()) {
                matrix.addRow();
            }
            while (items.hasMoreTokens()) {
                if (c >= matrix.getColSize()) {
                    matrix.addCol();
                }
                String item = items.nextToken();
                Object val = item;
                if (parse) {
                    val = item.startsWith("'") && !item.endsWith("'") ? item.substring(1) : Variant.parseCellValue(item);
                }
                matrix.set(r, c, val);
                ++c;
            }
            ++r;
        }
        return matrix;
    }

    /*
     * Unable to fully structure code
     */
    public static String getCellID(int iRow, int iCol) {
        block1: {
            retVal = "";
            if (--iCol <= 999) ** GOTO lbl7
            retVal = String.valueOf(retVal) + "A" + iRow;
            break block1;
lbl-1000:
            // 1 sources

            {
                retVal = String.valueOf(GM.STR_COLID[iCol % 26]) + retVal;
                iCol = iCol / 26 - 1;
lbl7:
                // 2 sources

                ** while (iCol >= 0)
            }
lbl8:
            // 1 sources

            retVal = String.valueOf(retVal) + iRow;
        }
        return retVal;
    }

    public static int getColByName(String colName) {
        if (!StringUtils.isValidString(colName)) {
            return -1;
        }
        int col = 0;
        int i = colName.length() - 1;
        while (i >= 0) {
            char c = colName.charAt(i);
            int j = 0;
            while (j < STR_COLID.length) {
                if (STR_COLID[j].equals(String.valueOf(c))) break;
                ++j;
            }
            col = (int)((double)col + ((double)j + Math.pow(STR_COLID.length, i)));
            --i;
        }
        return col;
    }

    public static String getCellSelectionString(Matrix matrix, boolean useValue) {
        if (matrix == null) {
            return null;
        }
        PgmCellSet cellSet = new PgmCellSet(matrix.getRowSize(), matrix.getColSize());
        int i = 0;
        while (i < matrix.getRowSize()) {
            int j = 0;
            while (j < matrix.getColSize()) {
                NormalCell fromCell = (NormalCell)matrix.get(i, j);
                if (fromCell != null) {
                    PgmNormalCell toCell = cellSet.getPgmNormalCell(i + 1, j + 1);
                    ((NormalCell)toCell).setExpString(fromCell.getExpString());
                }
                ++j;
            }
            ++i;
        }
        return GMSpl.cellSetToString(cellSet);
    }

    public static String[] getPaths() {
        String[] paths;
        if (StringUtils.isValidString(ConfigOptions.sPaths) && (paths = ConfigOptions.sPaths.split(";")) != null) {
            int i = 0;
            while (i < paths.length) {
                paths[i] = ConfigUtil.getPath(System.getProperty("start.home"), paths[i]);
                ++i;
            }
            return paths;
        }
        return null;
    }

    public static void setCurrentPath(String filePath) {
        try {
            if (!StringUtils.isValidString(ConfigOptions.sMainPath)) {
                File f;
                if (StringUtils.isValidString(filePath) && (f = new File(filePath)).isFile() && f.exists()) {
                    Env.setMainPath(f.getParent());
                    return;
                }
                Env.setMainPath(System.getProperty("user.dir"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static InputStream getFileInputStream(String filePath) throws Exception {
        ClassLoader cl;
        InputStream is = null;
        try {
            is = new FileInputStream(filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                is = cl.getResourceAsStream(filePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = GM.class.getResourceAsStream(filePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return is;
    }

    public static int getAbsolutePos(Component c, boolean isGetX) {
        if (c == null) {
            return 0;
        }
        return (isGetX ? c.getX() : c.getY()) + GM.getAbsolutePos(c.getParent(), isGetX);
    }

    public static boolean isExistDataSource(Component parent, DataSource ds) {
        if (GV.dsModel.existDSName(ds.getName())) {
            GM.messageDialog(parent, IdeCommonMessage.get().getMessage("dialogdatasource.existdsname", ds.getName()), IdeCommonMessage.get().getMessage("public.note"), 0);
            return true;
        }
        return false;
    }

    public static void addText(JTextComponent textEditor, String text) {
        if (text == null) {
            return;
        }
        if (!textEditor.isEnabled()) {
            return;
        }
        try {
            String exp = textEditor.getText();
            int pos = textEditor.getCaretPosition();
            String select = textEditor.getSelectedText();
            int length = 0;
            if (select != null && !select.equals("")) {
                length = select.length();
            }
            if (pos + length <= exp.length() && exp.substring(pos, pos + length).equals(select)) {
                exp = String.valueOf(exp.substring(0, pos)) + exp.substring(pos + length);
            } else if (pos - length >= 0 && exp.substring(pos - length, pos).equals(select)) {
                exp = String.valueOf(exp.substring(0, pos - length)) + exp.substring(pos);
                pos -= length;
            }
            exp = pos == 0 ? String.valueOf(text) + exp : (pos >= exp.length() ? String.valueOf(exp) + text : String.valueOf(exp.substring(0, pos)) + text + exp.substring(pos));
            textEditor.setText(exp);
            textEditor.requestFocus();
            textEditor.setCaretPosition(pos + text.length());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String transTips(String tips) {
        return GM.transTips(tips, null);
    }

    public static String transTips(String tips, IntArrayList list) {
        return GM.transTips(tips, list, new JTextArea().getFontMetrics(GC.font), 200);
    }

    public static String transTips(String tips, IntArrayList list, FontMetrics fm, int maxWidth) {
        if (!StringUtils.isValidString(tips)) {
            return "";
        }
        if (tips.toLowerCase().trim().startsWith("<html>")) {
            return tips;
        }
        tips = tips.replaceAll("<br>", "\n");
        tips = tips.replaceAll("\r\n", "\n");
        tips = tips.replaceAll("\r", "\n");
        tips = tips.replaceAll("\t", " ");
        ArgumentTokenizer rows = new ArgumentTokenizer(tips, '\n', true, true, true);
        boolean first = true;
        StringBuffer htmlTips = new StringBuffer();
        int colCount = 0;
        int tipWidth = 0;
        while (rows.hasMoreTokens()) {
            String rowTips = rows.nextToken();
            int width = 0;
            int i = 0;
            while (i < rowTips.length()) {
                if ((width += fm.charWidth(rowTips.charAt(i))) > maxWidth) {
                    if (first) {
                        first = false;
                    } else {
                        htmlTips.append("<br>");
                    }
                    htmlTips.append(rowTips.substring(0, i));
                    ++colCount;
                    rowTips = rowTips.substring(i);
                    i = -1;
                    width = 0;
                } else if (width > tipWidth) {
                    tipWidth = width;
                }
                ++i;
            }
            if (first) {
                first = false;
            } else {
                htmlTips.append("<br>");
            }
            htmlTips.append(rowTips);
            ++colCount;
        }
        if (colCount * fm.getHeight() > maxWidth) {
            return GM.transTips(tips, list, new RQTextArea().getFontMetrics(GC.font), (int)((double)maxWidth * 1.5));
        }
        if (list != null) {
            list.addInt(tipWidth);
            list.addInt(colCount * fm.getHeight());
        }
        tips = htmlTips.toString();
        tips = GM.escapeHtml(tips);
        return "<html>&nbsp;" + tips + "</html>";
    }

    public static Context prepareParentContext() {
        Context context = new Context();
        int c = 0;
        while (c < GV.dsModel.size()) {
            DataSource ds = (DataSource)GV.dsModel.getElementAt(c);
            if (ds != null && !ds.isClosed()) {
                try {
                    context.setDBSession(ds.getName(), ds.getDBSession());
                }
                catch (Throwable ex) {
                    GM.showException(GV.appFrame, ex);
                }
            }
            ++c;
        }
        return context;
    }

    public static boolean isNewGrid(String filePath, String pre) {
        if (filePath.equals(pre)) {
            return true;
        }
        if (filePath.startsWith(pre)) {
            String end = filePath.substring(pre.length());
            if (end.startsWith("_")) {
                end = end.substring(1);
            }
            try {
                Integer.parseInt(end);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean deleteFile(File f) {
        if (f == null || !f.exists()) {
            return true;
        }
        if (f.isFile()) {
            return f.delete();
        }
        if (f.isDirectory()) {
            File[] subFiles = f.listFiles();
            if (subFiles != null) {
                File[] fileArray = subFiles;
                int n = subFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File sub = fileArray[n2];
                    GM.deleteFile(sub);
                    ++n2;
                }
            }
            return f.delete();
        }
        return false;
    }

    public static String getLanguageSuffix() {
        switch (GC.LANGUAGE) {
            case 0: {
                return "_zh";
            }
            case 1: {
                return "_zh_TW";
            }
        }
        return "_en";
    }

    public static boolean isDataLogicDS(DataSource ds) {
        if (ds.getDBInfo() instanceof DBConfig) {
            String driver = ((DBConfig)ds.getDBInfo()).getDriver();
            if (driver.equalsIgnoreCase("com.datalogic.jdbc.LogicDriver")) {
                return true;
            }
            if (driver.equalsIgnoreCase("com.datasphere.httpjdbc.client.HttpDriver")) {
                return true;
            }
        }
        return false;
    }

    public static void resetAllSheetStyle() {
        JInternalFrame[] sheets = GV.appFrame.getAllSheets();
        if (sheets == null) {
            return;
        }
        int i = 0;
        while (i < sheets.length) {
            ((IPrjxSheet)sheets[i]).resetSheetStyle();
            ++i;
        }
    }

    public static void browse(String url) throws Exception {
        String errorMsg = null;
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop dt = Desktop.getDesktop();
                if (dt.isSupported(Desktop.Action.BROWSE)) {
                    URI uri = new URI(url);
                    dt.browse(uri);
                } else {
                    errorMsg = "Desktop does not support the BROWSE action.";
                }
            } else {
                errorMsg = "Desktop is not supported.";
            }
        }
        catch (Exception ex) {
            try {
                GM.browseOld(url);
                return;
            }
            catch (Throwable t) {
                throw ex;
            }
        }
        if (errorMsg != null) {
            throw new RQException(errorMsg);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void browseOld(String url) throws Throwable {
        block12: {
            os = System.getProperty("os.name").toLowerCase();
            if (GM.isWindowsOS()) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else if (os.contains("mac")) {
                Runtime.getRuntime().exec(new String[]{"open", url});
            } else {
                try {
                    Runtime.getRuntime().exec("xdg-open " + url);
                    break block12;
                }
                catch (Throwable t1) {
                    defaultBrowser = GM.getDefaultBrowser();
                    if (defaultBrowser != null) {
                        try {
                            Runtime.getRuntime().exec(new String[]{defaultBrowser, url});
                            return;
                        }
                        catch (Throwable var4_4) {
                            // empty catch block
                        }
                    }
                    var8_6 = browsers = new String[]{"google-chrome", "firefox", "chromium-browser", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    var7_7 = browsers.length;
                    var6_8 = 0;
                    ** while (var6_8 < var7_7)
                }
lbl-1000:
                // 1 sources

                {
                    browser = var8_6[var6_8];
                    try {
                        Runtime.getRuntime().exec(new String[]{browser, url});
                        return;
                    }
                    catch (Throwable var9_10) {
                        ++var6_8;
                    }
                    continue;
                }
lbl35:
                // 1 sources

                throw t1;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String getDefaultBrowser() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String mapBrowserToExecutable(String browser) {
        if ("firefox.desktop".equals(browser)) {
            return "firefox";
        }
        if ("google-chrome.desktop".equals(browser)) {
            return "google-chrome";
        }
        if ("chromium-browser.desktop".equals(browser)) {
            return "chromium-browser";
        }
        return null;
    }

    public static String getLineSeparator() {
        return GM.isWindowsOS() ? "\n" : System.getProperties().getProperty("line.separator");
    }

    public static String getImageType(byte[] imageBytes) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(imageBytes);
        ImageInputStream imageInput = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInput);
        String type = null;
        if (iterator.hasNext()) {
            ImageReader reader = iterator.next();
            type = reader.getFormatName().toUpperCase();
        }
        try {
            String string = type;
            return string;
        }
        finally {
            if (imageInput != null) {
                imageInput.close();
                imageInput = null;
            }
        }
    }

    public static Vector<String> getDispLocale() {
        MessageManager mm = IdeCommonMessage.get();
        Vector<String> v = new Vector<String>();
        v.add(mm.getMessage("gm.english"));
        v.add(mm.getMessage("gm.simplechinese"));
        return v;
    }

    public static Vector<Byte> getCodeLocale() {
        Vector<Byte> v = new Vector<Byte>();
        v.add(new Byte(4));
        v.add(new Byte(0));
        return v;
    }

    public static int getPageHeight(float scale) {
        int height = GV.appSheet.getHeight();
        height -= GV.appSheet.getTitleHeight();
        height = (int)((float)height - 25.0f * scale);
        return new Double(height).intValue() - 5;
    }

    public static int getPageWidth(float scale) {
        int width = GV.appSheet.getWidth();
        width -= 10;
        width = (int)((float)width - 40.0f * scale);
        return new Double(width).intValue() - 5;
    }

    public static boolean isBlockSizeEnabled() {
        return true;
    }

    public static String getPartOfSql(String sql, String part) {
        Object fromObj = SQLUtil.parse(sql = GM.removeSqlNote(sql), part);
        if (fromObj == null) {
            return "";
        }
        if (fromObj instanceof Sequence) {
            StringBuffer buf = new StringBuffer();
            Sequence seq = (Sequence)fromObj;
            int i = 1;
            int len = seq.length();
            while (i <= len) {
                if (i > 1) {
                    buf.append(",");
                }
                buf.append(seq.get(i));
                ++i;
            }
            return buf.toString();
        }
        return (String)fromObj;
    }

    public static String modifySql(String sql, String replace, String part) {
        sql = GM.removeSqlNote(sql);
        return SQLUtil.replace(sql, replace, part);
    }

    public static String removeSqlNote(String sql) {
        if (sql == null) {
            return null;
        }
        sql = sql.replaceAll("(/\\*.*?\\*/)|(--.*)", "");
        return sql;
    }

    public static int[] getCurrentWordPosition(String str, int p) {
        char c;
        if (!StringUtils.isValidString(str)) {
            return null;
        }
        if (p < 0) {
            return null;
        }
        if (p == 0) {
            if (GM.isSymbol(str.charAt(p))) {
                return null;
            }
        } else if (p < str.length() && GM.isSymbol(str.charAt(p))) {
            if (GM.isSymbol(str.charAt(p - 1))) {
                return null;
            }
            --p;
        }
        int start = p;
        int end = p;
        int i = p - 1;
        while (i >= 0) {
            c = str.charAt(i);
            if ('@' == c) {
                return null;
            }
            if (GM.isSymbol(c)) {
                start = i + 1;
                break;
            }
            --i;
        }
        i = p + 1;
        while (i < str.length()) {
            c = str.charAt(i);
            if (GM.isSymbol(c)) {
                end = i;
                break;
            }
            ++i;
        }
        if (start >= end) {
            return null;
        }
        return new int[]{start, end};
    }

    private static boolean isSymbol(char c) {
        return KeyWord.isSymbol(c) || c == '@';
    }

    public static File[] sortFiles(File[] files) {
        if (files == null || files.length == 0) {
            return files;
        }
        List<File> list = Arrays.asList(files);
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return Env.getCollator().compare(o1.getName(), o2.getName());
            }
        });
        return list.toArray(new File[list.size()]);
    }

    public static void messageDialog(Component parentComponent, Object message) {
        GM.messageDialog(parentComponent, message, null, 1);
    }

    public static void messageDialog(Component parentComponent, Object message, String title, int messageType) {
        GM.optionDialog(parentComponent, message, title, -1, messageType, null);
    }

    public static int optionDialog(Component parentComponent, Object message, String title, int optionType) {
        return GM.optionDialog(parentComponent, message, title, optionType, 3, null);
    }

    public static int optionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Object[] options) {
        Object initialValue;
        MessageManager mm = IdeCommonMessage.get();
        if (options == null) {
            if (optionType == -1) {
                options = new Object[]{mm.getMessage("public.ok")};
                initialValue = options[0];
            } else if (optionType == 2) {
                options = new Object[]{mm.getMessage("public.ok"), mm.getMessage("public.cancel")};
                initialValue = options[1];
            } else if (optionType == 0) {
                options = new Object[]{mm.getMessage("public.yes"), mm.getMessage("public.no")};
                initialValue = options[1];
            } else if (optionType == 1) {
                options = new Object[]{mm.getMessage("public.yes"), mm.getMessage("public.no"), mm.getMessage("public.cancel")};
                initialValue = options[2];
            } else {
                options = null;
                initialValue = null;
            }
        } else {
            initialValue = options[options.length - 1];
        }
        return JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, null, options, initialValue);
    }

    public static Font getScaleFont(float scale) {
        int size = GC.font.getSize();
        Font font = fontMap.get(size = StringUtils.getScaledFontSize(size, scale));
        if (font == null) {
            font = new Font(GC.font.getFontName(), GC.font.getStyle(), size);
            fontMap.put(size, font);
        }
        return font;
    }

    public static Color getValueColor(Object value) {
        if (value != null) {
            if (GM.isRefVal(value)) {
                return ConfigOptions.COLOR_REF;
            }
            if (value instanceof BigDecimal) {
                return ConfigOptions.COLOR_DECIMAL;
            }
            if (value instanceof Double) {
                return ConfigOptions.COLOR_DOUBLE;
            }
            if (value instanceof Integer || value instanceof Long || value instanceof Short) {
                return ConfigOptions.COLOR_INTEGER;
            }
        } else {
            return ConfigOptions.COLOR_NULL;
        }
        return Color.BLACK;
    }

    public static boolean isRefVal(Object val) {
        if (val == null) {
            return false;
        }
        return val instanceof BaseRecord || val instanceof Sequence;
    }

    public static void doResetGlobalEnv() {
        ArrayList<JobSpace> spaces;
        ParamList pl = Env.getParamList();
        if (pl != null) {
            int i = 0;
            int count = pl.count();
            while (i < count) {
                Object val;
                Param p = pl.get(i);
                if (p != null && (val = p.getValue()) != null && val instanceof IResource) {
                    try {
                        ((IResource)val).close();
                    }
                    catch (Exception e) {
                        GMSpl.showException(e);
                    }
                }
                ++i;
            }
            pl.clear();
        }
        if ((spaces = JobSpaceManager.currentSpaces()) != null) {
            for (JobSpace space : spaces) {
                if (space == null) continue;
                try {
                    space.close();
                }
                catch (Exception e) {
                    GMSpl.showException(e);
                }
            }
        }
    }

    public static void saveFormat(String colName, String format) {
        ConfigFile cf = null;
        try {
            cf = ConfigFile.getConfigFile();
            String oldNode = cf.getConfigNode();
            XMLFile xml = cf.xmlFile();
            if (!xml.isPathExists(ConfigFile.NODE_FORMAT)) {
                xml.newElement("RAQSOFT", ConfigFile.NODE_FORMAT);
            }
            cf.setConfigNode(ConfigFile.NODE_FORMAT);
            cf.setAttrValue(colName, format);
            cf.setConfigNode(oldNode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getColumnFormat(String colName) {
        if (colName == null) {
            return null;
        }
        try {
            ConfigFile cf = ConfigFile.getConfigFile();
            String oldNode = cf.getConfigNode();
            cf.setConfigNode(ConfigFile.NODE_FORMAT);
            String format = cf.getAttrValue(colName);
            cf.setConfigNode(oldNode);
            return format;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void switchConfigFile(String path) throws Exception {
        if (path == null) {
            return;
        }
        String fullPath = GM.getAbsolutePath(path);
        File home = new File(System.getProperty("start.home"));
        if (path.startsWith(home.getAbsolutePath())) {
            path = path.substring(home.getAbsolutePath().length());
            while (path.startsWith("\\")) {
                path = path.substring(1);
            }
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        GM.clearEnv();
        RaqsoftConfig config = ConfigUtilIde.loadConfig(fullPath, true);
        GM.resetDataSource(config);
        ConfigOptions.sConfigFile = path;
        ConfigOptions.applyOptions();
    }

    public static void clearEnv() {
        Env.clearDBSessionFactories();
        Env.clearParam();
    }

    public static void resetDataSource(final RaqsoftConfig config) {
        if (config == GV.config) {
            return;
        }
        if (GV.dsModel != null) {
            int size = GV.dsModel.getSize();
            int i = 0;
            while (i < size) {
                try {
                    DataSource ds = GV.dsModel.getDataSource(i);
                    ds.close();
                }
                catch (Exception ex) {
                    Logger.error(ex);
                }
                ++i;
            }
            GV.dsModel.clear();
        }
        GV.dsModel = new DataSourceListModel(){
            private static final long serialVersionUID = 1L;

            @Override
            protected RaqsoftConfig getRaqsoftConfig() {
                return config;
            }
        };
    }

    public static class ValueColInfo {
        public String format;
        public int colWidth = 0;

        public ValueColInfo() {
        }

        public ValueColInfo(String format, int colWidth) {
            this.format = format;
            this.colWidth = colWidth;
        }
    }
}

