/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.cellset.ICellSet;
import com.scudata.ide.common.ConfigOptions;
import com.scudata.ide.common.GV;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public abstract class IPrjxSheet
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private JComponent titlePane = null;
    private int titleHeight = 25;
    private boolean isForceMax = false;
    private boolean lastIsIcon = false;
    private long createTime = System.currentTimeMillis();

    public IPrjxSheet(String filePath) {
        super(filePath, true, true, true, true);
        if (this.getUI() instanceof BasicInternalFrameUI) {
            this.titlePane = ((BasicInternalFrameUI)this.getUI()).getNorthPane();
            if (this.titlePane != null) {
                this.titleHeight = this.titlePane.getHeight();
            }
            if (this.titleHeight < 10) {
                this.titleHeight = 25;
            }
        }
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public void resetSheetStyle() {
        if (this.titlePane != null) {
            if (ConfigOptions.bViewWinList.booleanValue() && this.isMaximum() && !this.isIcon()) {
                this.titlePane.setMaximumSize(new Dimension(GV.appFrame.getWidth(), 0));
                this.titlePane.setPreferredSize(new Dimension(GV.appFrame.getWidth(), 0));
                this.titlePane.setVisible(false);
            } else {
                this.titlePane.setMaximumSize(new Dimension(GV.appFrame.getWidth(), this.titleHeight));
                this.titlePane.setPreferredSize(new Dimension(GV.appFrame.getWidth(), this.titleHeight));
                this.titlePane.setVisible(true);
            }
        }
    }

    @Override
    public void setMaximum(boolean b) throws PropertyVetoException {
        super.setMaximum(b);
        this.resetSheetStyle();
        GV.toolWin.refreshSheet(this);
    }

    public void setForceMax() {
        this.isForceMax = true;
        this.lastIsIcon = this.isIcon();
    }

    public void resumeSheet() {
        if (this.isForceMax) {
            this.isForceMax = false;
            try {
                this.setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            if (this.lastIsIcon) {
                try {
                    this.setIcon(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public ImageIcon getSheetImageIcon() {
        return null;
    }

    public abstract void executeCmd(short var1) throws Exception;

    public abstract boolean close();

    public abstract String getFileName();

    public abstract void changeFileName(String var1);

    public abstract String getSheetTitle();

    public abstract void setSheetTitle(String var1);

    public abstract boolean save();

    public abstract boolean saveAs();

    public abstract ICellSet getCellSet();

    public abstract void setCellSet(Object var1);

    public abstract void setChanged(boolean var1);

    public abstract void refresh();

    public abstract boolean submitEditor();
}

