/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.RQException;
import com.scudata.ide.common.GM;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class ServiceUtil {
    public static final String ESPROC_DESK = "esproc_desk";
    public static final String ESPROC_SE = "esproc_se";
    public static final String ESPROC_ENT = "esproc_ent";
    public static final String REPORT = "report";
    public static final String REPORT_LITE = "report_lite";
    public static final String MINING = "mining";
    private static final int SYS_CONNECT_TIMEOUT = 5000;
    private static final String CHARSET = "UTF-8";
    private static final String ERROR_START = "error:";

    public static void count(String productName) throws Exception {
        ServiceUtil.service("count", productName);
    }

    public static String getVersion(String productName) throws Exception {
        return ServiceUtil.service("version", productName);
    }

    public static long getSystemTime() throws Exception {
        String timeStr = ServiceUtil.service("systime", null);
        return Long.parseLong(timeStr);
    }

    public static String getSystemDate() throws Exception {
        return ServiceUtil.service("sysdate", null);
    }

    private static String service(String action, String productName) throws Exception {
        return ServiceUtil.service(action, productName, 5000);
    }

    private static String service(String action, String productName, Integer timeout) throws Exception {
        String result;
        String url = ServiceUtil.getURL(productName);
        url = String.valueOf(url) + "server?action=";
        url = String.valueOf(url) + ServiceUtil.encode(action);
        if (productName != null) {
            url = String.valueOf(url) + "&product=";
            url = String.valueOf(url) + ServiceUtil.encode(productName);
        }
        if ((result = ServiceUtil.getURLContent(url, timeout)) != null && result.toLowerCase().startsWith(ERROR_START)) {
            throw new RQException(result.substring(ERROR_START.length()));
        }
        return result;
    }

    public static String getURLContent(String urlStr) throws Exception {
        return ServiceUtil.getURLContent(urlStr, null);
    }

    public static String getURLContent(String urlStr, Integer timeout) throws Exception {
        URL url = null;
        BufferedReader br = null;
        StringBuffer content = new StringBuffer();
        try {
            String tmp;
            url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            if (timeout != null) {
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
            }
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.103 Safari/537.36");
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), CHARSET));
            while ((tmp = br.readLine()) != null) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                content.append(tmp);
            }
            String string = content.toString();
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getURL(String productName) {
        if (GM.isChineseLanguage()) {
            return "http://service.raqsoft.com.cn/";
        }
        return "http://service.raqsoft.com/";
    }

    public static boolean containsURL(String mesasge) {
        if (mesasge == null) {
            return false;
        }
        return mesasge.indexOf("service.raqsoft.com") > 0;
    }

    public static String encode(Object val) {
        if (val == null) {
            return null;
        }
        try {
            return URLEncoder.encode(val.toString(), CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return val.toString();
        }
    }
}

