/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.Sentence;
import java.util.Enumeration;

public final class StringSplit
implements Enumeration<String> {
    private char delim = (char)44;
    private int index;
    private String str;
    private int len;
    private boolean isCounting;
    private boolean parentheses = false;
    private boolean brackets = false;
    private boolean braces = false;
    private boolean quotation = false;

    public StringSplit(String s, char delim, boolean ignoreParentheses, boolean ignoreBrackets, boolean ignoreBraces) {
        this.str = s;
        this.delim = delim;
        this.parentheses = !ignoreParentheses;
        this.brackets = !ignoreBrackets;
        this.braces = !ignoreBraces;
        this.quotation = true;
        this.len = this.str == null || this.str.length() == 0 ? -1 : this.str.length();
    }

    public String next() {
        if (this.str == null || this.index > this.len) {
            return null;
        }
        int old = this.index;
        while (this.index <= this.len) {
            int tmp;
            if (this.index == this.len) {
                ++this.index;
                if (this.len <= 1 || this.str.charAt(this.len - 1) != this.delim) break;
                return this.isCounting ? null : "";
            }
            char ch = this.str.charAt(this.index);
            if (ch == '\\') {
                this.index += 2;
                continue;
            }
            if (this.quotation && (ch == '\"' || ch == '\'')) {
                tmp = Sentence.scanQuotation(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.isCounting ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            if (this.parentheses && ch == '(') {
                tmp = Sentence.scanParenthesis(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.isCounting ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            if (this.brackets && ch == '[') {
                tmp = Sentence.scanBracket(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.isCounting ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            if (this.braces && ch == '{') {
                tmp = Sentence.scanBrace(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.isCounting ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            ++this.index;
            if (ch == this.delim) break;
        }
        return this.isCounting ? null : this.str.substring(old, this.index - 1);
    }

    public String nextToken() {
        return this.next();
    }

    @Override
    public String nextElement() {
        return this.next();
    }

    public int countTokens() {
        int j = this.index;
        this.isCounting = true;
        int i = 0;
        while (this.index <= this.len) {
            this.next();
            ++i;
        }
        this.index = j;
        this.isCounting = false;
        return i;
    }

    public boolean hasNext() {
        return this.index <= this.len;
    }

    public boolean hasMoreTokens() {
        return this.hasNext();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }
}

