/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.StringUtils;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.IAppFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class TcpServer
extends Thread {
    private IAppFrame frame;
    private int port;
    private String file;
    public static String GETWINDOWTITLE = "GetWindowTitle";
    public static String ACTIVATE = "ACTIVATE";
    public static String LOCALHOST = "127.0.0.1";

    public TcpServer(int port, IAppFrame frame, String file) {
        this(port, frame);
        this.file = file;
    }

    public TcpServer(int port, IAppFrame frame) {
        this.port = port;
        this.frame = frame;
    }

    public static boolean checkExistInstance(int port) {
        return TcpServer.ask(LOCALHOST, GETWINDOWTITLE, port);
    }

    private boolean ask(String host, String cmd) {
        return TcpServer.ask(host, cmd, this.port);
    }

    private static boolean ask(String host, String cmd, int port) {
        int timeout = 2000;
        Socket s = new Socket();
        try {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            s.connect(isa, timeout);
            OutputStream os = s.getOutputStream();
            os.write(cmd.getBytes());
            InputStream is = s.getInputStream();
            byte[] buffer = new byte[1024];
            int len = is.read(buffer);
            String res = new String(buffer, 0, len);
            if (StringUtils.isValidString(res)) {
                return true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    @Override
    public void run() {
        ServerSocket ss = null;
        try {
            try {
                boolean isExist = TcpServer.checkExistInstance(this.port);
                if (isExist) {
                    this.ask(LOCALHOST, ACTIVATE);
                    if (StringUtils.isValidString(this.file)) {
                        this.ask(LOCALHOST, this.file);
                    }
                    this.exit();
                }
                String[] ipStr = LOCALHOST.split("\\.");
                byte[] ipBuf = new byte[4];
                int i = 0;
                while (i < 4) {
                    ipBuf[i] = (byte)(Integer.parseInt(ipStr[i]) & 0xFF);
                    ++i;
                }
                InetAddress add = InetAddress.getByAddress(ipBuf);
                ss = new ServerSocket(this.port, 10, add);
                while (true) {
                    try {
                        while (true) {
                            Socket s;
                            InputStream is;
                            int len;
                            byte[] buffer;
                            String file;
                            if ((file = new String(buffer = new byte[1024], 0, len = (is = (s = ss.accept()).getInputStream()).read(buffer))).equals(GETWINDOWTITLE)) {
                                OutputStream os = s.getOutputStream();
                                String wTitle = ((JFrame)((Object)this.frame)).getTitle();
                                os.write(wTitle.getBytes());
                            } else if (file.equals(ACTIVATE)) {
                                ((JFrame)((Object)this.frame)).toFront();
                            } else {
                                if (file.startsWith("\"")) {
                                    file = file.substring(1, file.length() - 1);
                                }
                                final String sfile = file;
                                SwingUtilities.invokeLater(new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            TcpServer.this.frame.openSheetFile(sfile);
                                        }
                                        catch (Exception e) {
                                            GM.showException(GV.appFrame, e);
                                        }
                                    }
                                });
                            }
                            s.close();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                final String error = e.getMessage();
                SwingUtilities.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        GM.messageDialog(null, "Socket port: " + TcpServer.this.port + " creation failed: " + error);
                        TcpServer.this.exit();
                    }
                });
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    protected void exit() {
        System.exit(0);
    }
}

