/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.common.CellLocation;
import com.scudata.common.IByteMap;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.ide.common.GC;
import com.scudata.ide.common.GM;
import com.scudata.ide.common.GV;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.common.swing.RSyntaxTextAreaEx;
import com.scudata.ide.common.swing.ToolbarGradient;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public abstract class ToolBarPropertyBase
extends ToolbarGradient {
    private static final long serialVersionUID = 1L;
    public static final Dimension BT_SIZE = new Dimension(20, 25);
    public static final Dimension CELLPOS_SIZE = new Dimension(60, 25);
    public static final Dimension CELLEXP_SIZE = new Dimension(400, 25);
    public static final String IMAGE_EQUAL = "t_equal.gif";
    protected JTextField cellName = new JTextField();
    protected SpeedButton btEdit;
    protected byte selectState;
    public boolean preventAction = false;
    protected RSyntaxTextAreaEx textEditor = null;
    protected MessageManager mm = IdeCommonMessage.get();
    protected Font textEditorFont = GC.font;
    protected RTextScrollPane spEditor;
    protected JButton jBExt = new JButton();
    protected static final byte FORWARD_NONE = 0;
    protected static final byte UPWARD = 1;
    protected static final byte DOWNWARD = 2;

    public ToolBarPropertyBase() {
        super(IdeCommonMessage.get().getMessage("public.toolbar"));
        this.setFloatable(false);
        this.newTextEditor();
        this.spEditor = new RTextScrollPane((RTextArea)this.textEditor);
        this.spEditor.setLineNumbersEnabled(false);
        this.setLayout(new GridBagLayout());
        this.setToolTipText(this.mm.getMessage("public.toolbar"));
        this.cellName.setPreferredSize(CELLPOS_SIZE);
        this.cellName.setMaximumSize(CELLPOS_SIZE);
        this.cellName.setMinimumSize(CELLPOS_SIZE);
        this.cellName.setToolTipText(this.mm.getMessage("toolbarproperty.cellname"));
        this.cellName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String sCell = ToolBarPropertyBase.this.cellName.getText();
                    boolean hasSet = false;
                    String error = null;
                    if (StringUtils.isValidString(sCell)) {
                        sCell = sCell.toUpperCase();
                        Pattern p = Pattern.compile("[A-Z]+\\d+$");
                        Matcher m = p.matcher(sCell);
                        if (m.matches()) {
                            p = Pattern.compile("\\d");
                            m = p.matcher(sCell);
                            if (m.find()) {
                                int index = m.start();
                                String pre = sCell.substring(0, index);
                                String suffix = sCell.substring(index);
                                int row = Integer.parseInt(suffix);
                                int col = GM.getColByName(pre);
                                CellLocation maxCL = ToolBarPropertyBase.this.getMaxCellLocation();
                                if (row > maxCL.getRow()) {
                                    error = ToolBarPropertyBase.this.mm.getMessage("toolbarpropertybase.invalidrow");
                                } else if (col > maxCL.getCol()) {
                                    error = ToolBarPropertyBase.this.mm.getMessage("toolbarpropertybase.invalidcol");
                                } else {
                                    ToolBarPropertyBase.this.setActiveCell(row, col);
                                    hasSet = true;
                                }
                            }
                        } else {
                            error = ToolBarPropertyBase.this.mm.getMessage("toolbarpropertybase.invalidcell");
                        }
                    }
                    if (StringUtils.isValidString(error)) {
                        GM.messageDialog(GV.appFrame, error);
                    }
                    if (!hasSet) {
                        ToolBarPropertyBase.this.setCellName(ToolBarPropertyBase.this.getActiveCellId());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints gbc = GM.getGBC(1, 1);
        this.resetGBC(gbc);
        this.add((Component)this.cellName, gbc);
        gbc = GM.getGBC(2, 1);
        this.resetGBC(gbc);
        this.add((Component)this.getEmptyPanel(), gbc);
        this.btEdit = new SpeedButton(GM.getImageIcon("/com/scudata/ide/common/resources/t_equal.gif"), this.mm.getMessage("toolbarproperty.switch"), true);
        this.btEdit.setMinimumSize(BT_SIZE);
        this.btEdit.setMaximumSize(BT_SIZE);
        gbc = GM.getGBC(1, 2);
        this.resetGBC(gbc);
        this.add((Component)this.btEdit, gbc);
        gbc = GM.getGBC(2, 2);
        this.resetGBC(gbc);
        this.add((Component)this.getEmptyPanel(), gbc);
        this.btEdit.addMouseListener(new EqualMouseListener(this));
        gbc = GM.getGBC(1, 3, true, true);
        gbc.gridheight = 2;
        this.resetGBC(gbc);
        this.add((Component)this.spEditor, gbc);
        this.setEnabled(false, false);
        this.initProperties();
        this.textEditor.setEditable(true);
        this.setEditorFont(GC.font);
        this.textEditor.setToolTipText(this.mm.getMessage("toolbarproperty.cellexp"));
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        this.textEditor.getInputMap().put(enter, "none");
        this.textEditor.getDocument().addDocumentListener(new DocTextListener(this));
        this.jBExt.setMaximumSize(BT_SIZE);
        this.jBExt.setMinimumSize(BT_SIZE);
        this.jBExt.setPreferredSize(BT_SIZE);
        gbc = GM.getGBC(1, 4);
        this.resetGBC(gbc);
        this.add((Component)this.jBExt, gbc);
        gbc = GM.getGBC(2, 4);
        this.resetGBC(gbc);
        this.add((Component)this.getEmptyPanel(), gbc);
        this.jBExt.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_shiftdown.gif"));
        ActionListener extListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ToolBarPropertyBase.this.setToolBarExpand();
            }
        };
        this.jBExt.addActionListener(extListener);
        this.jBExt.registerKeyboardAction(extListener, KeyStroke.getKeyStroke(85, 192), 2);
    }

    protected void setCellName(String cellId) {
        try {
            this.cellName.setText(cellId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setEditorFont(Font font) {
        this.textEditorFont = font;
        this.textEditor.setFont(font);
    }

    public void init() {
    }

    protected void newTextEditor() {
        this.textEditor = new RSyntaxTextAreaEx(){
            private static final long serialVersionUID = 1L;

            public void requestFocus() {
                ToolBarPropertyBase.this.editorSelected();
                super.requestFocus();
            }
        };
    }

    public RSyntaxTextAreaEx getWindowEditor() {
        return this.textEditor;
    }

    protected abstract void setActiveCell(int var1, int var2);

    protected abstract CellLocation getMaxCellLocation();

    public void setExtendButtonIcon(boolean isExt) {
        if (isExt) {
            this.jBExt.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_shiftup.gif"));
        } else {
            this.jBExt.setIcon(GM.getImageIcon("/com/scudata/ide/common/resources/m_shiftdown.gif"));
        }
    }

    private JPanel getEmptyPanel() {
        JPanel p = new JPanel();
        Dimension d = new Dimension(1, 1);
        p.setMaximumSize(d);
        p.setMinimumSize(d);
        p.setPreferredSize(d);
        return p;
    }

    protected abstract void setToolBarExpand();

    private void resetGBC(GridBagConstraints gbc) {
        gbc.insets = new Insets(0, 0, 0, 0);
    }

    protected void enterPressed(KeyEvent e) {
        this.submitEditor(this.textEditor.getText(), (byte)(e.isControlDown() ? 0 : (e.isShiftDown() ? 1 : 2)));
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.preventAction) {
            return;
        }
        GV.cmdSender = this;
        this.textEdited(null);
    }

    public abstract void tabPressed();

    public abstract void refresh(byte var1, IByteMap var2);

    public abstract void setTextEditorText(String var1);

    public abstract void textEdited(KeyEvent var1);

    public abstract void editCancel();

    public abstract void editorSelected();

    public abstract Context getContext();

    protected abstract String getActiveCellId();

    public abstract void submitEditor(String var1, byte var2);

    public String getEditingText() {
        return this.textEditor.getText();
    }

    public void BtEdit_mouseClicked(MouseEvent e) {
        if (!this.btEdit.isEnabled()) {
            return;
        }
        if (this.preventAction) {
            return;
        }
        if (this.btEdit.isChecked()) {
            String text = this.textEditor.getText();
            if (text.startsWith("=")) {
                this.textEditor.setText(text.substring(1));
            } else {
                this.textEditor.setText("=" + text);
            }
            GV.cmdSender = this;
            this.textEditor.requestFocus();
            this.textEdited(null);
        }
    }

    protected void initProperties() {
        try {
            this.preventAction = true;
            this.setCellName("");
            this.textEditor.setText("");
        }
        catch (Exception ex) {
            this.preventAction = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, true);
    }

    protected void setEnabled(boolean enabled, boolean caseFuncWindow) {
        super.setEnabled(enabled);
        this.cellName.setEnabled(enabled);
        this.spEditor.setEnabled(enabled);
        this.textEditor.setEnabled(enabled);
        this.btEdit.setEnabled(enabled);
        this.jBExt.setEnabled(enabled);
        if (!enabled) {
            try {
                try {
                    this.preventAction = true;
                    this.cellName.setText(null);
                    this.textEditor.setText("");
                }
                catch (Exception exception) {
                    this.preventAction = false;
                }
            }
            finally {
                this.preventAction = false;
            }
        }
    }

    class DocTextListener
    implements DocumentListener {
        private ToolBarPropertyBase adaptee;

        public DocTextListener(ToolBarPropertyBase adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.adaptee.changedUpdate(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.adaptee.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.adaptee.changedUpdate(e);
        }
    }

    class EqualMouseListener
    extends MouseAdapter {
        ToolBarPropertyBase adaptee;

        public EqualMouseListener(ToolBarPropertyBase adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.adaptee.BtEdit_mouseClicked(e);
        }
    }

    class SpeedButton
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private boolean bChecked;

        public SpeedButton(Icon icon, String tip, boolean bToggle) {
            super(icon);
            this.bChecked = true;
            this.setToolTipText(tip);
            this.addMouseListener(new BtMouseAdapter(this));
        }

        public boolean isChecked() {
            return this.bChecked;
        }

        public void button_mouseClicked(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
        }

        public void button_mouseEntered(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }

        public void button_mouseExited(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public void button_mousePressed(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void button_mouseReleased(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setBorder(BorderFactory.createRaisedBevelBorder());
        }

        class BtMouseAdapter
        extends MouseAdapter {
            private SpeedButton adaptee;

            public BtMouseAdapter(SpeedButton button) {
                this.adaptee = button;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.adaptee.button_mouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.adaptee.button_mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.adaptee.button_mouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.adaptee.button_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.adaptee.button_mouseReleased(e);
            }
        }
    }
}

