/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common;

import com.scudata.app.common.Section;
import com.scudata.common.StringUtils;
import com.scudata.ide.common.resources.IdeCommonMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFile {
    public String xmlFile = null;
    private Document xmlDocument = null;

    public XMLFile(String file) throws Exception {
        this(new File(file), "root");
    }

    public XMLFile(File file, String root) throws Exception {
        if (file != null) {
            this.xmlFile = file.getAbsolutePath();
            if (file.exists() && file.isFile()) {
                this.loadXMLFile(new FileInputStream(file));
            } else {
                XMLFile.newXML(this.xmlFile, root);
            }
        } else {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.xmlDocument = docBuilder.newDocument();
            Element eRoot = this.xmlDocument.createElement(root);
            eRoot.normalize();
            this.xmlDocument.appendChild(eRoot);
        }
    }

    public XMLFile(InputStream is) throws Exception {
        this.loadXMLFile(is);
    }

    private void loadXMLFile(InputStream is) throws Exception {
        this.xmlDocument = XMLFile.parseXml(is);
    }

    public static XMLFile newXML(String file, String root) throws Exception {
        if (!XMLFile.isLegalXmlName(root)) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.falseroot", file, root));
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document sxmlDocument = docBuilder.newDocument();
        Element eRoot = sxmlDocument.createElement(root);
        eRoot.normalize();
        sxmlDocument.appendChild(eRoot);
        XMLFile.writeNodeToFile(sxmlDocument, file);
        return new XMLFile(file);
    }

    public Section listAll(String path) throws Exception {
        Section ss = new Section();
        Node tmpNode = this.getTerminalNode(path, (short)1);
        ss.unionSection(this.getNodesName(tmpNode.getChildNodes()));
        ss.unionSection(this.getNodesName(tmpNode.getAttributes()));
        return ss;
    }

    public Section listElement(String path) throws Exception {
        Node tmpNode = this.getTerminalNode(path, (short)1);
        return this.getNodesName(tmpNode.getChildNodes());
    }

    public Section listAttribute(String path) throws Exception {
        Node tmpNode = this.getTerminalNode(path, (short)1);
        return this.getNodesName(tmpNode.getAttributes());
    }

    public String getAttribute(String path) {
        try {
            Node tmpNode = this.getTerminalNode(path, (short)2);
            return tmpNode.getNodeValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String newElement(String path, String element) throws Exception {
        Element newElement = null;
        if (!XMLFile.isLegalXmlName(element)) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.falseelement", this.xmlFile, element));
        }
        Node parent = this.getTerminalNode(path, (short)1);
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase(element)) break;
            ++i;
        }
        if (i >= nl.getLength()) {
            newElement = this.xmlDocument.createElement(element);
            parent.appendChild(newElement);
        }
        return String.valueOf(path) + "/" + element;
    }

    public int newAttribute(String path, String attr) throws Exception {
        if (!XMLFile.isLegalXmlName(attr)) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.falseattr", this.xmlFile, attr));
        }
        Node parent = this.getTerminalNode(path, (short)1);
        NamedNodeMap nl = parent.getAttributes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equalsIgnoreCase(attr)) break;
            ++i;
        }
        if (i < nl.getLength()) {
            return -1;
        }
        ((Element)parent).setAttribute(attr, "");
        return 1;
    }

    public void delete(String path) throws Exception {
        this.deleteAttribute(path);
        this.deleteElement(path);
    }

    public void deleteElement(String path) throws Exception {
        Node nd = this.getTerminalNode(path, (short)1);
        Node parent = nd.getParentNode();
        parent.removeChild(nd);
    }

    public boolean isPathExists(String path) {
        try {
            this.getTerminalNode(path, (short)1);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void deleteAttribute(String path) throws Exception {
        int i = path.lastIndexOf(47);
        if (i <= 0) {
            return;
        }
        String p = path.substring(0, i);
        Node parent = this.getTerminalNode(p, (short)1);
        ((Element)parent).removeAttribute(path.substring(i + 1));
    }

    public void renameAttribute(String path, String newName) throws Exception {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.falsepath", this.xmlFile, path));
        }
        String value = this.getAttribute(path);
        this.deleteAttribute(path);
        this.setAttribute(String.valueOf(path.substring(0, i)) + "/" + newName, value);
    }

    public void renameElement(String path, String newName) throws Exception {
        NamedNodeMap childAttr;
        int i;
        if (path.lastIndexOf(47) == -1) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.renameroot", this.xmlFile));
        }
        Node nd = this.getTerminalNode(path, (short)1);
        Node pp = nd.getParentNode();
        NodeList childNodes = pp.getChildNodes();
        if (childNodes != null) {
            i = 0;
            while (i < childNodes.getLength()) {
                if (newName.equalsIgnoreCase(childNodes.item(i).getNodeName())) {
                    throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.existnode", this.xmlFile, newName));
                }
                ++i;
            }
        }
        Element newNode = this.xmlDocument.createElement(newName);
        childNodes = nd.getChildNodes();
        if (childNodes != null) {
            i = 0;
            while (i < childNodes.getLength()) {
                newNode.appendChild(childNodes.item(i));
                ++i;
            }
        }
        if ((childAttr = nd.getAttributes()) != null) {
            i = 0;
            while (i < childAttr.getLength()) {
                Node tmpNode = childAttr.item(i);
                newNode.setAttribute(tmpNode.getNodeName(), tmpNode.getNodeValue());
                ++i;
            }
        }
        pp.replaceChild(newNode, nd);
    }

    public void setAttribute(String path, String value) throws Exception {
        if (path == null) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.nullpath", this.xmlFile));
        }
        if (path.trim().length() == 0) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.nullpath", this.xmlFile));
        }
        if (value == null) {
            this.deleteAttribute(path);
            return;
        }
        int i = path.lastIndexOf(47);
        if (i > 0) {
            String p = path.substring(0, i);
            String v = path.substring(i + 1);
            this.newAttribute(p, v);
        }
        Node nd = this.getTerminalNode(path, (short)2);
        nd.setNodeValue(value);
    }

    public void save() throws Exception {
        this.save(this.xmlFile);
    }

    public void save(String file) throws Exception {
        if (this.xmlDocument != null) {
            XMLFile.trimWhitespace(this.xmlDocument.getDocumentElement());
        }
        XMLFile.writeNodeToFile(this.xmlDocument, file);
    }

    public byte[] getFileBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLFile.outputDocument(this.xmlDocument, baos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public void save(OutputStream os) throws Exception {
        if (this.xmlDocument != null) {
            XMLFile.trimWhitespace(this.xmlDocument.getDocumentElement());
        }
        XMLFile.outputDocument(this.xmlDocument, os);
    }

    public static void writeNodeToFile(Document node, String file) throws Exception {
        XMLFile.outputDocument(node, file);
    }

    public static void outputDocument(Document node, Object out) throws Exception {
        StreamResult result;
        if (out instanceof String) {
            result = new StreamResult((String)out);
        } else if (out instanceof OutputStream) {
            result = new StreamResult((OutputStream)out);
        } else if (out instanceof Writer) {
            result = new StreamResult((Writer)out);
        } else {
            return;
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        Properties properties = transformer.getOutputProperties();
        properties.setProperty("encoding", "UTF-8");
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        transformer.setOutputProperties(properties);
        DOMSource source = new DOMSource(node);
        transformer.transform(source, result);
    }

    public static void trimWhitespace(Node node) {
        if (node == null) {
            return;
        }
        try {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child != null) {
                    String content;
                    if (child.getNodeType() == 3 && (content = child.getTextContent()) != null && !StringUtils.isValidString(content)) {
                        child.setTextContent("");
                    }
                    XMLFile.trimWhitespace(child);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Section getNodesName(Object obj) throws Exception {
        int i;
        Section ss = new Section();
        if (obj == null) {
            return ss;
        }
        Node nd = null;
        if (obj instanceof NodeList) {
            NodeList nl = (NodeList)obj;
            i = 0;
            while (i < nl.getLength()) {
                nd = nl.item(i);
                if (nd.getNodeType() == 1) {
                    ss.unionSection(nd.getNodeName());
                }
                ++i;
            }
        }
        if (obj instanceof NamedNodeMap) {
            NamedNodeMap nnm = (NamedNodeMap)obj;
            i = 0;
            while (i < nnm.getLength()) {
                nd = nnm.item(i);
                ss.unionSection(nd.getNodeName());
                ++i;
            }
        }
        return ss;
    }

    private Node locateNode(Object obj, String nodeName) throws Exception {
        String sTmp;
        int i = 0;
        int j = 0;
        Node tmpNode = null;
        if (obj instanceof NodeList) {
            NodeList nl = (NodeList)obj;
            i = nl.getLength();
            j = 0;
            while (j < i) {
                tmpNode = nl.item(j);
                sTmp = tmpNode.getNodeName();
                if (sTmp.equalsIgnoreCase(nodeName)) break;
                ++j;
            }
        }
        if (obj instanceof NamedNodeMap) {
            NamedNodeMap nnm = (NamedNodeMap)obj;
            i = nnm.getLength();
            j = 0;
            while (j < i) {
                tmpNode = nnm.item(j);
                sTmp = tmpNode.getNodeName();
                if (sTmp.equalsIgnoreCase(nodeName)) break;
                ++j;
            }
        }
        if (j == i) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.falsenodename", this.xmlFile, nodeName));
        }
        return tmpNode;
    }

    private Node getTerminalNode(String path, short type) throws Exception {
        Node tmpNode = null;
        if (path == null) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.nullpath1", this.xmlFile));
        }
        int i = path.lastIndexOf(47);
        if (i == -1) {
            if (path.length() == 0) {
                return this.xmlDocument;
            }
            String sNode = path;
            if (type == 1) {
                tmpNode = this.locateNode(this.xmlDocument.getChildNodes(), sNode);
            }
        } else {
            String sLast = path.substring(i + 1);
            path = path.substring(0, i);
            StringTokenizer st = new StringTokenizer(path, "/");
            NodeList childNodes = this.xmlDocument.getChildNodes();
            while (st.hasMoreTokens()) {
                String sNode = st.nextToken();
                tmpNode = this.locateNode(childNodes, sNode);
                if (tmpNode == null) {
                    throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.notexistpath", this.xmlFile, path));
                }
                childNodes = tmpNode.getChildNodes();
            }
            tmpNode = type == 1 ? this.locateNode(tmpNode.getChildNodes(), sLast) : this.locateNode(tmpNode.getAttributes(), sLast);
        }
        if (tmpNode == null) {
            throw new Exception(IdeCommonMessage.get().getMessage("xmlfile.notexistpath", this.xmlFile, path));
        }
        return tmpNode;
    }

    public static boolean isLegalXmlName(String input) {
        return input != null && input.length() != 0;
    }

    public static Document parseXml(InputStream is) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(is);
    }

    public static Element getChild(Node parent, String childName) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node != null && node.getNodeType() == 1 && childName.equalsIgnoreCase(node.getNodeName())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildren(Node parent, String childName) {
        NodeList list = parent.getChildNodes();
        if (list == null) {
            return null;
        }
        ArrayList<Element> childList = new ArrayList<Element>();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node != null && node.getNodeType() == 1 && childName.equalsIgnoreCase(node.getNodeName())) {
                childList.add((Element)node);
            }
            ++i;
        }
        if (childList.isEmpty()) {
            return null;
        }
        return childList;
    }
}

