/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.ide.common.control;

import com.scudata.common.Area;
import com.scudata.common.CellLocation;

public class CellRect {
    Area area;
    boolean setTop = false;
    boolean setBottom = false;
    boolean setLeft = false;
    boolean setRight = false;
    private static final byte LEFT_TOP = 0;
    private static final byte LEFT_BOTTOM = 1;
    private static final byte RIGHT_TOP = 2;
    private static final byte RIGHT_BOTTOM = 3;

    public CellRect() {
        this(new Area(0, 0));
    }

    public CellRect(Area a) {
        this.area = (Area)a.deepClone();
    }

    public CellRect(int beginRow, int beginCol, int rowCount, int colCount) {
        this.area = new Area(beginRow, beginCol, beginRow + rowCount - 1, beginCol + colCount - 1);
    }

    public CellRect(boolean left, boolean right, boolean top, boolean bottom) {
        this.area = new Area(0, 0);
        this.setTop = top;
        this.setLeft = left;
        this.setRight = right;
        this.setBottom = bottom;
    }

    public Area getArea() {
        return this.area;
    }

    public void offset(int rows, int cols) {
        int rr = this.getRowCount();
        int cc = this.getColCount();
        this.area.setBeginRow(this.area.getBeginRow() + rows);
        this.area.setBeginCol(this.area.getBeginCol() + cols);
        this.setRowCount(rr);
        this.setColCount(cc);
    }

    public int[] getRowsId() {
        int[] rows = new int[this.getRowCount()];
        int r = 0;
        while (r < this.getRowCount()) {
            rows[r] = this.area.getBeginRow() + r;
            ++r;
        }
        return rows;
    }

    public int[] getColsId() {
        int[] cols = new int[this.getColCount()];
        int c = 0;
        while (c < this.getColCount()) {
            cols[c] = this.area.getBeginCol() + c;
            ++c;
        }
        return cols;
    }

    public void setColCount(int count) {
        this.area.setEndCol(this.area.getBeginCol() + count - 1);
    }

    public void setRowCount(int count) {
        this.area.setEndRow(this.area.getBeginRow() + count - 1);
    }

    public boolean isSetLeft() {
        return this.setLeft;
    }

    public boolean isSetRight() {
        return this.setRight;
    }

    public boolean isSetTop() {
        return this.setTop;
    }

    public boolean isSetBottom() {
        return this.setBottom;
    }

    public void setLeft(boolean set) {
        this.setLeft = set;
    }

    public void setRight(boolean set) {
        this.setRight = set;
    }

    public void setTop(boolean set) {
        this.setTop = set;
    }

    public void setBottom(boolean set) {
        this.setBottom = set;
    }

    public int getRowCount() {
        return this.area.getEndRow() - this.area.getBeginRow() + 1;
    }

    public int getColCount() {
        return this.area.getEndCol() - this.area.getBeginCol() + 1;
    }

    public CellLocation getLeftTopPos() {
        return this.getCellLocation((byte)0);
    }

    public CellLocation getLeftBottomPos() {
        return this.getCellLocation((byte)1);
    }

    public CellLocation getRightTopPos() {
        return this.getCellLocation((byte)2);
    }

    public CellLocation getRightBottomPos() {
        return this.getCellLocation((byte)3);
    }

    public String toString() {
        return "BeginRow=" + this.area.getBeginRow() + ";BeginCol=" + this.area.getBeginCol() + ";EndRow=" + this.area.getEndRow() + ";EndCol=" + this.area.getEndCol();
    }

    public int getBeginRow() {
        return this.area.getBeginRow();
    }

    public int getBeginCol() {
        return this.area.getBeginCol();
    }

    public int getEndRow() {
        return this.area.getEndRow();
    }

    public int getEndCol() {
        return this.area.getEndCol();
    }

    private CellLocation getCellLocation(byte pos) {
        CellLocation cp = new CellLocation(0, 0);
        switch (pos) {
            case 2: {
                cp.setRow(this.area.getBeginRow());
                cp.setCol(this.area.getEndCol());
                break;
            }
            case 3: {
                cp.setRow(this.area.getEndRow());
                cp.setCol(this.area.getEndCol());
                break;
            }
            case 1: {
                cp.setRow(this.area.getEndRow());
                cp.setCol(this.area.getBeginCol());
                break;
            }
            case 0: {
                cp.setRow(this.area.getBeginRow());
                cp.setCol(this.area.getBeginCol());
            }
        }
        return cp;
    }
}

